/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.world;

import com.mattdahepic.mdecore.MDECore;
import com.mattdahepic.mdecore.config.MDEConfig;
import com.mattdahepic.mdecore.helpers.WorldHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.HashMap;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class WorldEventHandler {
    public static WorldEventHandler instance = new WorldEventHandler();
    public static HashMap<Integer, ArrayDeque<ChunkPos>> chunksToGenerate = new HashMap();
    public static HashMap<Integer, ArrayDeque<ChunkPos>> chunksToDelete = new HashMap();
    public static boolean pregenPause = false;
    private static boolean lagPause = false;

    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER) {
            return;
        }
        World world = event.world;
        int dim = world.field_73011_w.getDimension();
        ChunkProviderServer cps = world.func_73046_m().func_71218_a(dim).func_72863_F();
        ArrayDeque<ChunkPos> chunks = chunksToGenerate.get(dim);
        if (chunks != null && chunks.size() > 0) {
            if (WorldHelper.getTps(world.func_73046_m(), world) < MDEConfig.pregenMinTPS) {
                if (!lagPause) {
                    MDECore.logger.info("TPS below configured minimum, pausing pregeneration.");
                    lagPause = true;
                }
            } else if (lagPause) {
                MDECore.logger.info("TPS is above configured minimum, resuming pregeneration.");
                lagPause = false;
            }
            if (!pregenPause && !lagPause) {
                ChunkPos c = chunks.pollFirst();
                if (!cps.func_73149_a(c.field_77276_a, c.field_77275_b) && !cps.func_186025_d(c.field_77276_a, c.field_77275_b).func_150802_k()) {
                    MDECore.logger.info("PreGening " + c.toString() + ".");
                    cps.func_186025_d(c.field_77276_a, c.field_77275_b).func_76601_a(true);
                    cps.func_186025_d(c.field_77276_a + 1, c.field_77275_b).func_76601_a(true);
                    cps.func_186025_d(c.field_77276_a, c.field_77275_b + 1).func_76601_a(true);
                    cps.func_186025_d(c.field_77276_a + 1, c.field_77275_b + 1).func_76601_a(true);
                }
            }
        } else if (chunks != null) {
            chunksToGenerate.remove(dim);
            cps.func_73240_a();
            MDECore.logger.info("PreGening complete!");
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (chunksToDelete.containsKey(world.field_73011_w.getDimension())) {
            ArrayDeque<ChunkPos> chunks = chunksToDelete.get(world.field_73011_w.getDimension());
            MDECore.logger.info("World " + world.field_73011_w.getDimension() + " unloaded, deleting " + chunks.size() + " chunks queued for deletion.");
            try {
                Field methodModifiers = Method.class.getDeclaredField("modifiers");
                methodModifiers.setAccessible(true);
                Method setOffsetMethod = WorldEventHandler.findMethod(RegionFile.class, new String[]{"setOffset", "func_76711_a"}, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                setOffsetMethod.setAccessible(true);
                setOffsetMethod = RegionFile.class.getDeclaredMethod("setOffset", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                methodModifiers.set(setOffsetMethod, 1);
                while (chunks != null && chunks.size() > 0) {
                    ChunkPos c = chunks.pollFirst();
                    RegionFile region = RegionFileCache.func_76550_a((File)world.func_72860_G().func_75765_b(), (int)c.field_77276_a, (int)c.field_77275_b);
                    if (region.chunkExists(c.field_77276_a, c.field_77275_b)) {
                        MDECore.logger.info("Deleting " + c.toString() + ".");
                        setOffsetMethod.invoke((Object)region, c.field_77276_a, c.field_77275_b, 0);
                        continue;
                    }
                    MDECore.logger.info("Chunk " + c.toString() + " already deleted or does not exist, skipping.");
                }
                chunksToDelete.remove(world.field_73011_w.getDimension());
                MDECore.logger.info("Finished deleting queued chunks for world " + world.field_73011_w.getDimension() + ".");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static <E> Method findMethod(Class<? super E> clazz, String[] methodNames, Class<?> ... methodTypes) {
        for (String methodName : methodNames) {
            try {
                Method m = clazz.getDeclaredMethod(methodName, methodTypes);
                m.setAccessible(true);
                return m;
            }
            catch (Exception exception) {
            }
        }
        throw new RuntimeException("Method not findable!");
    }
}

