/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class TickrateTransformer
implements IClassTransformer {
    public byte[] transform(String name, String name2, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            if (name.equals("net.minecraft.server.MinecraftServer")) {
                System.out.println("Patching net.minecraft.server.MinecraftServer class for tickrate changing...");
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(bytes);
                classReader.accept((ClassVisitor)classNode, 0);
                for (MethodNode method : classNode.methods) {
                    if (!method.name.equals("run") || !method.desc.equals("()V")) continue;
                    InsnList list = new InsnList();
                    for (AbstractInsnNode node : method.instructions.toArray()) {
                        if (node instanceof LdcInsnNode) {
                            LdcInsnNode ldcNode = (LdcInsnNode)node;
                            if (ldcNode.cst instanceof Long && (Long)ldcNode.cst == 50L) {
                                list.add((AbstractInsnNode)new FieldInsnNode(178, "com/mattdahepic/mdecore/helpers/TickrateHelper", "MILISECONDS_PER_TICK", "J"));
                                continue;
                            }
                        }
                        list.add(node);
                    }
                    method.instructions.clear();
                    method.instructions.add(list);
                }
                ClassWriter writer = new ClassWriter(3);
                classNode.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bytes;
    }
}

