/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.catsdogs.common.entity.felids;

import com.animania.addons.catsdogs.common.entity.felids.CatType;
import com.animania.addons.catsdogs.common.entity.felids.ai.EntityAICatAttack;
import com.animania.addons.catsdogs.config.CatsDogsConfig;
import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IAnimaniaAnimalBase;
import com.animania.api.interfaces.IConvertable;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIAvoidEntity;
import com.animania.common.entities.generic.ai.GenericAIEatGrass;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAIFollowOwner;
import com.animania.common.entities.generic.ai.GenericAILookIdle;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISit;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAITargetNonTamed;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.entities.generic.ai.GenericAIWatchClosest;
import com.animania.common.handler.AddonInjectionHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIOcelotSit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaCat
extends EntityOcelot
implements IAnimaniaAnimalBase,
IConvertable {
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaCat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaCat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaCat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaCat.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAnimaniaCat.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityAnimaniaCat.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> INTERACTED = EntityDataManager.func_187226_a(EntityAnimaniaCat.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final Set<ItemStack> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemStackArray((String[])CatsDogsConfig.catsdogs.catFood));
    protected int fedTimer;
    protected int wateredTimer;
    protected int happyTimer;
    protected int tamedTimer;
    public int blinkTimer;
    public int eatTimer;
    public GenericAIEatGrass<EntityAnimaniaCat> entityAIEatGrass;
    protected int damageTimer;
    public CatType type;
    public EntityGender gender;
    private EntityAIBase avoidEntity;

    public EntityAnimaniaCat(World worldIn) {
        super(worldIn);
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 80 + this.field_70146_Z.nextInt(80);
        this.func_110163_bv();
        this.entityAIEatGrass = new GenericAIEatGrass((EntityCreature)this, false);
        this.field_70714_bg.func_75776_a(11, this.entityAIEatGrass);
        this.initAI();
    }

    protected void initAI() {
        this.field_70911_d = new GenericAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new GenericAIFindWater((EntityCreature)this, 1.0, this.entityAIEatGrass, EntityAnimaniaCat.class, true));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new GenericAIFindFood((EntityCreature)this, 1.0, this.entityAIEatGrass, false));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(6, new EntityAICatAttack<EntityAnimaniaCat>(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new GenericAIFollowOwner((EntityTameable)this, 1.5, 5.0f, 30.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new GenericAIPanic((EntityCreature)this, 1.5));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new GenericAITempt((EntityCreature)this, 0.6, true, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new GenericAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new GenericAILookIdle((EntityLiving)this));
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(14, (EntityAIBase)new GenericAISleep((EntityCreature)this, 0.8, AnimaniaHelper.getBlock((String)CatsDogsConfig.catsdogs.catBed), AnimaniaHelper.getBlock((String)CatsDogsConfig.catsdogs.catBed2), EntityAnimaniaCat.class));
        }
        if (AnimaniaConfig.gameRules.animalsCanAttackOthers && !this.func_70909_n()) {
            AddonInjectionHandler.runInjection((String)"farm", (String)"attackChicks", null, (Object[])new Object[]{this});
            AddonInjectionHandler.runInjection((String)"extra", (String)"attackFrogs", null, (Object[])new Object[]{this});
            AddonInjectionHandler.runInjection((String)"extra", (String)"attackPeachicks", null, (Object[])new Object[]{this});
            AddonInjectionHandler.runInjection((String)"extra", (String)"attackRodents", null, (Object[])new Object[]{this});
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new GenericAITargetNonTamed((EntityTameable)this, EntityAnimal.class, false, entity -> entity instanceof EntitySilverfish));
        }
        this.field_70714_bg.field_75782_a.removeIf(task -> task.field_75733_a instanceof EntityAIOcelotSit);
    }

    protected void func_184651_r() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(INTERACTED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("IsTamed", this.func_70909_n());
        compound.func_74757_a("IsSitting", this.func_70906_o());
        GenericBehavior.writeCommonNBT((NBTTagCompound)compound, (EntityAnimal)this);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70903_f(compound.func_74767_n("IsTamed"));
        this.func_70904_g(compound.func_74767_n("IsSitting"));
        GenericBehavior.readCommonNBT((NBTTagCompound)compound, (EntityAnimal)this);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.5f);
    }

    public void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    @Override
    public DataParameter<Integer> getAgeParam() {
        return AGE;
    }

    @Override
    public DataParameter<Boolean> getHandFedParam() {
        return HANDFED;
    }

    @Override
    public DataParameter<Boolean> getSleepingParam() {
        return SLEEPING;
    }

    @Override
    public DataParameter<Float> getSleepTimerParam() {
        return SLEEPTIMER;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return GenericBehavior.interactCommon((EntityAnimal)this, (EntityPlayer)player, (EnumHand)hand, this.entityAIEatGrass) ? true : super.func_184645_a(player, hand);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && AnimaniaHelper.containsItemStack(TEMPTATION_ITEMS, (ItemStack)stack);
    }

    @Override
    public DataParameter<Boolean> getFedParam() {
        return FED;
    }

    @Override
    public DataParameter<Boolean> getWateredParam() {
        return WATERED;
    }

    public void func_70636_d() {
        if (this.func_70906_o() || this.func_184218_aH()) {
            if (this.func_184187_bx() != null) {
                this.field_70177_z = this.func_184187_bx().field_70177_z;
            }
            this.field_70699_by.func_75499_g();
            this.field_70699_by.func_75489_a(0.0);
        }
        GenericBehavior.livingUpdateCommon((EntityAnimal)this);
        super.func_70636_d();
    }

    protected void func_175544_ck() {
        if (this.avoidEntity == null) {
            this.avoidEntity = new GenericAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 16.0f, 0.8, 1.33);
        }
        this.field_70714_bg.func_85156_a(this.avoidEntity);
        if (!this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(4, this.avoidEntity);
        }
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && !this.getSleeping()) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    protected Item func_146068_u() {
        return null;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return true;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.02f, 1.5f);
    }

    public EntityOcelot func_90011_a(EntityAgeable ageable) {
        return null;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public Set<ItemStack> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public Item getSpawnEgg() {
        return (Item)ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.type, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    @Override
    public EntityGender getEntityGender() {
        return null;
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }

    @Override
    public int getEatTimer() {
        return this.eatTimer;
    }

    @Override
    public void setEatTimer(int i) {
        this.eatTimer = i;
    }

    @Override
    public int getFedTimer() {
        return this.fedTimer;
    }

    @Override
    public void setFedTimer(int i) {
        this.fedTimer = i;
    }

    @Override
    public DataParameter<Boolean> getInteractedParam() {
        return INTERACTED;
    }

    @Override
    public int getWaterTimer() {
        return this.wateredTimer;
    }

    @Override
    public void setWaterTimer(int i) {
        this.wateredTimer = i;
    }

    @Override
    public int getDamageTimer() {
        return this.damageTimer;
    }

    @Override
    public void setDamageTimer(int i) {
        this.damageTimer = i;
    }

    @Override
    public int getHappyTimer() {
        return this.happyTimer;
    }

    @Override
    public void setHappyTimer(int i) {
        this.happyTimer = i;
    }

    @Override
    public void setBlinkTimer(int i) {
        this.blinkTimer = i;
    }

    @Override
    public AnimaniaType getAnimalType() {
        return this.type;
    }

    @Override
    public Entity convertToVanilla() {
        EntityOcelot entity = new EntityOcelot(this.field_70170_p);
        entity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (entity.func_145818_k_()) {
            entity.func_96094_a(this.func_95999_t());
        }
        return entity;
    }
}

