/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.catsdogs.client.render.blocks;

import com.animania.addons.catsdogs.client.models.blocks.ModelPetBowl;
import com.animania.addons.catsdogs.common.tileentity.TileEntityPetBowl;
import com.animania.client.events.RenderEvents;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityPetBowlRenderer
extends TileEntitySpecialRenderer<TileEntityPetBowl> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("animania:textures/entity/tileentities/pet_bowl.png");
    public static TileEntityPetBowlRenderer instance;
    private final ModelPetBowl pet_bowl = new ModelPetBowl();
    private static Map<TileEntityPetBowl, Color> cachedColors;

    public void render(TileEntityPetBowl te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        FluidStack fluid;
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(te.func_145832_p() & 7));
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.5, (double)-1.5, (double)-0.5);
        GlStateManager.func_179089_o();
        this.func_147499_a(TEXTURE);
        this.pet_bowl.func_78088_a(null, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        if (te.getBowlContent() == TileEntityPetBowl.BowlContent.FOOD) {
            Color foodColor;
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack item = te.itemHandler.getStackInSlot(0);
            if (RenderEvents.ticks % 20L == 0L) {
                foodColor = this.getAverageColor(item);
                cachedColors.put(te, foodColor);
            }
            if ((foodColor = cachedColors.get(te)) == null) {
                foodColor = this.getAverageColor(item);
                cachedColors.put(te, foodColor);
            }
            float[] rgb = new float[3];
            foodColor.getRGBColorComponents(rgb);
            this.pet_bowl.setColor(rgb[0], rgb[1], rgb[2]);
            GlStateManager.func_179139_a((double)1.2, (double)1.2, (double)1.2);
            GlStateManager.func_179137_b((double)0.0, (double)(-0.12 - (double)(item.func_190916_E() - 1) * 0.04), (double)0.0);
            this.pet_bowl.renderFood(0.0625f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        if (te.getBowlContent() == TileEntityPetBowl.BowlContent.LIQUID && (fluid = te.fluidHandler.getFluid()) != null) {
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getStill().toString());
            ResourceLocation loc = new ResourceLocation(fluid.getFluid().getStill().func_110624_b() + ":textures/" + fluid.getFluid().getStill().func_110623_a() + ".png");
            double multi = (double)fluid.amount / 1000.0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.4, (double)1.405, (double)-0.3);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179137_b((double)0.0, (double)(-0.155 * multi), (double)0.0);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            TileEntityPetBowlRenderer.drawOctagon(-0.65, 0.05, sprite, 0.21);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    public void func_147497_a(TileEntityRendererDispatcher rendererDispatcherIn) {
        super.func_147497_a(rendererDispatcherIn);
        instance = this;
    }

    private static void drawOctagon(double x, double y, TextureAtlasSprite textureSprite, double len) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        double u = textureSprite.func_94212_f() - textureSprite.func_94209_e();
        double v = textureSprite.func_94210_h() - textureSprite.func_94206_g();
        double u1 = textureSprite.func_94212_f();
        double v1 = textureSprite.func_94210_h();
        double uLen = u * len;
        double vLen = v * len;
        double a = Math.sqrt(len * len / 2.0);
        double b = Math.sqrt(uLen * uLen / 2.0);
        double c = Math.sqrt(vLen * vLen / 2.0);
        bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181710_j);
        bufferbuilder.func_181662_b(x + a, y, 0.0).func_187315_a(u1 - b, v1).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + a + len, y, 0.0).func_187315_a(u1 - b - uLen, v1).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + 2.0 * a + len, y + a, 0.0).func_187315_a(u1 - 2.0 * b - uLen, v1 - c).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + 2.0 * a + len, y + a + len, 0.0).func_187315_a(u1 - 2.0 * b - uLen, v1 - c - vLen).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + a + len, y + 2.0 * a + len, 0.0).func_187315_a(u1 - b - uLen, v1 - 2.0 * c - vLen).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + a, y + 2.0 * a + len, 0.0).func_187315_a(u1 - b, v1 - 2.0 * c - vLen).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x, y + a + len, 0.0).func_187315_a(u1, v1 - c - vLen).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x, y + a, 0.0).func_187315_a(u1, v1 - c).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public Color getAverageColor(ItemStack item) {
        BufferedImage image;
        try {
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175599_af().func_184393_a(item, null, null).func_177554_e();
            ResourceLocation loc = new ResourceLocation(sprite.func_94215_i().replace(":", ":textures/") + ".png");
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc).func_110527_b();
            image = ImageIO.read(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Color(0, 0, 0);
        }
        int x1 = image.getWidth();
        int y1 = image.getHeight();
        double sumr = 0.0;
        double sumg = 0.0;
        double sumb = 0.0;
        for (int x = 0; x < x1; ++x) {
            for (int y = 0; y < y1; ++y) {
                Color pixel = new Color(image.getRGB(x, y), true);
                double alpha = (double)pixel.getAlpha() / 255.0;
                sumr += (double)pixel.getRed() * alpha;
                sumg += (double)pixel.getGreen() * alpha;
                sumb += (double)pixel.getBlue() * alpha;
            }
        }
        int num = image.getWidth() * image.getHeight();
        return new Color((int)sumr / num, (int)sumg / num, (int)sumb / num).brighter().brighter().brighter();
    }

    static {
        cachedColors = new HashMap<TileEntityPetBowl, Color>();
    }
}

