/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.util;

import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.invpanel.invpanel.TileInventoryPanel;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StoredCraftingRecipe {
    @Nonnull
    private final NNList<ItemStack> slots = new NNList(9, (Object)ItemStack.field_190927_a);
    private boolean updateResult;
    @Nonnull
    private ItemStack result = ItemStack.field_190927_a;

    public boolean loadFromCraftingGrid(List<Slot> craftingGrid) {
        if (craftingGrid.size() != 9) {
            return false;
        }
        int count = 0;
        for (int slotIdx = 0; slotIdx < 9 && slotIdx < craftingGrid.size(); ++slotIdx) {
            Slot slot = craftingGrid.get(slotIdx);
            ItemStack stack = slot.func_75211_c();
            if (stack.func_190926_b()) continue;
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            this.slots.set(slotIdx, (Object)stack);
            ++count;
        }
        this.updateResult = true;
        return count > 0;
    }

    @Nonnull
    public ItemStack get(int index) {
        return (ItemStack)this.slots.get(index);
    }

    public boolean isEqual(List<Slot> craftingGrid) {
        for (int slotIdx = 0; slotIdx < 9; ++slotIdx) {
            ItemStack a = (ItemStack)this.slots.get(slotIdx);
            ItemStack b = craftingGrid.get(slotIdx).func_75211_c();
            if (a.func_190926_b() && b.func_190926_b() || ItemUtil.areStacksEqual((ItemStack)a, (ItemStack)b)) continue;
            return false;
        }
        return true;
    }

    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        for (int slotIdx = 0; slotIdx < 9; ++slotIdx) {
            ItemStack itemStack = (ItemStack)this.slots.get(slotIdx);
            if (itemStack.func_190926_b()) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStack.func_77955_b(itemStackNBT);
            nbtRoot.func_74782_a(Integer.toString(slotIdx), (NBTBase)itemStackNBT);
        }
    }

    public boolean readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        boolean hasSlots = false;
        for (int slotIdx = 0; slotIdx < 9; ++slotIdx) {
            NBTTagCompound itemStackNBT = (NBTTagCompound)NullHelper.untrust((Object)nbtRoot.func_74781_a(Integer.toString(slotIdx)));
            if (itemStackNBT != null) {
                this.slots.set(slotIdx, (Object)new ItemStack(itemStackNBT));
                hasSlots = true;
                continue;
            }
            this.slots.set(slotIdx, (Object)ItemStack.field_190927_a);
        }
        this.updateResult = true;
        this.result = ItemStack.field_190927_a;
        return hasSlots;
    }

    @Nonnull
    public ItemStack getResult(@Nonnull TileInventoryPanel te) {
        if (this.updateResult) {
            this.findCraftingResult(te);
        }
        return this.result;
    }

    private void findCraftingResult(@Nonnull TileInventoryPanel te) {
        InventoryCrafting tmp = new InventoryCrafting(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer ep) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            tmp.func_70299_a(i, (ItemStack)this.slots.get(i));
        }
        this.result = CraftingManager.func_82787_a((InventoryCrafting)tmp, (World)te.func_145831_w());
        if (!this.result.func_190926_b()) {
            this.result = this.result.func_77946_l();
            this.result.func_190920_e(1);
        }
        this.updateResult = false;
    }

    @Nonnull
    public NNList<ItemStack> getIngredients() {
        return this.slots;
    }
}

