/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.liquid;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.AbstractTankConduit;
import crazypants.enderio.conduits.conduit.liquid.AbstractTankConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.AdvancedLiquidConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.LiquidConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.LiquidOutput;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.conduits.render.ConduitTexture;
import crazypants.enderio.conduits.render.ConduitTextureWrapper;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvancedLiquidConduit
extends AbstractTankConduit {
    public static final int CONDUIT_VOLUME = 1000;
    public static final IConduitTexture ICON_KEY = new ConduitTexture(TextureRegistry.registerTexture("blocks/liquid_conduit"), ConduitTexture.arm(1));
    public static final IConduitTexture ICON_KEY_LOCKED = new ConduitTexture(TextureRegistry.registerTexture("blocks/liquid_conduit"), ConduitTexture.arm(2));
    public static final IConduitTexture ICON_CORE_KEY = new ConduitTexture(TextureRegistry.registerTexture("blocks/conduit_core_1"), ConduitTexture.core(1));
    public static final TextureRegistry.TextureSupplier ICON_EMPTY_EDGE = TextureRegistry.registerTexture("blocks/liquid_conduit_advanced_edge");
    private AdvancedLiquidConduitNetwork network;

    public AdvancedLiquidConduit() {
        this.updateTank();
    }

    @Override
    public void updateEntity(@Nonnull World world) {
        super.updateEntity(world);
        if (!world.field_72995_K && this.stateDirty) {
            this.getBundle().dirty();
            this.stateDirty = false;
        }
    }

    @Override
    protected boolean doExtract(@Nonnull EnumFacing dir) {
        return this.network.extractFrom(this, dir, (Integer)ConduitConfig.fluid_tier2_extractRate.get());
    }

    @Override
    protected void updateTank() {
        this.tank.setCapacity(1000);
        if (this.network != null) {
            this.network.updateConduitVolumes();
        }
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(ConduitObject.item_liquid_conduit.getItemNN(), 1, 1);
    }

    @Nullable
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        if (!(network instanceof AdvancedLiquidConduitNetwork)) {
            return false;
        }
        AdvancedLiquidConduitNetwork n = (AdvancedLiquidConduitNetwork)network;
        if (this.tank.getFluid() == null) {
            this.tank.setLiquid(n.getFluidType() == null ? null : n.getFluidType().copy());
        } else if (n.getFluidType() == null) {
            n.setFluidType(this.tank.getFluid());
        } else if (!this.tank.getFluid().isFluidEqual(n.getFluidType())) {
            return false;
        }
        this.network = n;
        return super.setNetwork(network);
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Override
    public boolean canConnectToConduit(@Nonnull EnumFacing direction, @Nonnull IConduit con) {
        if (!super.canConnectToConduit(direction, con)) {
            return false;
        }
        if (!(con instanceof AdvancedLiquidConduit)) {
            return false;
        }
        if (this.getFluidType() != null && ((AdvancedLiquidConduit)con).getFluidType() == null) {
            return false;
        }
        return LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), ((AdvancedLiquidConduit)con).getFluidType());
    }

    @Override
    public void setConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.refreshInputs(dir);
    }

    @Override
    public void setExtractionRedstoneMode(@Nonnull RedstoneControlMode mode, @Nonnull EnumFacing dir) {
        super.setExtractionRedstoneMode(mode, dir);
        this.refreshInputs(dir);
    }

    private void refreshInputs(@Nonnull EnumFacing dir) {
        if (this.network == null) {
            return;
        }
        LiquidOutput lo = new LiquidOutput(this.getBundle().getLocation().func_177972_a(dir), dir.func_176734_d());
        this.network.removeInput(lo);
        if (this.canInputToDir(dir) && this.containsExternalConnection(dir)) {
            this.network.addInput(lo);
        }
    }

    @Override
    public void externalConnectionAdded(@Nonnull EnumFacing fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.refreshInputs(fromDirection);
    }

    @Override
    public void externalConnectionRemoved(@Nonnull EnumFacing fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.refreshInputs(fromDirection);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IConduitTexture getTextureForState(@Nonnull CollidableComponent component) {
        if (component.isCore()) {
            return ICON_CORE_KEY;
        }
        if ("ColorController".equals(component.data)) {
            return new ConduitTextureWrapper(IconUtil.instance.whiteTexture);
        }
        return this.fluidTypeLocked ? ICON_KEY_LOCKED : ICON_KEY;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getNotSetEdgeTexture() {
        return ICON_EMPTY_EDGE.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public IConduitTexture getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        if (this.isActive() && this.tank.containsValidLiquid()) {
            return new ConduitTextureWrapper(RenderUtil.getStillTexture((FluidStack)this.tank.getFluid()));
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        if (this.isActive() && this.tank.containsValidLiquid()) {
            int color = this.tank.getFluid().getFluid().getColor(this.tank.getFluid());
            return new Vector4f((double)(color >> 16 & 0xFF) / 255.0, (double)(color >> 8 & 0xFF) / 255.0, (double)(color & 0xFF) / 255.0, 1.0);
        }
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.network == null) {
            return new FluidTankProperties[0];
        }
        return new FluidTankProperties[]{new FluidTankProperties(this.tank.getFluid(), this.tank.getCapacity())};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.network.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.network.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.network.drain(maxDrain, doDrain);
    }

    @Override
    protected boolean canJoinNeighbour(ILiquidConduit n) {
        return n instanceof AdvancedLiquidConduit;
    }

    @Override
    public AbstractTankConduitNetwork<? extends AbstractTankConduit> getTankNetwork() {
        return this.network;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        FluidStack fluidType = this.getFluidType();
        if (fluidType != null && fluidType.getFluid() != null) {
            hashCodes.add(fluidType.getFluid());
        }
        hashCodes.addEnum(this.extractionColors);
        hashCodes.addEnum(this.extractionModes);
    }

    @Nonnull
    public AdvancedLiquidConduitNetwork createNetworkForType() {
        return new AdvancedLiquidConduitNetwork();
    }

    @Override
    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        EnumFacing keydir = key.dir;
        if (keydir == null) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.getInstance().createBoundsForConnectionController(keydir, key.offset);
        CollidableComponent cc = new CollidableComponent(ILiquidConduit.class, bb, keydir, "ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        result.add(cc);
        return result;
    }
}

