/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.loader;

import cc.polyfrost.oneconfig.loader.OneConfigWrapperBase;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class OneConfigLoaderBase
extends OneConfigWrapperBase {
    private long timeLast = System.currentTimeMillis();
    private float downloadPercent = 0.0f;
    private static final Logger logger = LogManager.getLogger((String)"OneConfigLoader");
    private Throwable error = null;

    public OneConfigLoaderBase() {
        try {
            OneConfigWrapperBase.LoaderInfo loaderInfo = this.provideLoaderInfo();
            System.out.println("OneConfig has detected the version " + loaderInfo.mcVersion + ". If this is false, report this at https://inv.wtf/polyfrost");
            File oneconfigFile = this.provideFile(loaderInfo);
            if (!this.isInitialized(oneconfigFile) && this.shouldUpdate()) {
                JsonElement json = OneConfigLoaderBase.getLoaderRequest("https://api.polyfrost.org/oneconfig/" + loaderInfo.mcVersion + "-" + loaderInfo.modLoader);
                if (json != null && json.isJsonObject()) {
                    JsonObject jsonObject = json.getAsJsonObject();
                    OneConfigWrapperBase.JsonInfo jsonInfo = this.provideJsonInfo(jsonObject, loaderInfo);
                    if (!(!jsonInfo.success || oneconfigFile.exists() && jsonInfo.checksum.equals(this.getChecksum(oneconfigFile)))) {
                        System.out.println("Updating OneConfig " + loaderInfo.stageLoading + "...");
                        File newLoaderFile = new File(oneconfigFile.getParentFile(), oneconfigFile.getName().substring(0, oneconfigFile.getName().lastIndexOf(".")) + "-NEW.jar");
                        this.downloadFile(jsonInfo.downloadUrl, newLoaderFile);
                        if (newLoaderFile.exists() && jsonInfo.checksum.equals(this.getChecksum(newLoaderFile))) {
                            try {
                                Files.move(newLoaderFile.toPath(), oneconfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                System.out.println("Updated OneConfig " + loaderInfo.stageLoading + "!");
                            }
                            catch (IOException iOException) {}
                        } else {
                            if (newLoaderFile.exists()) {
                                newLoaderFile.delete();
                            }
                            System.out.println("Failed to update OneConfig " + loaderInfo.stageLoading + ", trying to continue...");
                        }
                    }
                }
                if (!oneconfigFile.exists()) {
                    this.showErrorScreen();
                }
                this.addToClasspath(oneconfigFile);
            }
            if (!this.getNextInstance()) {
                this.showErrorScreen();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showErrorScreen();
        }
    }

    protected static JsonElement getLoaderRequest(String site) {
        try {
            String inputLine;
            URL url = new URL(site);
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OneConfigLoader");
            con.setRequestMethod("GET");
            con.setConnectTimeout(15000);
            con.setReadTimeout(15000);
            int status = con.getResponseCode();
            if (status != 200) {
                System.out.println("API request failed, status code " + status);
                return null;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            JsonParser parser = new JsonParser();
            return parser.parse(content.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void downloadFile(String url, File location) {
        Frame ui = null;
        try {
            ui = new Frame();
        }
        catch (Exception e) {
            logger.error("Continuing without GUI", (Throwable)e);
        }
        try {
            HttpsURLConnection con = (HttpsURLConnection)new URL(url).openConnection();
            con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OneConfigLoader");
            con.setRequestMethod("GET");
            con.setConnectTimeout(15000);
            con.setReadTimeout(15000);
            con.setDoOutput(true);
            int length = con.getContentLength();
            if (location.exists() && !location.delete()) {
                throw new RuntimeException("Could not delete old version of OneConfig! (" + location.getAbsolutePath() + ")");
            }
            if (!location.createNewFile()) {
                throw new RuntimeException("Could not create file! (" + location.getAbsolutePath() + ")");
            }
            logger.info("Downloading new version of OneConfig... (" + (float)length / 1024.0f + "KB)");
            Thread downloader = new Thread(() -> {
                try (InputStream in = con.getInputStream();){
                    Files.copy(in, location.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    this.error = e;
                }
            });
            downloader.start();
            while (this.downloadPercent < 1.0f) {
                if (this.error != null) {
                    throw new RuntimeException(this.error);
                }
                this.downloadPercent = (float)location.length() / (float)length;
                if (ui != null) {
                    ui.update(this.downloadPercent);
                }
                if (System.currentTimeMillis() - this.timeLast <= 1000L) continue;
                this.timeLast = System.currentTimeMillis();
                logger.info("Downloaded " + (float)location.length() / 1024.0f + "KB out of " + (float)length / 1024.0f + "KB (" + this.downloadPercent * 100.0f + "%)");
            }
            logger.info("Download finished successfully");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ui != null) {
                ui.dispose();
            }
        }
    }

    private static class Frame
    extends JFrame {
        private final DownloadUI downloadUI = new DownloadUI();

        public Frame() {
            super("OneConfig");
            this.setAlwaysOnTop(true);
            this.setResizable(false);
            BufferedImage icon = null;
            try {
                icon = ImageIO.read(Objects.requireNonNull(this.getClass().getResourceAsStream("/assets/oneconfig-loader/oneconfig-icon.png")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setAlwaysOnTop(true);
            this.setResizable(false);
            this.setIconImage(icon);
            this.setDefaultCloseOperation(0);
            this.setUndecorated(true);
            this.setSize(400, 150);
            this.setLocationRelativeTo(null);
            this.setBackground(new Color(0, 0, 0, 0));
            this.add(this.downloadUI);
            this.pack();
            this.setVisible(true);
        }

        public void update(float progress) {
            this.downloadUI.update(progress);
            this.repaint();
        }
    }

    private static class DownloadUI
    extends JPanel {
        private BufferedImage logo;
        private float progress = 0.0f;
        private final DecimalFormat df = new DecimalFormat("#.##");

        public DownloadUI() {
            try {
                this.logo = ImageIO.read(Objects.requireNonNull(this.getClass().getResourceAsStream("/assets/oneconfig-loader/oneconfig.png")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setBackground(new Color(0, 0, 0, 0));
            this.setPreferredSize(new Dimension(400, 150));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(OneConfigWrapperBase.GRAY_900);
            g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 8, 8);
            g2d.drawImage(this.logo, 60, 32, 280, 33, null);
            g2d.setColor(OneConfigWrapperBase.GRAY_700);
            g2d.fillRoundRect(24, 126, 352, 8, 6, 6);
            g2d.setColor(OneConfigWrapperBase.PRIMARY_500);
            g2d.fillRoundRect(24, 126, (int)(352.0f * this.progress), 8, 6, 6);
            g2d.setColor(Color.WHITE);
            try {
                Font font = Font.createFont(0, Objects.requireNonNull(this.getClass().getResourceAsStream("/assets/oneconfig-loader/Regular.ttf")));
                g2d.setFont(font.deriveFont(this.getAdjustedFontSize(13.0f, font, g2d)));
            }
            catch (FontFormatException | IOException e) {
                e.printStackTrace();
                Font font = new Font("Arial", 0, 13);
                g2d.setFont(font.deriveFont(this.getAdjustedFontSize(13.0f, font, g2d)));
            }
            g2d.drawString("Downloading OneConfig...", 24, 118);
            String percentage = this.df.format(this.progress * 100.0f) + "%";
            g2d.drawString(percentage, 376 - g2d.getFontMetrics().stringWidth(percentage), 118);
            g2d.dispose();
        }

        public void update(float progress) {
            this.progress = progress;
            this.repaint();
        }

        private float getAdjustedFontSize(float fontSize, Font font, Graphics2D g2d) {
            return 16.0f / font.deriveFont(12.0f).getLineMetrics("", g2d.getFontRenderContext()).getHeight() * fontSize;
        }
    }
}

