/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.loader;

import cc.polyfrost.oneconfig.loader.OneConfigLoaderBase;
import cc.polyfrost.oneconfig.loader.OneConfigWrapperBase;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.common.ForgeVersion;

public class OneConfigLoader
extends OneConfigLoaderBase
implements ITweaker {
    private boolean update;
    private String channel;
    private static ITweaker loader = null;

    @Override
    protected OneConfigWrapperBase.LoaderInfo provideLoaderInfo() {
        boolean update = true;
        String channel = "release";
        try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(Files.newInputStream(new File(new File("./OneConfig"), "OneConfig.json").toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            JsonObject config = new JsonParser().parse((Reader)reader2).getAsJsonObject();
            update = config.get("autoUpdate").getAsBoolean();
            channel = config.get("updateChannel").getAsInt() == 0 ? "release" : "snapshot";
        }
        catch (Exception reader2) {
            // empty catch block
        }
        this.update = update;
        this.channel = channel;
        String mcVersion = "1.8.9";
        try {
            mcVersion = (String)ForgeVersion.class.getDeclaredField("mcVersion").get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Getting the Minecraft version failed, defaulting to 1.8.9. Please report this to https://inv.wtf/polyfrost");
        }
        return new OneConfigWrapperBase.LoaderInfo("Jar", mcVersion, "forge", "launchwrapper");
    }

    @Override
    protected boolean shouldUpdate() {
        return this.update;
    }

    @Override
    protected File provideFile(OneConfigWrapperBase.LoaderInfo loaderInfo) {
        File oneConfigDir = new File("./OneConfig");
        if (!oneConfigDir.exists() && !oneConfigDir.mkdirs()) {
            throw new IllegalStateException("Could not create OneConfig dir!");
        }
        return new File(oneConfigDir, "OneConfig (" + loaderInfo.mcVersion + "-" + loaderInfo.modLoader + ").jar");
    }

    @Override
    protected OneConfigWrapperBase.JsonInfo provideJsonInfo(JsonObject object, OneConfigWrapperBase.LoaderInfo loaderInfo) {
        try {
            if (object.has(this.channel) && object.getAsJsonObject(this.channel).has("url") && object.getAsJsonObject(this.channel).has("sha256")) {
                String checksum = object.getAsJsonObject(this.channel).get("sha256").getAsString();
                String downloadUrl = object.getAsJsonObject(this.channel).get("url").getAsString();
                return new OneConfigWrapperBase.JsonInfo(checksum, downloadUrl, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new OneConfigWrapperBase.JsonInfo(null, null, false);
    }

    @Override
    protected void addToClasspath(File file) {
        try {
            URL url = file.toURI().toURL();
            Launch.classLoader.addURL(url);
            ClassLoader classLoader = Launch.classLoader.getClass().getClassLoader();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean isInitialized(File file) {
        try {
            URL url = file.toURI().toURL();
            return Arrays.asList(((URLClassLoader)Launch.classLoader.getClass().getClassLoader()).getURLs()).contains(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected boolean getNextInstance() {
        try {
            loader = (ITweaker)Launch.classLoader.findClass("cc.polyfrost.oneconfig.internal.plugin.asm.OneConfigTweaker").newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loader != null;
    }

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        if (loader != null) {
            loader.acceptOptions(args, gameDir, assetsDir, profile);
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        if (loader != null) {
            loader.injectIntoClassLoader(classLoader);
        }
    }

    public String getLaunchTarget() {
        return loader != null ? loader.getLaunchTarget() : null;
    }

    public String[] getLaunchArguments() {
        return loader != null ? loader.getLaunchArguments() : new String[]{};
    }
}

