/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.block;

import li.cil.oc.api.network.Environment;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.block.BlockPeripheral;
import pl.asie.computronics.integration.railcraft.tile.TileDigitalDetector;
import pl.asie.computronics.oc.manual.IBlockWithPrefix;
import pl.asie.lib.block.BlockBase;
import pl.asie.lib.util.WorldUtils;

public class BlockDigitalDetector
extends BlockPeripheral
implements IBlockWithPrefix {
    public static final PropertyEnum<EnumFacing> FRONT = PropertyEnum.func_177709_a((String)"front", EnumFacing.class);
    private static final String prefix = "railcraft/";

    public BlockDigitalDetector() {
        super("digital_detector", BlockBase.Rotation.NONE);
        this.func_149663_c("computronics.detector");
        this.func_149752_b(4.5f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(Computronics.tab);
        this.setHarvestLevel("pickaxe", 2);
        this.setHarvestLevel("crowbar", 0);
    }

    @Override
    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos);
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileDigitalDetector) {
            return state.func_177226_a(FRONT, (Comparable)((TileDigitalDetector)t).direction);
        }
        return state;
    }

    @Override
    protected BlockStateContainer createActualBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{FRONT});
    }

    @Deprecated
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileDigitalDetector();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDigitalDetector) {
            ((TileDigitalDetector)tile).direction = MiscTools.getSideFacingPlayer((BlockPos)pos, (EntityLivingBase)placer);
            WorldUtils.notifyBlockUpdate(world, pos, state);
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDigitalDetector) {
            TileDigitalDetector detector = (TileDigitalDetector)tile;
            detector.direction = detector.direction == axis ? axis.func_176734_d() : axis;
            WorldUtils.notifyBlockUpdate(world, pos);
            return true;
        }
        return false;
    }

    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return EnumFacing.field_82609_l;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        WorldUtils.notifyBlockUpdate(world, pos, state);
        if (world.field_72995_K) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            world.func_175685_c(pos.func_177972_a(side), state.func_177230_c(), false);
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (world.field_72995_K) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            world.func_175685_c(pos.func_177972_a(side), state.func_177230_c(), false);
        }
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing sid) {
        return false;
    }

    @Override
    @Optional.Method(modid="opencomputers")
    public Class<? extends Environment> getTileEntityClass(int meta) {
        return TileDigitalDetector.class;
    }

    @Override
    public String getPrefix(World world, BlockPos pos) {
        return prefix;
    }

    @Override
    public String getPrefix(ItemStack stack) {
        return prefix;
    }
}

