/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.units.StateHashSet;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.ForgeWorld;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldSearch {

    public static class Column
    extends BlockChain {
        private static final List<EnumFacing> DIRECTIONS = Arrays.asList(EnumFacing.UP, EnumFacing.DOWN);
        private final BlockState validState;
        private BlockPos top;
        private BlockPos bottom;

        public static Column from(World world, BlockPos pos) {
            Column column = new Column(world, pos, ChunkBounds.DEFAULT_HEIGHT);
            column.build();
            return column;
        }

        protected Column(World world, BlockPos pos, int maxLength) {
            super(world, pos, maxLength);
            this.validState = ForgeWorld.getBlockState(world, pos);
            this.top = pos;
            this.bottom = pos;
        }

        @Override
        protected Collection<EnumFacing> getDirections() {
            return DIRECTIONS;
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            return this.isValidBlock(pos);
        }

        @Override
        protected boolean isValidBlock(BlockPos pos) {
            IBlockState state = this.world.func_180495_p(pos);
            return this.validState.getBlock() == state.func_177230_c();
        }

        @Override
        protected boolean onValidFound(BlockPos pos) {
            if (pos.func_177956_o() > this.top.func_177956_o()) {
                this.top = pos;
            }
            if (pos.func_177956_o() < this.bottom.func_177956_o()) {
                this.bottom = pos;
            }
            return true;
        }

        public BlockPos getTop() {
            return this.top;
        }

        public BlockPos getBottom() {
            return this.bottom;
        }
    }

    public static abstract class VentPipe
    extends BlockChain {
        public static final BlockChain.BlockFunc VALID_CHIMNEY_BLOCK = (world, pos) -> ForgeWorld.SmokeContainers.isChimney(world, pos);
        public static final BlockChain.BlockFunc VALID_CONDUCTOR_BLOCK = (world, pos) -> ForgeWorld.SmokeContainers.isVent(world, pos);
        private static List<EnumFacing> DIRECTIONS = Arrays.asList((Object[])ForgeWorld.Direction.CLOCKWISE_HORIZONTALS.clone());
        protected final int pumpsRequired;
        protected int pumpsCount;

        public VentPipe(World world, BlockPos startPos, int pumpsRequired) {
            super(world, startPos, ForgeWorld.SmokeContainers.maxVentPipeLength);
            this.pumpsRequired = pumpsRequired;
        }

        public static int pump(World world, List<BlockPos> startPositions, int pumpsRequired, BlockChain.BlockFunc validOutlet, PumpFunc onPump) {
            return VentPipe.pump(world, startPositions, pumpsRequired, VALID_CONDUCTOR_BLOCK, validOutlet, onPump);
        }

        public static int pump(World world, List<BlockPos> startPositions, int pumpsRequired, final BlockChain.BlockFunc validVent, final BlockChain.BlockFunc validOutlet, final PumpFunc onPump) {
            int count = 0;
            if (pumpsRequired <= 0) {
                return count;
            }
            ArrayList<1> ventPipes = new ArrayList<1>();
            block0: for (BlockPos pos : startPositions) {
                for (VentPipe ventPipe : ventPipes) {
                    if (!ventPipe.getChain().contains(pos)) continue;
                    continue block0;
                }
                VentPipe pipe = new VentPipe(world, pos, pumpsRequired){

                    @Override
                    protected boolean isValidPath(BlockPos pos) {
                        return validVent.apply(this.getWorld(), pos);
                    }

                    @Override
                    protected boolean isValidBlock(BlockPos pos) {
                        return validOutlet.apply(this.getWorld(), pos);
                    }

                    @Override
                    protected int onPump(BlockPos pos, int maxAmount) {
                        return onPump.apply(this.getWorld(), pos, maxAmount);
                    }
                };
                ventPipes.add(pipe);
                if ((count += pipe.pump().getPumpsCount()) < pumpsRequired) continue;
                return count;
            }
            return count;
        }

        public VentPipe pump() {
            this.pumpsCount = 0;
            super.build();
            return this;
        }

        @Override
        protected Collection<EnumFacing> getDirections() {
            return DIRECTIONS;
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            return ForgeWorld.SmokeContainers.isVent(this.world, pos);
        }

        @Override
        protected boolean onValidFound(BlockPos pos) {
            if (this.pumpsCount >= this.pumpsRequired) {
                return false;
            }
            this.pumpsCount += this.onPump(pos, this.pumpsRequired - this.pumpsCount);
            return this.pumpsCount < this.pumpsRequired;
        }

        public int getPumpsCount() {
            return this.pumpsCount;
        }

        protected abstract int onPump(BlockPos var1, int var2);

        @FunctionalInterface
        public static interface PumpFunc {
            public int apply(World var1, BlockPos var2, int var3);
        }
    }

    public static class TileNeighbors
    extends BlockChain {
        protected final List<BlockPos> aboveBlocks = new ArrayList<BlockPos>();
        protected final List<BlockPos> sideBlocks = new ArrayList<BlockPos>();
        protected final List<BlockPos> underBlocks = new ArrayList<BlockPos>();
        protected final Set<BlockState> relatedBlocks = new StateHashSet<BlockState>();
        protected IBlockState masterState;

        protected TileNeighbors(World world, BlockPos startPos, int maxBlocksInTile, Set<BlockState> relatedBlocks) {
            super(world, startPos, maxBlocksInTile);
            this.relatedBlocks.addAll(relatedBlocks);
        }

        public static TileNeighbors from(TileEntity tile, Set<BlockState> relatedBlocks) {
            TileNeighbors neighbours = new TileNeighbors(tile.func_145831_w(), tile.func_174877_v(), ForgeWorld.SmokeContainers.maxBlocksInMultiblock, relatedBlocks);
            neighbours.build();
            return neighbours;
        }

        public static TileNeighbors from(World world, BlockPos startPos, Set<BlockState> relatedBlocks) {
            TileNeighbors neighbours = new TileNeighbors(world, startPos, ForgeWorld.SmokeContainers.maxBlocksInMultiblock, relatedBlocks);
            neighbours.build();
            return neighbours;
        }

        @Override
        public void build() {
            this.masterState = this.world.func_180495_p(this.startPos);
            this.aboveBlocks.clear();
            this.sideBlocks.clear();
            this.underBlocks.clear();
            super.build();
        }

        public boolean isMultiblockHollow(BlockPos pos) {
            int minSideLen = 3;
            int maxSideLen = this.maxLength / 9;
            if (maxSideLen < 3) {
                return false;
            }
            int maxHollowLen = maxSideLen - 2;
            block0: for (EnumFacing facing : this.getDirections()) {
                for (int n = 1; n <= maxHollowLen; ++n) {
                    if (this.getChain().contains(pos.func_177967_a(facing, n))) continue block0;
                }
                return false;
            }
            return true;
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            if (this.lastUsedDirection == null) {
                return true;
            }
            IBlockState state = this.world.func_180495_p(pos);
            if (!this.relatedBlocks.isEmpty() && this.relatedBlocks.contains(BlockState.from(state))) {
                return true;
            }
            TileEntity tile = this.world.func_175625_s(pos);
            return tile != null && this.masterState == state;
        }

        @Override
        protected boolean isValidBlock(BlockPos pos) {
            return !this.isValidPath(pos);
        }

        @Override
        protected boolean onValidFound(BlockPos pos) {
            if (this.lastUsedDirection != null) {
                switch (this.lastUsedDirection) {
                    case DOWN: {
                        this.underBlocks.add(pos);
                        break;
                    }
                    case UP: {
                        this.aboveBlocks.add(pos);
                        break;
                    }
                    default: {
                        this.sideBlocks.add(pos);
                    }
                }
            }
            return true;
        }

        public List<BlockPos> getAboveBlocks() {
            return this.aboveBlocks;
        }

        public List<BlockPos> getSideBlocks() {
            return this.sideBlocks;
        }

        public List<BlockPos> getUnderBlocks() {
            return this.underBlocks;
        }

        public List<BlockPos> getActiveVents() {
            ArrayList<BlockPos> activeVents = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getUnderBlocks()) {
                if (ForgeWorld.SmokeContainers.isChimney(this.getWorld(), pos)) {
                    pos = ForgeWorld.SmokeContainers.getBottommostChimney(this.getWorld(), pos).func_177977_b();
                }
                if (!ForgeWorld.SmokeContainers.isActivePump(this.getWorld(), pos)) continue;
                activeVents.addAll(ForgeWorld.SmokeContainers.getVentsAround(this.getWorld(), pos));
            }
            return activeVents;
        }

        public List<BlockPos> getTopChimneys() {
            ArrayList<BlockPos> chimneys = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getAboveBlocks()) {
                if (!ForgeWorld.SmokeContainers.isChimney(this.getWorld(), pos)) continue;
                chimneys.add(pos);
            }
            return chimneys;
        }

        public List<BlockPos> getSideChimneys() {
            ArrayList<BlockPos> chimneys = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getSideBlocks()) {
                if (!ForgeWorld.SmokeContainers.isChimney(this.getWorld(), pos)) continue;
                chimneys.add(pos);
            }
            return chimneys;
        }

        public List<BlockPos> getPassiveVents() {
            ArrayList<BlockPos> passiveVents = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getSideBlocks()) {
                if (!ForgeWorld.SmokeContainers.isVent(this.getWorld(), pos)) continue;
                passiveVents.add(pos);
            }
            return passiveVents;
        }
    }

    public static abstract class BlockChain {
        private static List<EnumFacing> DIRECTIONS = Arrays.asList((Object[])EnumFacing.field_82609_l.clone());
        protected final World world;
        protected final BlockPos startPos;
        protected final List<BlockPos> blockChain;
        protected final List<BlockPos> foundBlocks;
        protected final int maxLength;
        protected boolean breakSearch = false;
        @Nullable
        protected EnumFacing lastUsedDirection = null;

        public BlockChain(World world, BlockPos startPos, int maxLength) {
            this.world = world;
            this.startPos = startPos;
            this.maxLength = maxLength;
            this.blockChain = new ArrayList<BlockPos>();
            this.foundBlocks = new ArrayList<BlockPos>();
        }

        public static BlockChain create(World world, BlockPos startPos, int maxLength, final BlockFunc validPath, final BlockFunc validBlock, final BlockFunc validFound) {
            BlockChain chain = new BlockChain(world, startPos, maxLength){

                @Override
                protected boolean onValidFound(BlockPos pos) {
                    return validFound.apply(this.world, pos);
                }

                @Override
                protected boolean isValidPath(BlockPos pos) {
                    return validPath.apply(this.world, pos);
                }

                @Override
                protected boolean isValidBlock(BlockPos pos) {
                    return validBlock.apply(this.world, pos);
                }
            };
            chain.build();
            return chain;
        }

        protected abstract boolean isValidPath(BlockPos var1);

        protected abstract boolean isValidBlock(BlockPos var1);

        protected abstract boolean onValidFound(BlockPos var1);

        public void build() {
            this.lastUsedDirection = null;
            this.breakSearch = false;
            this.blockChain.clear();
            this.foundBlocks.clear();
            this.search();
        }

        protected Collection<EnumFacing> getDirections() {
            return DIRECTIONS;
        }

        public BlockPos getStartPos() {
            return this.startPos;
        }

        public World getWorld() {
            return this.world;
        }

        public List<BlockPos> getChain() {
            return this.blockChain;
        }

        public List<BlockPos> getFound() {
            return this.foundBlocks;
        }

        public int length() {
            return this.blockChain.size();
        }

        protected void search() {
            ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
            stack.push(new StackEntry(this.startPos));
            while (!stack.isEmpty()) {
                if (this.length() >= this.maxLength) {
                    return;
                }
                StackEntry entry = (StackEntry)stack.peek();
                BlockPos pos = entry.getPos();
                if (!entry.isChecked()) {
                    if (!this.world.func_175667_e(pos)) {
                        stack.pop();
                        continue;
                    }
                    if (this.isValidBlock(pos) && !this.foundBlocks.contains(pos)) {
                        this.foundBlocks.add(pos);
                        boolean bl = this.breakSearch = !this.onValidFound(pos);
                    }
                    if (!this.isValidPath(pos) || this.blockChain.contains(pos)) {
                        stack.pop();
                        continue;
                    }
                    this.blockChain.add(pos);
                    entry.setChecked();
                }
                if (this.breakSearch) {
                    return;
                }
                EnumFacing direction = entry.getNextDirection().orElse(null);
                if (direction != null) {
                    stack.push(new StackEntry(pos.func_177972_a(direction)));
                    this.lastUsedDirection = direction;
                    continue;
                }
                stack.pop();
            }
        }

        protected class StackEntry {
            protected final BlockPos pos;
            protected Deque<EnumFacing> directions;
            protected boolean checked = false;

            public StackEntry(BlockPos pos) {
                this.pos = pos;
            }

            public BlockPos getPos() {
                return this.pos;
            }

            public Optional<EnumFacing> getNextDirection() {
                if (this.directions == null) {
                    this.directions = new ArrayDeque<EnumFacing>(BlockChain.this.getDirections());
                }
                if (this.directions.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(this.directions.pop());
            }

            public boolean isChecked() {
                return this.checked;
            }

            public void setChecked() {
                this.checked = true;
            }
        }

        @FunctionalInterface
        public static interface BlockFunc {
            public boolean apply(World var1, BlockPos var2);
        }
    }
}

