/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public enum Biomes implements IForgeEnum
{
    PLAINS(1),
    DESERT(2),
    EXTREME_HILLS(3),
    FOREST(4),
    TAIGA(5),
    SWAMPLAND(6),
    RIVER(7),
    HELL(8),
    THE_END(9),
    BEACHES(16),
    JUNGLE(21),
    SAVANNA(35),
    LOSTCITIES(111);

    public final int id;
    public static final String BIOMES_LIST_SYNTAX = "Biome is specified either by its numeric ID or by name (case-insensitive)\nEach ID must be on a separate line without any delimiters.\nIf the whitelist is set, the blacklist will be ignored.";

    private Biomes(int id) {
        this.id = id;
    }

    public static UnitConfig createConfigFor(ForgeMod mod, Biome biome) {
        String fileName = UnitId.from(biome.getRegistryName(), 0).toConfigName();
        int biomeId = Biome.func_185362_a((Biome)biome);
        UnitConfig config = new UnitConfig(Biomes.getConfigsBaseDir(mod), fileName);
        Biomes.readId(config, biomeId);
        ForgeConfig.readConfigEnabled(config, false);
        return config;
    }

    public static Path getConfigsBaseDir(ForgeMod mod) {
        return mod.getConfig().getConfigDir().resolve(Biomes.class.getSimpleName());
    }

    protected static int readId(ForgeConfig config, int defaultId) {
        int id = ForgeConfig.getInt(config, "Biome", "id", defaultId, IntBounds.INTEGER, "Biome identifier.");
        return id;
    }

    public static int getId(ForgeConfig config) {
        return Biomes.readId(config, Integer.MAX_VALUE);
    }

    public static boolean isConfigEnabled(ForgeConfig config) {
        return ForgeConfig.readConfigEnabled(config, false);
    }

    public static void logMissingId(ForgeMod mod, ForgeConfig config) {
        mod.getLogger().debug("Missing biome ID = {} in {}", (Object)Biomes.getId(config), (Object)config.getConfigFile());
    }

    public String func_176610_l() {
        return this.getLowerCase(this.name());
    }

    public static CommonCollect.BlackWhiteList<Biome> from(ForgeConfig config, String category, String comment) {
        category = IHaveConfig.expandClassCategory(Biomes.class, category);
        if (config != null) {
            config.setCategoryComment(category, comment + "\n" + BIOMES_LIST_SYNTAX);
        }
        List<Biome> black = Biomes.readFrom(config, category, "blackList", "");
        List<Biome> white = Biomes.readFrom(config, category, "whiteList", "");
        return new CommonCollect.BlackWhiteList<Biome>(black, white);
    }

    public static List<Biome> readFrom(ForgeConfig config, String category, String key, String comment) {
        if (config == null) {
            return Collections.emptyList();
        }
        String[] strArray = config.getStrArray(category, key, new String[0], comment);
        ArrayList<Biome> list = new ArrayList<Biome>();
        for (String str : strArray) {
            if ((str = str.trim()).isEmpty()) continue;
            try {
                int id = Integer.parseInt(str);
                Biome biome = Biome.func_185357_a((int)id);
                if (biome != null) {
                    list.add(biome);
                    continue;
                }
                ForgeMain.instance.getLogger().debug("No such biome with ID = " + id);
            }
            catch (Exception e) {
                ResourceLocation loc = new ResourceLocation(str);
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(loc);
                if (biome != null) {
                    list.add(biome);
                    continue;
                }
                ForgeMain.instance.getLogger().debug("No such biome with name " + CommonString.quoted(loc.toString()));
            }
        }
        return list;
    }
}

