/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.coremod.names;

import com.endertech.minecraft.forge.coremod.names.ClassName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class NotchMcp {
    static final Map<String, String> CLASSES = new HashMap<String, String>();
    protected static final Map<String, ClassContent> CLASS_CONTENT_MAP = new HashMap<String, ClassContent>();
    protected static final String SOURCE_FILE = "notch-mcp.srg";
    protected static final String CLASS_PREFIX = "CL:";
    protected static final String FIELD_PREFIX = "FD:";
    protected static final String METHOD_PREFIX = "MD:";

    @Nonnull
    public static ClassContent getContentOf(ClassName className) {
        return CLASS_CONTENT_MAP.getOrDefault(className.normal, ClassContent.EMPTY);
    }

    public static void clearLists() {
        CLASSES.clear();
    }

    static {
        try {
            InputStreamReader reader = new InputStreamReader(NotchMcp.class.getResourceAsStream(SOURCE_FILE));
            BufferedReader bf = new BufferedReader(reader);
            String line = null;
            while ((line = bf.readLine()) != null) {
                ClassContent content;
                String obfuscated;
                String className;
                String name;
                String[] splitted;
                String fullName;
                String[] parts = line.split(" ");
                if (line.startsWith(CLASS_PREFIX) && parts.length == 3) {
                    String name2 = parts[2];
                    CLASSES.put(name2, parts[1]);
                    CLASS_CONTENT_MAP.put(name2, new ClassContent());
                    continue;
                }
                if (line.startsWith(FIELD_PREFIX) && parts.length == 3) {
                    fullName = parts[2];
                    splitted = fullName.split("/");
                    name = splitted[splitted.length - 1];
                    className = fullName.substring(0, fullName.length() - name.length() - 1);
                    splitted = parts[1].split("/");
                    obfuscated = splitted[splitted.length - 1];
                    content = CLASS_CONTENT_MAP.get(className);
                    if (content == null) continue;
                    content.FIELDS.put(name, obfuscated);
                    continue;
                }
                if (!line.startsWith(METHOD_PREFIX) || parts.length != 5) continue;
                fullName = parts[3];
                splitted = fullName.split("/");
                name = splitted[splitted.length - 1];
                className = fullName.substring(0, fullName.length() - name.length() - 1);
                splitted = parts[1].split("/");
                obfuscated = splitted[splitted.length - 1];
                content = CLASS_CONTENT_MAP.get(className);
                if (content == null) continue;
                content.METHODS.put(name, obfuscated);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class ClassContent {
        static final ClassContent EMPTY = new ClassContent();
        final Map<String, String> FIELDS = new HashMap<String, String>();
        final Map<String, String> METHODS = new HashMap<String, String>();

        ClassContent() {
        }
    }
}

