/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.materials.ForgeMaterial;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ForgeRail
extends BlockRailBase
implements IForgeUnit {
    public static final PropertyBool POWERED = BlockRailPowered.field_176569_M;
    private final ForgeMaterial material;
    private final ForgeMod mod;
    private final ForgeConfig config;
    private final UnitEnabled unitEnabled;
    private final UnitId id;
    private final float maxSpeed;
    private final int signalMaxDistance;
    private final int metaShift;
    private final UnitVariant defaultVariant;
    private Map<Object, UnitVariant> variants = new HashMap<Object, UnitVariant>();

    public ForgeRail(ForgeMod mod, UnitConfig config, ForgeMaterial material, BlockRailBase.EnumRailDirection direction, int metaShift) {
        super(true);
        this.material = material;
        this.mod = mod;
        this.id = this.createId(mod.getId(), material.getName());
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getUnitCategory(), true);
        this.maxSpeed = material.getStrength();
        this.signalMaxDistance = ForgeBounds.RAIL_SIGNAL_DISTANCE.getIntBounds().approxUp(this.getMaterial().getMagicability());
        this.metaShift = metaShift;
        this.defaultVariant = UnitVariant.from(this.id, IForgeUnit.Variants.NORMAL);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.func_176560_l(), (Comparable)direction).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName(this.getId().toResLoc());
        this.func_149711_c(0.7f);
        this.setHarvestLevel("pickaxe", ForgeMaterial.calculateHarvestLevel(material));
        this.func_149663_c(this.getId().getRegName());
        this.register();
    }

    public static Posture getPosture(BlockRailBase.EnumRailDirection direction) {
        switch (direction) {
            case NORTH_SOUTH: 
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                return Posture.LONGWISE;
            }
            case EAST_WEST: 
            case ASCENDING_EAST: 
            case ASCENDING_WEST: {
                return Posture.LATERAL;
            }
        }
        return Posture.CURVED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.func_176560_l(), POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.func_177016_a((int)((meta & 7) + this.metaShift))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l())).func_177015_a() - this.metaShift;
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, BlockPos pos) {
        return this.maxSpeed;
    }

    @Override
    public boolean isReadyToRegister() {
        return true;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }

    @Override
    public UnitId getId() {
        return this.id;
    }

    @Override
    public ForgeMod getMod() {
        return this.mod;
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    @Override
    public boolean isRegistered() {
        return ForgeBlock.isRegistered((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(ChatFormatting.YELLOW + "Max Speed: " + this.getMaxSpeed());
        tooltip.add(ChatFormatting.RED + "Signal Max Distance: " + this.getSignalMaxDistance());
        super.func_190948_a(stack, world, tooltip, advanced);
    }

    public ForgeMaterial getMaterial() {
        return this.material;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getSignalMaxDistance() {
        return this.signalMaxDistance;
    }

    protected static BlockPos nextPosition(BlockPos pos, BlockRailBase.EnumRailDirection direction, boolean forward) {
        switch (direction) {
            case NORTH_SOUTH: {
                return forward ? pos.func_177968_d() : pos.func_177978_c();
            }
            case EAST_WEST: {
                return forward ? pos.func_177974_f() : pos.func_177976_e();
            }
            case ASCENDING_EAST: {
                return forward ? pos.func_177974_f().func_177984_a() : pos.func_177976_e();
            }
            case ASCENDING_WEST: {
                return forward ? pos.func_177974_f() : pos.func_177976_e().func_177984_a();
            }
            case ASCENDING_NORTH: {
                return forward ? pos.func_177968_d() : pos.func_177978_c().func_177984_a();
            }
            case ASCENDING_SOUTH: {
                return forward ? pos.func_177968_d().func_177984_a() : pos.func_177978_c();
            }
            case NORTH_EAST: {
                return forward ? pos.func_177974_f() : pos.func_177978_c();
            }
            case NORTH_WEST: {
                return forward ? pos.func_177976_e() : pos.func_177978_c();
            }
            case SOUTH_EAST: {
                return forward ? pos.func_177974_f() : pos.func_177968_d();
            }
            case SOUTH_WEST: {
                return forward ? pos.func_177976_e() : pos.func_177968_d();
            }
        }
        return pos;
    }

    protected boolean findPowerSource(World world, BlockPos startPos, BlockPos lastPos, BlockPos curPos, int distance) {
        boolean found;
        block3: {
            if (distance > this.getSignalMaxDistance()) {
                return false;
            }
            if (world.func_175640_z(curPos)) {
                return true;
            }
            found = false;
            IBlockState state = world.func_180495_p(curPos);
            if (!ForgeRail.func_176563_d((IBlockState)state)) break block3;
            BlockRailBase.EnumRailDirection direction = ForgeRail.getDirection(state);
            for (BlockPos checkPos : this.getConnectedNeightbors(world, curPos, direction)) {
                if (!checkPos.equals((Object)startPos) && !checkPos.equals((Object)lastPos) && ForgeRail.isPowerConductiveRail(world, checkPos) && (found = this.findPowerSource(world, startPos, curPos, checkPos, distance + 1))) break;
            }
        }
        return found;
    }

    public static boolean isAscendingSide(BlockRailBase.EnumRailDirection direction, EnumFacing side) {
        switch (side) {
            case NORTH: {
                return direction == BlockRailBase.EnumRailDirection.ASCENDING_NORTH;
            }
            case EAST: {
                return direction == BlockRailBase.EnumRailDirection.ASCENDING_EAST;
            }
            case SOUTH: {
                return direction == BlockRailBase.EnumRailDirection.ASCENDING_SOUTH;
            }
            case WEST: {
                return direction == BlockRailBase.EnumRailDirection.ASCENDING_WEST;
            }
        }
        return false;
    }

    public static boolean isConnectableSide(BlockRailBase.EnumRailDirection direction, EnumFacing side) {
        switch (ForgeRail.getPosture(direction)) {
            case LONGWISE: {
                return side == EnumFacing.NORTH || side == EnumFacing.SOUTH;
            }
            case LATERAL: {
                return side == EnumFacing.WEST || side == EnumFacing.EAST;
            }
            case CURVED: {
                switch (direction) {
                    case NORTH_WEST: {
                        return side == EnumFacing.NORTH || side == EnumFacing.WEST;
                    }
                    case NORTH_EAST: {
                        return side == EnumFacing.NORTH || side == EnumFacing.EAST;
                    }
                    case SOUTH_EAST: {
                        return side == EnumFacing.SOUTH || side == EnumFacing.EAST;
                    }
                    case SOUTH_WEST: {
                        return side == EnumFacing.SOUTH || side == EnumFacing.WEST;
                    }
                }
            }
        }
        return false;
    }

    protected static BlockRailBase.EnumRailDirection getDirection(IBlockState state) {
        BlockRailBase block = (BlockRailBase)state.func_177230_c();
        return (BlockRailBase.EnumRailDirection)state.func_177229_b(block.func_176560_l());
    }

    public static boolean isPoweredRail(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return ForgeRail.isPoweredRail(state);
    }

    public static boolean isPoweredRail(IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof ForgeRail) {
            return (Boolean)state.func_177229_b((IProperty)POWERED);
        }
        if (block instanceof BlockRailPowered) {
            return (Boolean)state.func_177229_b((IProperty)BlockRailPowered.field_176569_M);
        }
        if (block instanceof BlockRailDetector) {
            return (Boolean)state.func_177229_b((IProperty)BlockRailDetector.field_176574_M);
        }
        return false;
    }

    public static boolean isPowerConductiveRail(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof ForgeRail || block instanceof BlockRailPowered || block instanceof BlockRailDetector;
    }

    protected boolean isRailWithConnectableSide(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        return ForgeRail.func_176563_d((IBlockState)state) && ForgeRail.isConnectableSide(ForgeRail.getDirection(state), side);
    }

    @Deprecated
    protected int countConnectionsFor(World world, BlockPos pos, BlockRailBase.EnumRailDirection direction) {
        int connections = 0;
        for (EnumFacing side : EnumFacing.field_176754_o) {
            if (!ForgeRail.isConnectableSide(direction, side)) continue;
            BlockPos checkPos = pos.func_177972_a(side);
            if (ForgeRail.isAscendingSide(direction, side)) {
                checkPos = checkPos.func_177984_a();
            }
            if (!this.isRailWithConnectableSide(world, checkPos, side.func_176734_d())) continue;
            ++connections;
        }
        return connections;
    }

    protected IBlockState func_176564_a(World world, BlockPos pos, IBlockState state, boolean initialPlacement) {
        if (this.isClientSide(world)) {
            return state;
        }
        BlockRailBase.EnumRailDirection bestDirection = ForgeRail.getDirection(state);
        Posture bestPosture = ForgeRail.getPosture(bestDirection);
        int maxFoundConnections = this.getConnectedNeightbors(world, pos, bestDirection).size();
        for (BlockRailBase.EnumRailDirection direction : this.func_176560_l().func_177700_c()) {
            int connections = this.getConnectedNeightbors(world, pos, direction).size();
            if (connections < maxFoundConnections || direction.func_177018_c() && !this.hasGroundSupport(world, pos, direction) || connections == maxFoundConnections && (bestPosture == Posture.CURVED || ForgeRail.getPosture(direction) != bestPosture)) continue;
            maxFoundConnections = connections;
            bestDirection = direction;
        }
        IBlockState newState = state.func_177226_a(this.func_176560_l(), (Comparable)bestDirection);
        if (!state.equals(newState) && world.func_175656_a(pos, newState)) {
            return newState;
        }
        return state;
    }

    protected static List<BlockPos> getSupportPoints(BlockPos pos, BlockRailBase.EnumRailDirection direction) {
        ArrayList<BlockPos> points = new ArrayList<BlockPos>(2);
        points.add(pos.func_177977_b());
        switch (direction) {
            case ASCENDING_EAST: {
                points.add(pos.func_177974_f());
                break;
            }
            case ASCENDING_NORTH: {
                points.add(pos.func_177978_c());
                break;
            }
            case ASCENDING_SOUTH: {
                points.add(pos.func_177968_d());
                break;
            }
            case ASCENDING_WEST: {
                points.add(pos.func_177976_e());
                break;
            }
        }
        return points;
    }

    protected boolean hasGroundSupport(World world, BlockPos pos, BlockRailBase.EnumRailDirection direction) {
        boolean hasSupport = false;
        for (BlockPos checkPos : ForgeRail.getSupportPoints(pos, direction)) {
            IBlockState state = world.func_180495_p(checkPos);
            if (state.isSideSolid((IBlockAccess)world, checkPos, EnumFacing.UP)) {
                hasSupport = true;
                continue;
            }
            return false;
        }
        return hasSupport;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (this.isServerSide(world)) {
            state.func_189546_a(world, pos, (Block)this, pos);
            state = world.func_180495_p(pos);
            BlockRailBase.EnumRailDirection direction = ForgeRail.getDirection(state);
            for (BlockPos checkPos : this.getPossibleNeighbors(world, pos, direction)) {
                IBlockState checkState = world.func_180495_p(checkPos);
                if (!ForgeRail.func_176563_d((IBlockState)checkState)) continue;
                checkState.func_189546_a(world, checkPos, checkState.func_177230_c(), pos);
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }

    protected List<BlockPos> getPossibleNeighbors(World world, BlockPos pos, BlockRailBase.EnumRailDirection direction) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>(4);
        for (EnumFacing side : EnumFacing.field_176754_o) {
            if (!ForgeRail.isConnectableSide(direction, side)) continue;
            BlockPos offsetPos = pos.func_177972_a(side);
            if (ForgeRail.isAscendingSide(direction, side)) {
                neighbors.add(offsetPos.func_177984_a());
                continue;
            }
            neighbors.add(offsetPos);
            neighbors.add(offsetPos.func_177977_b());
        }
        return neighbors;
    }

    protected List<BlockPos> getConnectedNeightbors(World world, BlockPos pos, BlockRailBase.EnumRailDirection direction) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>(2);
        for (BlockPos checkPos : this.getPossibleNeighbors(world, pos, direction)) {
            BlockPos vec;
            EnumFacing checkSide;
            if (!this.isRailWithConnectableSide(world, checkPos, checkSide = EnumFacing.func_176737_a((float)(vec = checkPos.func_177973_b((Vec3i)pos)).func_177958_n(), (float)0.0f, (float)vec.func_177952_p()).func_176734_d())) continue;
            neighbors.add(checkPos);
        }
        return neighbors;
    }

    protected void func_189541_b(IBlockState state, World world, BlockPos pos, Block block) {
        state = this.func_176564_a(world, pos, state, false);
        boolean powered = this.findPowerSource(world, pos, pos, pos, 0);
        if (powered != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)));
            world.func_175685_c(pos.func_177977_b(), (Block)this, false);
            if (ForgeRail.getDirection(state).func_177018_c()) {
                world.func_175685_c(pos.func_177984_a(), (Block)this, false);
            }
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        BlockRailBase.EnumRailDirection direction = (BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l());
        switch (rotation) {
            case CLOCKWISE_180: {
                switch (direction) {
                    case ASCENDING_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                }
                return state;
            }
            case COUNTERCLOCKWISE_90: {
                switch (direction) {
                    case NORTH_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (direction) {
                    case NORTH_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                }
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        BlockRailBase.EnumRailDirection direction = (BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l());
        block0 : switch (mirror) {
            case LEFT_RIGHT: {
                switch (direction) {
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                }
                return state;
            }
            case FRONT_BACK: {
                switch (direction) {
                    case ASCENDING_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
            }
        }
        return state;
    }

    @Override
    public Map<Object, UnitVariant> getUnitVariants() {
        return this.variants;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        EnumFacing placerFacing = placer.func_174811_aO();
        Rotation rotation = Rotation.NONE;
        switch (placerFacing) {
            case EAST: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case SOUTH: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case WEST: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
        }
        state = this.func_185499_a(state, rotation);
        return state;
    }

    @Override
    public <E extends Enum<E>> void setUnitVariants(Class<E> clazz) {
        this.variants = this.createUnitVariants(clazz);
    }

    @Override
    public UnitVariant getDefaultVariant() {
        return this.defaultVariant;
    }

    public static enum Posture {
        LONGWISE,
        LATERAL,
        CURVED;

    }
}

