/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import xreliquary.Reliquary;
import xreliquary.handler.CommonEventHandler;
import xreliquary.handler.HandlerPriority;
import xreliquary.handler.IPlayerDeathHandler;
import xreliquary.handler.IPlayerHurtHandler;
import xreliquary.init.ModItems;
import xreliquary.items.ItemAngelicFeather;
import xreliquary.reference.Settings;
import xreliquary.util.EntityHelper;
import xreliquary.util.InventoryHelper;

public class ItemPhoenixDown
extends ItemAngelicFeather {
    public ItemPhoenixDown() {
        super("phoenix_down");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(EntityPlayer player, LivingAttackEvent event) {
                return event.getSource() == DamageSource.field_76379_h && player.func_110143_aJ() > (float)Math.round(event.getAmount()) && player.func_71024_bL().func_75116_a() > 0 && InventoryHelper.playerHasItem(player, ModItems.phoenixDown);
            }

            @Override
            public boolean apply(EntityPlayer player, LivingAttackEvent event) {
                float hungerDamage = event.getAmount() * ((float)Settings.Items.PhoenixDown.hungerCostPercent / 100.0f);
                player.func_71020_j(hungerDamage);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
        CommonEventHandler.registerPlayerDeathHandler(new IPlayerDeathHandler(){

            @Override
            public boolean canApply(EntityPlayer player, LivingDeathEvent event) {
                return InventoryHelper.playerHasItem(player, ModItems.phoenixDown);
            }

            @Override
            public boolean apply(EntityPlayer player, LivingDeathEvent event) {
                ItemPhoenixDown.revertPhoenixDownToAngelicFeather(player);
                float amountHealed = player.func_110138_aP() * (float)Settings.Items.PhoenixDown.healPercentageOfMaxLife / 100.0f;
                player.func_70606_j(amountHealed);
                if (Settings.Items.PhoenixDown.removeNegativeStatus) {
                    EntityHelper.removeNegativeStatusEffects((EntityLivingBase)player);
                }
                if (event.getSource() == DamageSource.field_76371_c && Settings.Items.PhoenixDown.giveTemporaryFireResistanceIfFireDamageKilledYou) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 200, 0));
                }
                if (event.getSource() == DamageSource.field_76369_e && Settings.Items.PhoenixDown.giveTemporaryWaterBreathingIfDrowningKilledYou) {
                    player.func_70050_g(10);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 200, 0));
                }
                if (Settings.Items.PhoenixDown.giveTemporaryDamageResistance) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 1));
                }
                if (Settings.Items.PhoenixDown.giveTemporaryRegeneration) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 1));
                }
                ItemPhoenixDown.spawnPhoenixResurrectionParticles(player);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.LOW;
            }
        });
    }

    private static void revertPhoenixDownToAngelicFeather(EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b() || ((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_77973_b() != ModItems.phoenixDown) continue;
            player.field_71071_by.field_70462_a.set(slot, (Object)new ItemStack((Item)ModItems.angelicFeather));
            return;
        }
    }

    private static void spawnPhoenixResurrectionParticles(EntityPlayer player) {
        for (int particles = 0; particles <= 400; ++particles) {
            player.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70170_p.field_73012_v.nextGaussian() * 8.0, player.field_70170_p.field_73012_v.nextGaussian() * 8.0, player.field_70170_p.field_73012_v.nextGaussian() * 8.0, new int[0]);
        }
    }
}

