/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import xreliquary.client.gui.components.Box;
import xreliquary.client.gui.components.Component;
import xreliquary.client.gui.components.ItemStackPane;
import xreliquary.client.gui.components.TextPane;
import xreliquary.client.gui.hud.ChargePane;
import xreliquary.client.gui.hud.ChargeableItemInfoPane;
import xreliquary.client.gui.hud.CharmPane;
import xreliquary.client.gui.hud.DynamicChargePane;
import xreliquary.client.gui.hud.HUDPosition;
import xreliquary.client.gui.hud.HUDRenderrer;
import xreliquary.client.gui.hud.HandgunPane;
import xreliquary.client.gui.hud.HeroMedallionPane;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.items.ItemVoidTear;
import xreliquary.reference.Colors;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

@Mod.EventBusSubscriber(modid="xreliquary", value={Side.CLIENT})
public class ClientEventHandler {
    private static final List<Tuple<Component, HUDPosition>> hudComponents = Lists.newArrayList();

    @SubscribeEvent
    public static void onRenderLiving(RenderLivingEvent.Pre event) {
        if (event.getEntity() instanceof EntityPlayer) {
            boolean handgunInMain;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            boolean handgunInOff = player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == ModItems.handgun;
            boolean bl = handgunInMain = player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ModItems.handgun;
            if (handgunInOff || handgunInMain) {
                ModelBiped model = (ModelBiped)event.getRenderer().func_177087_b();
                if (ClientEventHandler.isHandgunActive(player, handgunInMain, handgunInOff)) {
                    EnumHand hand = ClientEventHandler.getActiveHandgunHand(player, handgunInMain, handgunInOff);
                    EnumHandSide primaryHand = player.func_184591_cq();
                    if ((hand == EnumHand.MAIN_HAND && primaryHand == EnumHandSide.RIGHT || hand == EnumHand.OFF_HAND && primaryHand == EnumHandSide.LEFT) && model.field_187076_m != ModelBiped.ArmPose.BOW_AND_ARROW) {
                        model.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
                    } else if ((hand == EnumHand.OFF_HAND && primaryHand == EnumHandSide.RIGHT || hand == EnumHand.MAIN_HAND && primaryHand == EnumHandSide.LEFT) && model.field_187075_l != ModelBiped.ArmPose.BOW_AND_ARROW) {
                        model.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                } else {
                    if (model.field_187076_m == ModelBiped.ArmPose.BOW_AND_ARROW) {
                        model.field_187076_m = ModelBiped.ArmPose.ITEM;
                    }
                    if (model.field_187075_l == ModelBiped.ArmPose.BOW_AND_ARROW) {
                        model.field_187075_l = ModelBiped.ArmPose.ITEM;
                    }
                }
            }
        }
    }

    private static EnumHand getActiveHandgunHand(EntityPlayer player, boolean handgunInMain, boolean handgunInOff) {
        boolean offValid;
        if (handgunInMain != handgunInOff) {
            return handgunInMain ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        }
        boolean mainValid = ClientEventHandler.isValidTimeFrame(player.field_70170_p, player.func_184614_ca());
        if (mainValid != (offValid = ClientEventHandler.isValidTimeFrame(player.field_70170_p, player.func_184592_cb()))) {
            return mainValid ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        }
        return ModItems.handgun.getCooldown(player.func_184614_ca()) < ModItems.handgun.getCooldown(player.func_184592_cb()) ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    private static boolean isHandgunActive(EntityPlayer player, boolean handgunInMain, boolean handgunInOff) {
        return handgunInMain && ClientEventHandler.isValidTimeFrame(player.field_70170_p, player.func_184614_ca()) || handgunInOff && ClientEventHandler.isValidTimeFrame(player.field_70170_p, player.func_184592_cb());
    }

    private static boolean isValidTimeFrame(World world, ItemStack handgun) {
        long cooldownTime = ModItems.handgun.getCooldown(handgun) + 5L;
        return cooldownTime - world.func_82737_E() <= (long)ModItems.handgun.func_77626_a(handgun) && cooldownTime >= world.func_82737_E();
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G) {
            return;
        }
        if (hudComponents.isEmpty()) {
            ClientEventHandler.initHUDComponents();
        }
        ClientEventHandler.renderHUDComponents();
    }

    @SubscribeEvent
    public static void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        hudComponents.clear();
    }

    private static void renderHUDComponents() {
        for (Tuple<Component, HUDPosition> component : hudComponents) {
            HUDRenderrer.render((Component)component.func_76341_a(), (HUDPosition)((Object)component.func_76340_b()));
        }
    }

    private static void initHUDComponents() {
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.alkahestryTome, Settings.HudPositions.alkahestryTome, new ItemStack(Items.field_151137_ax), is -> NBTHelper.getInteger("charge", is)), (Object)Settings.HudPositions.alkahestryTome));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.destructionCatalyst, Settings.HudPositions.destructionCatalyst, new ItemStack(Items.field_151016_H), is -> NBTHelper.getInteger("gunpowder", is)), (Object)Settings.HudPositions.destructionCatalyst));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.midasTouchstone, Settings.HudPositions.midasTouchstone, new ItemStack(Items.field_151114_aO), is -> NBTHelper.getInteger("glowstone", is)), (Object)Settings.HudPositions.midasTouchstone));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane(ModItems.infernalChalice, Settings.HudPositions.infernalChalice, new ItemStack(Items.field_151129_at), is -> NBTHelper.getInteger("fluidStacks", is) / 1000, Colors.get("CC3024")), (Object)Settings.HudPositions.infernalChalice));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.iceMagusRod, Settings.HudPositions.iceMagusRod, new ItemStack(Items.field_151126_ay), is -> NBTHelper.getInteger("snowballs", is)), (Object)Settings.HudPositions.iceMagusRod));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.glacialStaff, Settings.HudPositions.glacialStaff, new ItemStack(Items.field_151126_ay), is -> NBTHelper.getInteger("snowballs", is)), (Object)Settings.HudPositions.glacialStaff));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.enderStaff, Settings.HudPositions.enderStaff, is -> ModItems.enderStaff.getMode((ItemStack)is), (Map<String, Component>)ImmutableMap.of((Object)"cast", (Object)new ChargePane(ModItems.enderStaff, new ItemStack(Items.field_151079_bi), is -> ModItems.enderStaff.getPearlCount((ItemStack)is, true)), (Object)"node_warp", (Object)new ChargePane(ModItems.enderStaff, new ItemStack((Block)ModBlocks.wraithNode), is -> ModItems.enderStaff.getPearlCount((ItemStack)is, true)), (Object)"long_cast", (Object)new ChargePane(ModItems.enderStaff, new ItemStack(Items.field_151061_bv), is -> ModItems.enderStaff.getPearlCount((ItemStack)is, true)))), (Object)Settings.HudPositions.enderStaff));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.pyromancerStaff, Settings.HudPositions.pyromancerStaff, is -> ModItems.pyromancerStaff.getMode((ItemStack)is), (Map<String, Component>)ImmutableMap.of((Object)"blaze", (Object)new ChargePane(ModItems.pyromancerStaff, new ItemStack(Items.field_151065_br), is -> ModItems.pyromancerStaff.getInternalStorageItemCount((ItemStack)is, Items.field_151065_br)), (Object)"charge", (Object)new ChargePane(ModItems.pyromancerStaff, new ItemStack(Items.field_151059_bz), is -> ModItems.pyromancerStaff.getInternalStorageItemCount((ItemStack)is, Items.field_151059_bz)), (Object)"eruption", (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane("ERUPT"), new ChargePane(ModItems.pyromancerStaff, new ItemStack(Items.field_151065_br), is -> ModItems.pyromancerStaff.getInternalStorageItemCount((ItemStack)is, Items.field_151065_br))), (Object)"flint_and_steel", (Object)new ItemStackPane(Items.field_151033_d))), (Object)Settings.HudPositions.pyromancerStaff));
        ChargePane rendingGaleFeatherPane = new ChargePane(ModItems.rendingGale, new ItemStack(Items.field_151008_G), is -> ModItems.rendingGale.getFeatherCountClient((ItemStack)is, (EntityPlayer)Minecraft.func_71410_x().field_71439_g) / 100);
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.rendingGale, Settings.HudPositions.rendingGale, is -> ModItems.rendingGale.getMode((ItemStack)is), (Map<String, Component>)ImmutableMap.of((Object)"push", (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane("PUSH"), rendingGaleFeatherPane), (Object)"pull", (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane("PULL"), rendingGaleFeatherPane), (Object)"bolt", (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane("BOLT"), rendingGaleFeatherPane), (Object)"flight", (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane("FLIGHT"), rendingGaleFeatherPane))), (Object)Settings.HudPositions.rendingGale));
        DynamicChargePane contentsPane = new DynamicChargePane(ModItems.voidTear, is -> ModItems.voidTear.getContainerItem((ItemStack)is, true), is -> ModItems.voidTear.getContainerItem((ItemStack)is, true).func_190916_E());
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.voidTear, Settings.HudPositions.voidTear, is -> ModItems.voidTear.getMode((ItemStack)is).func_176610_l(), (Map)ImmutableMap.of((Object)ItemVoidTear.Mode.FULL_INVENTORY.func_176610_l(), (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane(LanguageHelper.getLocalization("item.void_tear.mode." + ItemVoidTear.Mode.FULL_INVENTORY.func_176610_l().toLowerCase(), new Object[0])), contentsPane), (Object)ItemVoidTear.Mode.NO_REFILL.func_176610_l(), (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane(LanguageHelper.getLocalization("item.void_tear.mode." + ItemVoidTear.Mode.NO_REFILL.func_176610_l().toLowerCase(), new Object[0])), contentsPane), (Object)ItemVoidTear.Mode.ONE_STACK.func_176610_l(), (Object)Box.createVertical(Box.Alignment.RIGHT, new TextPane(LanguageHelper.getLocalization("item.void_tear.mode." + ItemVoidTear.Mode.ONE_STACK.func_176610_l().toLowerCase(), new Object[0])), contentsPane))){

            @Override
            public boolean shouldRender() {
                return !ModItems.voidTear.isEmpty(InventoryHelper.getCorrectItemFromEitherHand((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ModItems.voidTear), true);
            }
        }, (Object)Settings.HudPositions.voidTear));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.harvestRod, Settings.HudPositions.harvestRod, is -> ModItems.harvestRod.getMode((ItemStack)is), (Map<String, Component>)ImmutableMap.of((Object)"bone_meal", (Object)new ChargePane(ModItems.harvestRod, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()), is -> ModItems.harvestRod.getBoneMealCount((ItemStack)is, true)), (Object)"hoe", (Object)new ItemStackPane(Items.field_151017_I), (Object)"dynamic", (Object)new DynamicChargePane(ModItems.harvestRod, is -> ModItems.harvestRod.getCurrentPlantable((ItemStack)is, true), is -> ModItems.harvestRod.getPlantableQuantity((ItemStack)is, ModItems.harvestRod.getCurrentPlantableSlot((ItemStack)is), true)))), (Object)Settings.HudPositions.harvestRod));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new ChargeableItemInfoPane((Item)ModItems.sojournerStaff, Settings.HudPositions.sojournerStaff, is -> "dynamic", (Map<String, Component>)ImmutableMap.of((Object)"dynamic", (Object)new DynamicChargePane(ModItems.sojournerStaff, is -> new ItemStack(RegistryHelper.getItemFromName(ModItems.sojournerStaff.getTorchPlacementMode((ItemStack)is))), is -> ModItems.sojournerStaff.getTorchCount((ItemStack)is)))), (Object)Settings.HudPositions.sojournerStaff));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new HeroMedallionPane(), (Object)Settings.HudPositions.heroMedallion));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)Box.createVertical(Box.Alignment.RIGHT, new HandgunPane(EnumHand.OFF_HAND), new HandgunPane(EnumHand.MAIN_HAND)), (Object)Settings.HudPositions.handgun));
        hudComponents.add((Tuple<Component, HUDPosition>)new Tuple((Object)new CharmPane(), (Object)Settings.HudPositions.mobCharm));
    }
}

