/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.autooredictconv.command.logic;

import com.mattdahepic.autooredictconv.convert.Conversions;
import com.mattdahepic.mdecore.command.AbstractCommand;
import com.mattdahepic.mdecore.command.ICommandLogic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;

public class RemoveLogic
implements ICommandLogic {
    public static RemoveLogic instance = new RemoveLogic();

    public String getCommandName() {
        return "remove";
    }

    public int getPermissionLevel() {
        return 2;
    }

    public String getCommandSyntax() {
        return "/odc remove <ore name>";
    }

    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        ItemStack item = ((EntityPlayer)sender).func_184586_b(EnumHand.MAIN_HAND);
        if (item != null) {
            ArrayList<String> oreDictNames = new ArrayList<String>();
            for (int id : OreDictionary.getOreIDs((ItemStack)item)) {
                oreDictNames.add(OreDictionary.getOreName((int)id));
            }
            Object object = oreDictNames.iterator();
            while (object.hasNext()) {
                String name = (String)object.next();
                if (Conversions.conversionMap.containsKey(name) && Conversions.Config.remove(name)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Successfully removed conversion for " + TextFormatting.AQUA + name + TextFormatting.GREEN + "!"));
                    continue;
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Did not remove conversion for " + TextFormatting.AQUA + name + TextFormatting.RED + "!"));
            }
        } else if (args.length == 2) {
            String name = args[1];
            if (Conversions.conversionMap.containsKey(name) && Conversions.Config.remove(name)) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Successfully removed conversion for " + TextFormatting.AQUA + name + TextFormatting.GREEN + "!"));
                return;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Did not remove conversion for " + TextFormatting.AQUA + name + TextFormatting.RED + "!"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You're not holding an item and didn't specify a name to remove!"));
        }
    }

    public List<String> getTabCompletionList(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 2 ? AbstractCommand.func_175762_a((String[])args, Conversions.conversionMap.keySet()) : null;
    }
}

