/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.lib.inventory.ItemTransactorHelper;
import buildcraft.lib.misc.EntityUtil;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PipeBehaviorPriorityInsertion
extends APPipe {
    public byte[] sidePriorities = new byte[]{1, 1, 1, 1, 1, 1};

    public PipeBehaviorPriorityInsertion(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.sidePriorities = nbt.func_74770_j("prioritiesArray");
    }

    public PipeBehaviorPriorityInsertion(IPipe pipe) {
        super(pipe);
    }

    public int getTextureIndex(EnumFacing connection) {
        if (connection == null) {
            return 0;
        }
        return connection.ordinal();
    }

    @PipeEventHandler
    public void splitStacks(PipeEventItem.Split splitEvent) {
        ArrayList<PipeEventItem.ItemEntry> newDistribution = new ArrayList<PipeEventItem.ItemEntry>();
        for (PipeEventItem.ItemEntry entry : splitEvent.items) {
            if (entry.to == null) {
                entry.to = new ArrayList();
            }
            ItemStack itemsRemaining = entry.stack.func_77946_l();
            for (byte checkingPriority = 6; checkingPriority >= 1 && itemsRemaining.func_190916_E() > 0; --checkingPriority) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    if (this.sidePriorities[side.ordinal()] != checkingPriority || !this.pipe.isConnected(side) || this.pipe.getConnectedType(side) != IPipe.ConnectedType.TILE) continue;
                    IItemTransactor transactor = ItemTransactorHelper.getTransactor((ICapabilityProvider)this.pipe.getConnectedTile(side), (EnumFacing)side.func_176734_d());
                    ItemStack overflow = transactor.insert(itemsRemaining, false, true);
                    if (overflow == ItemStack.field_190927_a) {
                        itemsRemaining.func_190920_e(0);
                        entry.to.add(side);
                        newDistribution.add(entry);
                        continue;
                    }
                    if (overflow.func_190916_E() >= itemsRemaining.func_190916_E()) continue;
                    ItemStack partialStack = itemsRemaining.func_77946_l();
                    partialStack.func_190920_e(itemsRemaining.func_190916_E() - overflow.func_190916_E());
                    itemsRemaining.func_190920_e(overflow.func_190916_E());
                    PipeEventItem.ItemEntry newEntry = new PipeEventItem.ItemEntry(null, partialStack, entry.from);
                    newEntry.to = new ArrayList();
                    newEntry.to.add(side);
                    newDistribution.add(newEntry);
                }
            }
            if (itemsRemaining.func_190916_E() <= 0) continue;
            entry.stack.func_190920_e(itemsRemaining.func_190916_E());
            newDistribution.add(entry);
        }
        splitEvent.items.clear();
        splitEvent.items.addAll(newDistribution);
    }

    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (EntityUtil.getWrenchHand((EntityLivingBase)player) != null) {
            return super.onPipeActivate(player, trace, hitX, hitY, hitZ, part);
        }
        if (!player.field_70170_p.field_72995_K) {
            BlockPos pipePos = this.pipe.getHolder().getPipePos();
            player.openGui((Object)AdditionalPipes.instance, 5, this.pipe.getHolder().getPipeWorld(), pipePos.func_177958_n(), pipePos.func_177956_o(), pipePos.func_177952_p());
        }
        return true;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74773_a("prioritiesArray", this.sidePriorities);
        return nbt;
    }
}

