/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.utils.InventoryUtils;
import buildcraft.additionalpipes.utils.ItemHandlerPresenceFilter;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IStackFilter;
import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.lib.misc.EntityUtil;
import buildcraft.transport.pipe.behaviour.PipeBehaviourWood;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class PipeBehaviorAdvWood
extends PipeBehaviourWood
implements ICapabilityProvider {
    public static final int INVENTORY_SIZE = 9;
    public ItemStackHandler items = new ItemStackHandler(9);
    private IStackFilter filter;
    private boolean exclude = false;

    public PipeBehaviorAdvWood(IPipe pipe) {
        super(pipe);
        this.initFilter();
    }

    public PipeBehaviorAdvWood(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.setExclude(nbt.func_74767_n("exclude"));
        this.items.deserializeNBT(nbt.func_74775_l("filterItems"));
    }

    private void initFilter() {
        this.filter = new ItemHandlerPresenceFilter((IItemHandler)this.items, this.exclude);
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
        this.initFilter();
    }

    public boolean getExclude() {
        return this.exclude;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbttagcompound = super.writeToNbt();
        nbttagcompound.func_74757_a("exclude", this.exclude);
        nbttagcompound.func_74782_a("filterItems", (NBTBase)this.items.serializeNBT());
        return nbttagcompound;
    }

    protected int extractItems(IFlowItems flow, EnumFacing dir, int count, boolean simulate) {
        int extracted = flow.tryExtractItems(count, dir, null, this.filter, simulate);
        if (extracted > 0 && !simulate) {
            this.pipe.getHolder().scheduleNetworkUpdate(new IPipeHolder.PipeMessageReceiver[]{IPipeHolder.PipeMessageReceiver.BEHAVIOUR});
        }
        return extracted;
    }

    public void addDrops(NonNullList<ItemStack> toDrop, int fortune) {
        super.addDrops(toDrop, fortune);
        toDrop.addAll(InventoryUtils.getItems((IItemHandler)this.items));
    }

    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (EntityUtil.getWrenchHand((EntityLivingBase)player) != null) {
            return super.onPipeActivate(player, trace, hitX, hitY, hitZ, part);
        }
        if (player.func_70613_aW()) {
            BlockPos pipePos = this.pipe.getHolder().getPipePos();
            player.openGui((Object)AdditionalPipes.instance, 3, this.pipe.getHolder().getPipeWorld(), pipePos.func_177958_n(), pipePos.func_177956_o(), pipePos.func_177952_p());
        }
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.items;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

