/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.IBox;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.containers.IFillerStatementContainer;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.tiles.TilesAPI;
import buildcraft.builders.addon.AddonFillerPlanner;
import buildcraft.builders.filler.FillerType;
import buildcraft.builders.filler.FillerUtil;
import buildcraft.builders.snapshot.ITileForTemplateBuilder;
import buildcraft.builders.snapshot.ItemBlocks;
import buildcraft.builders.snapshot.SnapshotBuilder;
import buildcraft.builders.snapshot.Template;
import buildcraft.builders.snapshot.TemplateBuilder;
import buildcraft.core.marker.volume.ClientVolumeBoxes;
import buildcraft.core.marker.volume.EnumAddonSlot;
import buildcraft.core.marker.volume.Lock;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.core.marker.volume.WorldSavedDataVolumeBoxes;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.misc.BoundingBoxUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.data.Box;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.statement.FullStatement;
import buildcraft.lib.statement.StatementType;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileFiller
extends TileBC_Neptune
implements ITickable,
IDebuggable,
ITileForTemplateBuilder,
IFillerStatementContainer,
IControllable {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("filler");
    public static final int NET_CAN_EXCAVATE = IDS.allocId("CAN_EXCAVATE");
    public static final int NET_INVERT = IDS.allocId("INVERT");
    public static final int NET_PATTERN = IDS.allocId("PATTERN");
    public static final int NET_BOX = IDS.allocId("BOX");
    public final ItemHandlerSimple invResources;
    private final MjBattery battery;
    private boolean canExcavate;
    public boolean inverted;
    private boolean finished;
    private byte lockedTicks;
    private IControllable.Mode mode;
    public final Box box;
    public AddonFillerPlanner addon;
    public boolean markerBox;
    public final FullStatement<IFillerPattern> patternStatement;
    private Template.BuildingInfo buildingInfo;
    public TemplateBuilder builder;

    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public TileFiller() {
        this.invResources = this.itemManager.addInvHandler("resources", 27, (slot, stack) -> ItemBlocks.getList().contains(stack.func_77973_b()), ItemHandlerManager.EnumAccess.INSERT, EnumPipePart.VALUES);
        this.battery = new MjBattery(16000L * MjAPI.MJ);
        this.canExcavate = true;
        this.inverted = false;
        this.finished = false;
        this.lockedTicks = 0;
        this.mode = IControllable.Mode.ON;
        this.box = new Box();
        this.markerBox = true;
        this.patternStatement = new FullStatement((StatementType)FillerType.INSTANCE, 4, (statement, paramIndex) -> this.onStatementChange());
        this.builder = new TemplateBuilder(this);
        this.caps.addProvider((ICapabilityProvider)new MjCapabilityHelper((IMjConnector)new MjBatteryReceiver(this.battery)));
        this.caps.addCapabilityInstance(TilesAPI.CAP_CONTROLLABLE, (Object)this, EnumPipePart.VALUES);
    }

    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        super.onPlacedBy(placer, stack);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        WorldSavedDataVolumeBoxes volumeBoxes = WorldSavedDataVolumeBoxes.get((World)this.field_145850_b);
        BlockPos offsetPos = this.field_174879_c.func_177972_a(((EnumFacing)blockState.func_177229_b(BlockBCBase_Neptune.PROP_FACING)).func_176734_d());
        VolumeBox volumeBox = volumeBoxes.getVolumeBoxAt(offsetPos);
        TileEntity tile = this.field_145850_b.func_175625_s(offsetPos);
        if (volumeBox != null) {
            this.addon = volumeBox.addons.values().stream().filter(AddonFillerPlanner.class::isInstance).findFirst().orElse(null);
            if (this.addon != null) {
                volumeBox.locks.add(new Lock((Lock.Cause)new Lock.Cause.CauseBlock(this.field_174879_c, blockState.func_177230_c()), new Lock.Target[]{new Lock.Target.TargetAddon(this.addon.getSlot()), new Lock.Target.TargetRemove(), new Lock.Target.TargetResize(), new Lock.Target.TargetUsedByMachine(Lock.Target.TargetUsedByMachine.EnumType.STRIPES_WRITE)}));
                volumeBoxes.func_76185_a();
                this.addon.updateBuildingInfo();
                this.markerBox = false;
            } else {
                this.box.reset();
                this.box.setMin(volumeBox.box.min());
                this.box.setMax(volumeBox.box.max());
                volumeBox.locks.add(new Lock((Lock.Cause)new Lock.Cause.CauseBlock(this.field_174879_c, blockState.func_177230_c()), new Lock.Target[]{new Lock.Target.TargetRemove(), new Lock.Target.TargetResize(), new Lock.Target.TargetUsedByMachine(Lock.Target.TargetUsedByMachine.EnumType.STRIPES_WRITE)}));
                volumeBoxes.func_76185_a();
                this.markerBox = false;
            }
        } else if (tile instanceof IAreaProvider) {
            IAreaProvider provider = (IAreaProvider)tile;
            this.box.reset();
            this.box.setMin(provider.min());
            this.box.setMax(provider.max());
            provider.removeFromWorld();
        }
        this.updateBuildingInfo();
        this.sendNetworkUpdate(NET_RENDER_DATA);
    }

    protected void onSlotChange(IItemHandlerModifiable handler, int slot, @Nonnull ItemStack before, @Nonnull ItemStack after) {
        if (!this.field_145850_b.field_72995_K && handler == this.invResources) {
            Optional.ofNullable(this.getBuilder()).ifPresent(SnapshotBuilder::resourcesChanged);
        }
        super.onSlotChange(handler, slot, before, after);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.isValid()) {
                this.builder.tick();
            }
            this.patternStatement.canInteract = !this.isLocked();
            return;
        }
        this.sendNetworkUpdate(NET_RENDER_DATA);
        this.lockedTicks = (byte)(this.lockedTicks - 1);
        if (this.lockedTicks < 0) {
            this.lockedTicks = 0;
        }
        if (this.mode == IControllable.Mode.OFF) {
            return;
        }
        Optional.ofNullable(this.getBuilder()).ifPresent(SnapshotBuilder::tick);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.builder.validate();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.builder.invalidate();
    }

    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.builder.writeToByteBuf(buffer);
                this.writePayload(NET_BOX, buffer, side);
            } else if (id == NET_GUI_DATA || id == NET_GUI_TICK) {
                this.writePayload(NET_CAN_EXCAVATE, buffer, side);
                this.writePayload(NET_INVERT, buffer, side);
                this.writePayload(NET_PATTERN, buffer, side);
                this.builder.writeToByteBuf(buffer);
                buffer.writeBoolean(this.finished);
                buffer.writeBoolean(this.lockedTicks > 0);
                buffer.writeEnumValue((Enum)this.mode);
            } else if (id == NET_BOX) {
                this.box.writeData((PacketBuffer)buffer);
                buffer.writeBoolean(this.markerBox);
                buffer.writeBoolean(this.addon != null);
                if (this.addon != null) {
                    buffer.func_179252_a(this.addon.volumeBox.id);
                    buffer.writeEnumValue((Enum)this.addon.getSlot());
                }
            } else if (id == NET_CAN_EXCAVATE) {
                buffer.writeBoolean(this.canExcavate);
            } else if (id == NET_INVERT) {
                buffer.writeBoolean(this.inverted);
            } else if (id == NET_PATTERN) {
                this.patternStatement.writeToBuffer(buffer);
            }
        }
    }

    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.builder.readFromByteBuf(buffer);
                this.readPayload(NET_BOX, buffer, side, ctx);
            } else if (id == NET_GUI_DATA || id == NET_GUI_TICK) {
                this.readPayload(NET_CAN_EXCAVATE, buffer, side, ctx);
                this.readPayload(NET_INVERT, buffer, side, ctx);
                this.readPayload(NET_PATTERN, buffer, side, ctx);
                this.builder.readFromByteBuf(buffer);
                this.finished = buffer.readBoolean();
                this.lockedTicks = buffer.readBoolean() ? (byte)1 : 0;
                this.mode = (IControllable.Mode)buffer.func_179257_a(IControllable.Mode.class);
            } else if (id == NET_BOX) {
                this.box.readData((PacketBuffer)buffer);
                this.markerBox = buffer.readBoolean();
                if (buffer.readBoolean()) {
                    UUID volumeBoxId = buffer.func_179253_g();
                    VolumeBox volumeBox = this.field_145850_b.field_72995_K ? ClientVolumeBoxes.INSTANCE.volumeBoxes.stream().filter(localVolumeBox -> localVolumeBox.id.equals(volumeBoxId)).findFirst().orElseThrow(NullPointerException::new) : WorldSavedDataVolumeBoxes.get((World)this.field_145850_b).getVolumeBoxFromId(volumeBoxId);
                    this.addon = (AddonFillerPlanner)((Object)volumeBox.addons.get(buffer.func_179257_a(EnumAddonSlot.class)));
                }
            } else if (id == NET_CAN_EXCAVATE) {
                this.canExcavate = buffer.readBoolean();
            } else if (id == NET_INVERT) {
                this.inverted = buffer.readBoolean();
            } else if (id == NET_PATTERN) {
                this.patternStatement.readFromBuffer(buffer);
            }
        }
        if (side == Side.SERVER && id == NET_CAN_EXCAVATE) {
            this.canExcavate = buffer.readBoolean();
            this.sendNetworkGuiUpdate(NET_CAN_EXCAVATE);
        }
    }

    private void updateBuildingInfo() {
        Optional.ofNullable(this.getBuilder()).ifPresent(SnapshotBuilder::cancel);
        this.buildingInfo = this.hasBox() && this.addon == null ? FillerUtil.createBuildingInfo(this, this.patternStatement, (IStatementParameter[])IntStream.range(0, this.patternStatement.maxParams).mapToObj(arg_0 -> this.patternStatement.get(arg_0)).toArray(IStatementParameter[]::new), this.inverted) : null;
        Optional.ofNullable(this.getBuilder()).ifPresent(SnapshotBuilder::updateSnapshot);
    }

    public void sendCanExcavate(boolean newValue) {
        MessageManager.sendToServer((IMessage)this.createMessage(NET_CAN_EXCAVATE, buffer -> buffer.writeBoolean(newValue)));
    }

    public void onStatementChange() {
        if (!this.field_145850_b.field_72995_K) {
            this.createAndSendMessage(NET_PATTERN, arg_0 -> this.patternStatement.writeToBuffer(arg_0));
        }
        this.finished = false;
        this.updateBuildingInfo();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("battery", (NBTBase)this.battery.serializeNBT());
        nbt.func_74757_a("canExcavate", this.canExcavate);
        nbt.func_74757_a("inverted", this.inverted);
        nbt.func_74757_a("finished", this.finished);
        nbt.func_74774_a("lockedTicks", this.lockedTicks);
        nbt.func_74782_a("mode", NBTUtilBC.writeEnum((Enum)this.mode));
        nbt.func_74782_a("box", (NBTBase)this.box.writeToNBT());
        if (this.addon != null) {
            nbt.func_186854_a("addonVolumeBoxId", this.addon.volumeBox.id);
            nbt.func_74782_a("addonSlot", NBTUtilBC.writeEnum((Enum)this.addon.getSlot()));
        }
        nbt.func_74757_a("markerBox", this.markerBox);
        nbt.func_74782_a("patternStatement", (NBTBase)this.patternStatement.writeToNbt());
        Optional.ofNullable(this.getBuilder()).ifPresent(builder -> nbt.func_74782_a("builder", (NBTBase)builder.serializeNBT()));
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        this.canExcavate = nbt.func_74767_n("canExcavate");
        this.inverted = nbt.func_74767_n("inverted");
        this.finished = nbt.func_74767_n("finished");
        this.lockedTicks = nbt.func_74771_c("lockedTicks");
        this.mode = (IControllable.Mode)Optional.ofNullable(NBTUtilBC.readEnum((NBTBase)nbt.func_74781_a("mode"), IControllable.Mode.class)).orElse((Enum)IControllable.Mode.ON);
        this.box.initialize(nbt.func_74775_l("box"));
        if (nbt.func_74764_b("addonSlot")) {
            this.addon = (AddonFillerPlanner)((Object)WorldSavedDataVolumeBoxes.get((World)this.field_145850_b).getVolumeBoxFromId((UUID)nbt.func_186857_a((String)"addonVolumeBoxId")).addons.get(NBTUtilBC.readEnum((NBTBase)nbt.func_74781_a("addonSlot"), EnumAddonSlot.class)));
        }
        this.markerBox = nbt.func_74767_n("markerBox");
        this.patternStatement.readFromNbt(nbt.func_74775_l("patternStatement"));
        this.updateBuildingInfo();
        if (nbt.func_74764_b("builder")) {
            Optional.ofNullable(this.getBuilder()).ifPresent(builder -> builder.deserializeNBT(nbt.func_74775_l("builder")));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        return true;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return BoundingBoxUtil.makeFrom((BlockPos)this.field_174879_c, (IBox)(this.addon != null ? this.addon.volumeBox.box : this.box));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("battery = " + this.battery.getDebugString());
        left.add("box = " + this.box);
        left.add("pattern = " + this.patternStatement.get());
        left.add("mode = " + this.mode);
        left.add("is_finished = " + this.finished);
        left.add("lockedTicks = " + this.lockedTicks);
        left.add("addon = " + (Object)((Object)this.addon));
        left.add("markerBox = " + this.markerBox);
    }

    @Override
    public World getWorldBC() {
        return this.field_145850_b;
    }

    public int getCountToPlace() {
        return this.builder == null ? 0 : this.builder.leftToPlace;
    }

    public int getCountToBreak() {
        return this.builder == null ? 0 : this.builder.leftToBreak;
    }

    @Override
    public MjBattery getBattery() {
        return this.battery;
    }

    @Override
    public BlockPos getBuilderPos() {
        return this.field_174879_c;
    }

    @Override
    public boolean canExcavate() {
        return this.canExcavate;
    }

    public boolean isFinished() {
        return this.mode != IControllable.Mode.LOOP && this.finished;
    }

    public boolean isLocked() {
        return this.lockedTicks > 0;
    }

    public TemplateBuilder getBuilder() {
        return this.isValid() ? this.builder : null;
    }

    @Override
    public Template.BuildingInfo getTemplateBuildingInfo() {
        return this.isValid() ? (this.addon != null ? this.addon.buildingInfo : this.buildingInfo) : null;
    }

    @Override
    public IItemTransactor getInvResources() {
        return this.invResources;
    }

    public TileEntity getTile() {
        return this;
    }

    public World getFillerWorld() {
        return this.field_145850_b;
    }

    public boolean hasBox() {
        return this.addon != null || this.box.isInitialized();
    }

    public boolean isValid() {
        return this.hasBox() && (this.field_145850_b.field_72995_K || (this.addon != null ? this.addon.buildingInfo : this.buildingInfo) != null);
    }

    public IBox getBox() {
        if (!this.hasBox()) {
            throw new IllegalStateException("Called getBox() when hasBox() returned false!");
        }
        return this.addon != null ? this.addon.volumeBox.box : this.box;
    }

    public void setPattern(IFillerPattern pattern, IStatementParameter[] params) {
        this.patternStatement.set((IStatement)pattern, params);
        this.finished = false;
        this.lockedTicks = (byte)3;
    }

    public IControllable.Mode getControlMode() {
        return this.mode;
    }

    public void setControlMode(IControllable.Mode mode) {
        if (this.mode == IControllable.Mode.OFF && mode != IControllable.Mode.OFF) {
            this.finished = false;
        }
        this.mode = mode;
    }
}

