/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.enums.EnumSnapshotType;
import buildcraft.builders.snapshot.Blueprint;
import buildcraft.builders.snapshot.Template;
import buildcraft.lib.misc.HashUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.RotationUtil;
import buildcraft.lib.misc.StringUtilBC;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.Box;
import buildcraft.lib.net.PacketBufferBC;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class Snapshot {
    public Key key = new Key();
    public BlockPos size;
    public EnumFacing facing;
    public BlockPos offset;

    public static Snapshot create(EnumSnapshotType type) {
        switch (type) {
            case TEMPLATE: {
                return new Template();
            }
            case BLUEPRINT: {
                return new Blueprint();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static int posToIndex(int sizeX, int sizeY, int sizeZ, int x, int y, int z) {
        return (z * sizeY + y) * sizeX + x;
    }

    public static int posToIndex(BlockPos size, int x, int y, int z) {
        return Snapshot.posToIndex(size.func_177958_n(), size.func_177956_o(), size.func_177952_p(), x, y, z);
    }

    public static int posToIndex(int sizeX, int sizeY, int sizeZ, BlockPos pos) {
        return Snapshot.posToIndex(sizeX, sizeY, sizeZ, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static int posToIndex(BlockPos size, BlockPos pos) {
        return Snapshot.posToIndex(size.func_177958_n(), size.func_177956_o(), size.func_177952_p(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public int posToIndex(int x, int y, int z) {
        return Snapshot.posToIndex(this.size, x, y, z);
    }

    public int posToIndex(BlockPos pos) {
        return Snapshot.posToIndex(this.size, pos);
    }

    public static BlockPos indexToPos(int sizeX, int sizeY, int sizeZ, int i) {
        return new BlockPos(i % sizeX, i / sizeX % sizeY, i / (sizeY * sizeX));
    }

    public static BlockPos indexToPos(BlockPos size, int i) {
        return Snapshot.indexToPos(size.func_177958_n(), size.func_177956_o(), size.func_177952_p(), i);
    }

    public BlockPos indexToPos(int i) {
        return Snapshot.indexToPos(this.size, i);
    }

    public static int getDataSize(int x, int y, int z) {
        return x * y * z;
    }

    public static int getDataSize(BlockPos size) {
        return Snapshot.getDataSize(size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
    }

    public int getDataSize() {
        return Snapshot.getDataSize(this.size);
    }

    public static NBTTagCompound writeToNBT(Snapshot snapshot) {
        NBTTagCompound nbt = snapshot.serializeNBT();
        nbt.func_74782_a("type", NBTUtilBC.writeEnum((Enum)snapshot.getType()));
        return nbt;
    }

    public static Snapshot readFromNBT(NBTTagCompound nbt) throws InvalidInputDataException {
        NBTBase tag = nbt.func_74781_a("type");
        EnumSnapshotType type = (EnumSnapshotType)NBTUtilBC.readEnum((NBTBase)tag, EnumSnapshotType.class);
        if (type == null) {
            throw new InvalidInputDataException("Unknown snapshot type " + tag);
        }
        Snapshot snapshot = Snapshot.create(type);
        snapshot.deserializeNBT(nbt);
        return snapshot;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("key", (NBTBase)this.key.serializeNBT());
        nbt.func_74782_a("size", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.size));
        nbt.func_74782_a("facing", NBTUtilBC.writeEnum((Enum)this.facing));
        nbt.func_74782_a("offset", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.offset));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) throws InvalidInputDataException {
        this.key = new Key(nbt.func_74775_l("key"));
        this.size = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("size"));
        this.facing = (EnumFacing)NBTUtilBC.readEnum((NBTBase)nbt.func_74781_a("facing"), EnumFacing.class);
        this.offset = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("offset"));
    }

    public abstract Snapshot copy();

    public abstract EnumSnapshotType getType();

    public void computeKey() {
        NBTTagCompound nbt = Snapshot.writeToNBT(this);
        if (nbt.func_150297_b("key", 10)) {
            nbt.func_82580_o("key");
        }
        this.key = new Key(this.key, HashUtil.computeHash((NBTTagCompound)nbt));
    }

    public String toString() {
        return "Snapshot{key=" + this.key + ", size=" + StringUtilBC.blockPosAsSizeToString((BlockPos)this.size) + ", facing=" + this.facing + ", offset=" + this.offset + "}";
    }

    public abstract class BuildingInfo {
        public final BlockPos basePos;
        public final BlockPos offsetPos;
        public final Rotation rotation;
        public final Box box = new Box();

        protected BuildingInfo(BlockPos basePos, Rotation rotation) {
            this.basePos = basePos;
            this.offsetPos = basePos.func_177971_a((Vec3i)Snapshot.this.offset.func_190942_a(rotation));
            this.rotation = rotation;
            this.box.extendToEncompass(this.toWorld(BlockPos.field_177992_a));
            this.box.extendToEncompass(this.toWorld(Snapshot.this.size.func_177973_b((Vec3i)VecUtil.POS_ONE)));
        }

        public BlockPos toWorld(BlockPos blockPos) {
            return blockPos.func_190942_a(this.rotation).func_177971_a((Vec3i)this.offsetPos);
        }

        public BlockPos fromWorld(BlockPos blockPos) {
            return blockPos.func_177973_b((Vec3i)this.offsetPos).func_190942_a(RotationUtil.invert((Rotation)this.rotation));
        }

        public abstract Snapshot getSnapshot();
    }

    public static class Header {
        public final Key key;
        public final UUID owner;
        public final Date created;
        public final String name;

        public Header(Key key, UUID owner, Date created, String name) {
            this.key = key;
            this.owner = owner;
            this.created = created;
            this.name = name;
        }

        public Header(NBTTagCompound nbt) {
            this.key = new Key(nbt.func_74775_l("key"));
            this.owner = nbt.func_186857_a("owner");
            this.created = new Date(nbt.func_74763_f("created"));
            this.name = nbt.func_74779_i("name");
        }

        public Header(PacketBufferBC buffer) {
            this.key = new Key(buffer);
            this.owner = buffer.func_179253_g();
            this.created = new Date(buffer.readLong());
            this.name = buffer.readString();
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("key", (NBTBase)this.key.serializeNBT());
            nbt.func_186854_a("owner", this.owner);
            nbt.func_74772_a("created", this.created.getTime());
            nbt.func_74778_a("name", this.name);
            return nbt;
        }

        public void writeToByteBuf(PacketBufferBC buffer) {
            this.key.writeToByteBuf(buffer);
            buffer.func_179252_a(this.owner);
            buffer.writeLong(this.created.getTime());
            buffer.func_180714_a(this.name);
        }

        public EntityPlayer getOwnerPlayer(World world) {
            return world.func_152378_a(this.owner);
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.key.equals(((Header)o).key) && this.owner.equals(((Header)o).owner) && this.created.equals(((Header)o).created) && this.name.equals(((Header)o).name);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.owner.hashCode();
            result = 31 * result + this.created.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Key {
        public final byte[] hash;
        @Nullable
        public final Header header;

        public Key() {
            this.hash = new byte[0];
            this.header = null;
        }

        public Key(Key oldKey, byte[] hash) {
            this.hash = hash;
            this.header = oldKey.header;
        }

        public Key(Key oldKey, @Nullable Header header) {
            this.hash = oldKey.hash;
            this.header = header;
        }

        public Key(NBTTagCompound nbt) {
            this.hash = nbt.func_74770_j("hash");
            this.header = nbt.func_74764_b("header") ? new Header(nbt.func_74775_l("header")) : null;
        }

        public Key(PacketBufferBC buffer) {
            this.hash = buffer.func_179251_a();
            this.header = buffer.readBoolean() ? new Header(buffer) : null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74773_a("hash", this.hash);
            if (this.header != null) {
                nbt.func_74782_a("header", (NBTBase)this.header.serializeNBT());
            }
            return nbt;
        }

        public void writeToByteBuf(PacketBufferBC buffer) {
            buffer.func_179250_a(this.hash);
            buffer.writeBoolean(this.header != null);
            if (this.header != null) {
                this.header.writeToByteBuf(buffer);
            }
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Arrays.equals(this.hash, ((Key)o).hash) && (this.header != null ? this.header.equals(((Key)o).header) : ((Key)o).header == null);
        }

        public int hashCode() {
            return Arrays.hashCode(this.hash);
        }

        public String toString() {
            return HashUtil.convertHashToString((byte[])this.hash);
        }
    }
}

