/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.schematics.ISchematicEntity;
import buildcraft.api.schematics.SchematicEntityContext;
import buildcraft.builders.snapshot.JsonRule;
import buildcraft.builders.snapshot.RulesLoader;
import buildcraft.builders.snapshot.SchematicEntityManager;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.RotationUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class SchematicEntityDefault
implements ISchematicEntity {
    private NBTTagCompound entityNbt;
    private Vec3d pos;
    private BlockPos hangingPos;
    private EnumFacing hangingFacing;
    private Rotation entityRotation = Rotation.NONE;

    public static boolean predicate(SchematicEntityContext context) {
        ResourceLocation registryName = EntityList.func_191301_a((Entity)context.entity);
        return registryName != null && RulesLoader.READ_DOMAINS.contains(registryName.func_110624_b()) && RulesLoader.getRules(EntityList.func_191301_a((Entity)context.entity), context.entity.serializeNBT()).stream().anyMatch(rule -> rule.capture);
    }

    public void init(SchematicEntityContext context) {
        this.entityNbt = context.entity.serializeNBT();
        this.pos = context.entity.func_174791_d().func_178788_d(new Vec3d((Vec3i)context.basePos));
        if (context.entity instanceof EntityHanging) {
            EntityHanging entityHanging = (EntityHanging)context.entity;
            this.hangingPos = entityHanging.func_174857_n().func_177973_b((Vec3i)context.basePos);
            this.hangingFacing = entityHanging.func_174811_aO();
        } else {
            this.hangingPos = new BlockPos(this.pos);
            this.hangingFacing = EnumFacing.NORTH;
        }
    }

    public Vec3d getPos() {
        return this.pos;
    }

    @Nonnull
    public List<ItemStack> computeRequiredItems() {
        Set<JsonRule> rules = RulesLoader.getRules(new ResourceLocation(this.entityNbt.func_74779_i("id")), this.entityNbt);
        if (rules.isEmpty()) {
            throw new IllegalArgumentException("Rules are empty");
        }
        return rules.stream().map(rule -> rule.requiredExtractors).filter(Objects::nonNull).flatMap(Collection::stream).flatMap(requiredExtractor -> requiredExtractor.extractItemsFromEntity(this.entityNbt).stream()).filter(((Predicate<ItemStack>)ItemStack::func_190926_b).negate()).collect(Collectors.toList());
    }

    @Nonnull
    public List<FluidStack> computeRequiredFluids() {
        Set<JsonRule> rules = RulesLoader.getRules(new ResourceLocation(this.entityNbt.func_74779_i("id")), this.entityNbt);
        return rules.stream().map(rule -> rule.requiredExtractors).filter(Objects::nonNull).flatMap(Collection::stream).flatMap(requiredExtractor -> requiredExtractor.extractFluidsFromEntity(this.entityNbt).stream()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public SchematicEntityDefault getRotated(Rotation rotation) {
        SchematicEntityDefault schematicEntity = SchematicEntityManager.createCleanCopy(this);
        schematicEntity.entityNbt = this.entityNbt;
        schematicEntity.pos = RotationUtil.rotateVec3d((Vec3d)this.pos, (Rotation)rotation);
        schematicEntity.hangingPos = this.hangingPos.func_190942_a(rotation);
        schematicEntity.hangingFacing = rotation.func_185831_a(this.hangingFacing);
        schematicEntity.entityRotation = this.entityRotation.func_185830_a(rotation);
        return schematicEntity;
    }

    public Entity build(World world, BlockPos basePos) {
        Set<JsonRule> rules = RulesLoader.getRules(new ResourceLocation(this.entityNbt.func_74779_i("id")), this.entityNbt);
        NBTTagCompound replaceNbt = rules.stream().map(rule -> rule.replaceNbt).filter(Objects::nonNull).map(NBTBase.class::cast).reduce(NBTUtilBC::merge).map(NBTTagCompound.class::cast).orElse(null);
        Vec3d placePos = new Vec3d((Vec3i)basePos).func_178787_e(this.pos);
        BlockPos placeHangingPos = basePos.func_177971_a((Vec3i)this.hangingPos);
        NBTTagCompound newEntityNbt = new NBTTagCompound();
        this.entityNbt.func_150296_c().stream().map(key -> Pair.of((Object)key, (Object)this.entityNbt.func_74781_a(key))).forEach(kv -> newEntityNbt.func_74782_a((String)kv.getKey(), (NBTBase)kv.getValue()));
        newEntityNbt.func_74782_a("Pos", (NBTBase)NBTUtilBC.writeVec3d((Vec3d)placePos));
        newEntityNbt.func_186854_a("UUID", UUID.randomUUID());
        boolean rotate = false;
        if (Stream.of("TileX", "TileY", "TileZ", "Facing").allMatch(arg_0 -> ((NBTTagCompound)newEntityNbt).func_74764_b(arg_0))) {
            newEntityNbt.func_74768_a("TileX", placeHangingPos.func_177958_n());
            newEntityNbt.func_74768_a("TileY", placeHangingPos.func_177956_o());
            newEntityNbt.func_74768_a("TileZ", placeHangingPos.func_177952_p());
            newEntityNbt.func_74774_a("Facing", (byte)this.hangingFacing.func_176736_b());
        } else {
            rotate = true;
        }
        Entity entity = EntityList.func_75615_a((NBTTagCompound)(replaceNbt != null ? (NBTTagCompound)NBTUtilBC.merge((NBTBase)newEntityNbt, (NBTBase)replaceNbt) : newEntityNbt), (World)world);
        if (entity != null) {
            if (rotate) {
                entity.func_70012_b(placePos.field_72450_a, placePos.field_72448_b, placePos.field_72449_c, entity.field_70177_z + (entity.field_70177_z - entity.func_184229_a(this.entityRotation)), entity.field_70125_A);
            }
            world.func_72838_d(entity);
        }
        return entity;
    }

    public Entity buildWithoutChecks(World world, BlockPos basePos) {
        return this.build(world, basePos);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("entityNbt", (NBTBase)this.entityNbt);
        nbt.func_74782_a("pos", (NBTBase)NBTUtilBC.writeVec3d((Vec3d)this.pos));
        nbt.func_74782_a("hangingPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.hangingPos));
        nbt.func_74782_a("hangingFacing", NBTUtilBC.writeEnum((Enum)this.hangingFacing));
        nbt.func_74782_a("entityRotation", NBTUtilBC.writeEnum((Enum)this.entityRotation));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) throws InvalidInputDataException {
        this.entityNbt = nbt.func_74775_l("entityNbt");
        this.pos = NBTUtilBC.readVec3d((NBTBase)nbt.func_74781_a("pos"));
        this.hangingPos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("hangingPos"));
        this.hangingFacing = (EnumFacing)NBTUtilBC.readEnum((NBTBase)nbt.func_74781_a("hangingFacing"), EnumFacing.class);
        this.entityRotation = (Rotation)NBTUtilBC.readEnum((NBTBase)nbt.func_74781_a("entityRotation"), Rotation.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchematicEntityDefault that = (SchematicEntityDefault)o;
        return this.entityNbt.equals((Object)that.entityNbt) && this.pos.equals((Object)that.pos) && this.hangingPos.equals((Object)that.hangingPos) && this.hangingFacing == that.hangingFacing && this.entityRotation == that.entityRotation;
    }

    public int hashCode() {
        int result = this.entityNbt.hashCode();
        result = 31 * result + this.pos.hashCode();
        result = 31 * result + this.hangingPos.hashCode();
        result = 31 * result + this.hangingFacing.hashCode();
        result = 31 * result + this.entityRotation.hashCode();
        return result;
    }
}

