/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.builders.snapshot.EnumNbtCompareOperation;
import buildcraft.builders.snapshot.JsonRule;
import buildcraft.builders.snapshot.JsonSelector;
import buildcraft.builders.snapshot.NbtPath;
import buildcraft.builders.snapshot.NbtRef;
import buildcraft.builders.snapshot.RequiredExtractor;
import buildcraft.lib.BCLib;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.JsonUtil;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.tuple.Pair;

public class RulesLoader {
    private static final Gson GSON = JsonUtil.registerNbtSerializersDeserializers((GsonBuilder)new GsonBuilder()).registerTypeAdapter(BlockPos.class, (json, typeOfT, context) -> new BlockPos(json.getAsJsonArray().get(0).getAsInt(), json.getAsJsonArray().get(1).getAsInt(), json.getAsJsonArray().get(2).getAsInt())).registerTypeAdapter(RequiredExtractor.class, RequiredExtractor.DESERIALIZER).registerTypeAdapter(EnumNbtCompareOperation.class, EnumNbtCompareOperation.DESERIALIZER).registerTypeAdapter(NbtPath.class, NbtPath.DESERIALIZER).registerTypeAdapterFactory(JsonSelector.TYPE_ADAPTER_FACTORY).registerTypeAdapterFactory(NbtRef.TYPE_ADAPTER_FACTORY).create();
    private static final List<JsonRule> RULES = new ArrayList<JsonRule>();
    public static final Set<String> READ_DOMAINS = new HashSet<String>();
    private static final LoadingCache<Pair<IBlockState, NBTTagCompound>, Set<JsonRule>> BLOCK_RULES_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(CacheLoader.from(pair -> RulesLoader.getBlockRulesInternal((IBlockState)pair.getLeft(), (NBTTagCompound)pair.getRight())));

    public static void loadAll() {
        RULES.clear();
        READ_DOMAINS.clear();
        for (ModContainer modContainer : Loader.instance().getModList()) {
            InputStream inputStream;
            String domain2 = modContainer.getModId();
            if (READ_DOMAINS.contains(domain2)) continue;
            String base = "assets/" + domain2 + "/compat/buildcraft/builders/";
            if (modContainer.getMod() == null || (inputStream = modContainer.getMod().getClass().getClassLoader().getResourceAsStream(base + "index.json")) == null) continue;
            ((List)GSON.fromJson((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), new TypeToken<List<String>>(){}.getType())).stream().map(name -> base + name + ".json").map(name -> {
                InputStream resourceAsStream = modContainer.getMod().getClass().getClassLoader().getResourceAsStream((String)name);
                if (resourceAsStream == null) {
                    throw new RuntimeException(new IOException("Can't read " + name));
                }
                return resourceAsStream;
            }).flatMap(localInputStream -> ((List)GSON.fromJson((Reader)new InputStreamReader((InputStream)localInputStream), new TypeToken<List<JsonRule>>(){}.getType())).stream()).forEach(RULES::add);
            READ_DOMAINS.add(domain2);
        }
        READ_DOMAINS.add("minecraft");
        READ_DOMAINS.add("buildcraftcore");
        READ_DOMAINS.add("buildcraftlib");
        READ_DOMAINS.add("buildcraftbuilders");
        READ_DOMAINS.add("buildcraftenergy");
        READ_DOMAINS.add("buildcraftfactory");
        READ_DOMAINS.add("buildcraftrobotics");
        READ_DOMAINS.add("buildcraftsilicon");
        READ_DOMAINS.add("buildcrafttransport");
        if (!BCLib.DEV) {
            READ_DOMAINS.removeIf(domain -> domain.startsWith("buildcraft"));
        }
    }

    private static Set<JsonRule> getBlockRulesInternal(IBlockState blockState, NBTTagCompound tileNbt) {
        return RULES.stream().filter(rule -> rule.selectors != null).filter(rule -> rule.selectors.stream().anyMatch(selector -> selector.matches(base -> {
            boolean complex = base.contains("[");
            return Block.func_149684_b((String)(complex ? base.substring(0, base.indexOf("[")) : base)) == blockState.func_177230_c() && (!complex || Arrays.stream(base.substring(base.indexOf("[") + 1, base.indexOf("]")).split(", ")).map(nameValue -> nameValue.split("=")).allMatch(nameValue -> blockState.func_177227_a().stream().filter(property -> property.func_177701_a().equals(nameValue[0])).findFirst().map(property -> BlockUtil.getPropertyStringValue((IBlockState)blockState, (IProperty)property)).map(nameValue[1]::equals).orElse(false)));
        }, tileNbt == null ? new NBTTagCompound() : tileNbt))).collect(Collectors.toCollection(HashSet::new));
    }

    public static Set<JsonRule> getRules(IBlockState blockState, NBTTagCompound tileNbt) {
        return (Set)BLOCK_RULES_CACHE.getUnchecked((Object)Pair.of((Object)blockState, (Object)tileNbt));
    }

    public static Set<JsonRule> getRules(ResourceLocation entityId, NBTTagCompound tileNbt) {
        return RULES.stream().filter(rule -> rule.selectors != null).filter(rule -> rule.selectors.stream().anyMatch(selector -> selector.matches(entityId.toString()::equals, tileNbt))).collect(Collectors.toCollection(HashSet::new));
    }
}

