/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.builders.snapshot.Snapshot;
import buildcraft.lib.misc.data.SingleCache;
import buildcraft.lib.nbt.NbtSquisher;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class GlobalSavedDataSnapshots {
    private static final String SNAPSHOT_FILE_EXTENSION = ".bcnbt";
    private static final Map<Side, GlobalSavedDataSnapshots> INSTANCES = new EnumMap<Side, GlobalSavedDataSnapshots>(Side.class);
    private final LoadingCache<Snapshot.Key, Optional<Snapshot>> snapshotsCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(CacheLoader.from(key -> Optional.ofNullable(this.readSnapshot((Snapshot.Key)key)).map(Pair::getLeft)));
    private final SingleCache<List<Snapshot.Key>> listCache = new SingleCache(this::readList, 1L, TimeUnit.SECONDS);
    private final File snapshotsFile;

    private GlobalSavedDataSnapshots(Side side) {
        this.snapshotsFile = new File(FMLCommonHandler.instance().getSavesDirectory().getParentFile(), "snapshots-" + side.name().toLowerCase(Locale.ROOT));
        if (!this.snapshotsFile.exists()) {
            if (!this.snapshotsFile.mkdirs()) {
                throw new RuntimeException("Failed to make the directories required for snapshots: " + this.snapshotsFile);
            }
        } else if (!this.snapshotsFile.isDirectory()) {
            throw new IllegalStateException("The snapshots directory was not a directory: " + this.snapshotsFile);
        }
    }

    public static void reInit(Side side) {
        INSTANCES.put(side, new GlobalSavedDataSnapshots(side));
    }

    public static GlobalSavedDataSnapshots get(Side side) {
        if (!INSTANCES.containsKey(side)) {
            INSTANCES.put(side, new GlobalSavedDataSnapshots(side));
        }
        return INSTANCES.get(side);
    }

    public static GlobalSavedDataSnapshots get(World world) {
        return GlobalSavedDataSnapshots.get(world.field_72995_K ? Side.CLIENT : Side.SERVER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<Snapshot, File> readSnapshot(Snapshot.Key key) {
        File[] files = this.snapshotsFile.listFiles();
        if (files == null) return null;
        File[] fileArray = files;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File snapshotFile = fileArray[n2];
            if (snapshotFile.getName().startsWith(key.toString()) && snapshotFile.getName().endsWith(SNAPSHOT_FILE_EXTENSION)) {
                try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
                    Snapshot snapshot = Snapshot.readFromNBT(NbtSquisher.expand((InputStream)fileInputStream));
                    if (Objects.equals(snapshot.key, key)) {
                        Pair pair = Pair.of((Object)snapshot, (Object)snapshotFile);
                        return pair;
                    }
                }
                catch (IOException e) {
                    new IOException("Failed to read the snapshot " + snapshotFile, e).printStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }

    private List<Snapshot.Key> readList() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        File[] files = this.snapshotsFile.listFiles();
        if (files != null) {
            for (File snapshotFile : files) {
                if (!snapshotFile.getName().endsWith(SNAPSHOT_FILE_EXTENSION)) continue;
                try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
                    Snapshot snapshot = Snapshot.readFromNBT(NbtSquisher.expand((InputStream)fileInputStream));
                    if (!snapshotFile.getName().startsWith(snapshot.key.toString())) continue;
                    listBuilder.add((Object)snapshot.key);
                }
                catch (IOException io) {
                    new IOException("Failed to read the snapshot " + snapshotFile, io).printStackTrace();
                }
            }
        }
        return listBuilder.build();
    }

    public void addSnapshot(Snapshot snapshot) {
        File snapshotFile = new File(this.snapshotsFile, snapshot.key.toString() + SNAPSHOT_FILE_EXTENSION);
        if (!snapshotFile.exists()) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
                NbtSquisher.squishVanilla((NBTTagCompound)Snapshot.writeToNBT(snapshot), (OutputStream)fileOutputStream);
            }
            catch (IOException e) {
                new IOException("Failed to write the snapshot file: " + snapshotFile, e).printStackTrace();
            }
        }
        this.snapshotsCache.invalidate((Object)snapshot.key);
        this.listCache.clear();
    }

    public void removeSnapshot(Snapshot.Key key) {
        Optional.ofNullable(this.readSnapshot(key)).map(Pair::getRight).ifPresent(snapshotFile -> {
            if (!snapshotFile.delete()) {
                new IOException("Failed to read the snapshot file: " + snapshotFile).printStackTrace();
            }
            this.snapshotsCache.invalidate((Object)key);
        });
        this.listCache.clear();
    }

    @Nullable
    public Snapshot getSnapshot(@Nullable Snapshot.Key key) {
        if (key == null) {
            return null;
        }
        return ((Optional)this.snapshotsCache.getUnchecked((Object)key)).orElse(null);
    }

    public List<Snapshot.Key> getList() {
        return (List)this.listCache.get();
    }
}

