/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.waypoint.render;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import xaero.common.HudMod;
import xaero.common.minimap.element.render.MinimapElementRenderProvider;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointVisibilityType;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.DestinationHandler;
import xaero.hud.minimap.waypoint.render.AbstractWaypointRenderContext;
import xaero.hud.minimap.world.MinimapWorld;

public abstract class AbstractWaypointRenderProvider<C extends AbstractWaypointRenderContext>
extends MinimapElementRenderProvider<Waypoint, C> {
    private final List<Waypoint> collectingList = new ArrayList<Waypoint>();
    private Iterator<Waypoint> iterator;
    private boolean deathpoints;
    private DestinationHandler destinationHandler;
    public final Predicate<Waypoint> filter = new Predicate<Waypoint>(){

        @Override
        public boolean test(Waypoint w) {
            if (w.isDisabled()) {
                return false;
            }
            if (w.getVisibility() == WaypointVisibilityType.WORLD_MAP_LOCAL) {
                return false;
            }
            if (w.getVisibility() == WaypointVisibilityType.WORLD_MAP_GLOBAL) {
                return false;
            }
            return AbstractWaypointRenderProvider.this.deathpoints || !w.getPurpose().isDeath();
        }
    };

    @Override
    public void begin(MinimapElementRenderLocation location, C context) {
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        this.collectingList.clear();
        session.getWaypointSession().getCollector().collect(this.collectingList);
        ModSettings settings = HudMod.INSTANCE.getSettings();
        MinimapWorld currentWorld = session.getWorldManager().getCurrentWorld();
        this.destinationHandler = session.getWaypointSession().getDestinationHandler();
        Entity renderEntity = Minecraft.func_71410_x().func_175606_aa();
        this.destinationHandler.begin(renderEntity, currentWorld, settings.renderAllSets, settings.deleteReachedDeathpoints);
        this.deathpoints = settings.getDeathpoints();
        Vec3d cameraPos = ActiveRenderInfo.getCameraPosition().func_72441_c(renderEntity.field_70165_t, renderEntity.field_70163_u, renderEntity.field_70161_v);
        ((AbstractWaypointRenderContext)context).dimCoordinateScale = session.getDimensionHelper().getDimCoordinateScale(currentWorld);
        double cameraPosMultiplier = Misc.getDimensionTypeScale((World)Minecraft.func_71410_x().field_71441_e) / ((AbstractWaypointRenderContext)context).dimCoordinateScale;
        Waypoint.RENDER_SORTING_POS = new Vec3d(cameraPos.field_72450_a * cameraPosMultiplier, cameraPos.field_72448_b, cameraPos.field_72449_c * cameraPosMultiplier);
        this.iterator = this.collectingList.stream().filter(this.filter).sorted().iterator();
    }

    @Override
    public boolean hasNext(MinimapElementRenderLocation location, C context) {
        return this.iterator.hasNext();
    }

    @Override
    public Waypoint getNext(MinimapElementRenderLocation location, C context) {
        Waypoint result = this.iterator.next();
        this.destinationHandler.handle(result);
        return result;
    }

    @Override
    public void end(MinimapElementRenderLocation location, C context) {
        this.iterator = null;
        this.deathpoints = false;
        this.destinationHandler.end();
        this.destinationHandler = null;
    }

    @Override
    public Waypoint setupContextAndGetNext(MinimapElementRenderLocation location, C context) {
        return this.getNext(location, context);
    }
}

