/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.settings;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.settings.ModSettings;

public enum ModOptions {
    DEFAULT("Default", false, true, false),
    MINIMAP("gui.xaero_minimap", false, true, new CursorBox("gui.xaero_box_minimap"), false),
    CAVE_MAPS("gui.xaero_cave_maps", false, true, new CursorBox("gui.xaero_box_cave_maps2"), false),
    CAVE_ZOOM("gui.xaero_cave_zoom", false, true, new CursorBox("gui.xaero_box_cave_zoom"), false),
    DISPLAY_OTHER_TEAM("gui.xaero_display_teams", false, true, false),
    WAYPOINTS("gui.xaero_display_waypoints", false, true, false),
    INGAME_WAYPOINTS("gui.xaero_ingame_waypoints", false, true, false),
    ZOOM("gui.xaero_zoom", false, true, false),
    SIZE("gui.xaero_minimap_size", true, false, 54.0f, 250.0f, 1.0f, new CursorBox("gui.xaero_box_minimap_size"), false),
    EAMOUNT("gui.xaero_entity_amount", false, true, new CursorBox("gui.xaero_box_entity_amount"), false),
    NORTH("gui.xaero_lock_north", false, true, false),
    DEATHPOINTS("gui.xaero_deathpoints", false, true, false),
    OLD_DEATHPOINTS("gui.xaero_old_deathpoints", false, true, false),
    CHUNK_GRID("gui.xaero_chunkgrid", true, false, -1.0f, ModSettings.COLORS.length - 1, 1.0f, false),
    SLIME_CHUNKS("gui.xaero_slime_chunks", false, true, false),
    SAFE_MAP("gui.xaero_safe_mode", false, true, new CursorBox("gui.xaero_safe_mode_box"), false),
    OPACITY("gui.xaero_opacity", true, false, 30.0f, 100.0f, 1.0f, false),
    WAYPOINTS_ICON_SCALE("gui.xaero_ingame_waypoint_icon_scale", true, false, 0.0f, 17.0f, 1.0f, new CursorBox("gui.xaero_box_ingame_waypoint_icon_scale"), false),
    WAYPOINTS_DISTANCE_SCALE("gui.xaero_waypoints_distance_scale", true, false, 0.0f, 17.0f, 1.0f, new CursorBox("gui.xaero_box_waypoints_distance_scale2"), false),
    WAYPOINTS_NAME_SCALE("gui.xaero_waypoints_name_scale", true, false, 0.0f, 17.0f, 1.0f, new CursorBox("gui.xaero_box_waypoints_name_scale2"), false),
    WAYPOINTS_CLOSE_SCALE("gui.xaero_ingame_waypoint_close_scale", true, false, 0.125f, 8.0f, 0.025f, new CursorBox("gui.xaero_box_ingame_waypoint_close_scale"), false),
    AA("gui.xaero_antialiasing", false, true, false),
    DISTANCE("gui.xaero_show_distance", false, true, new CursorBox("gui.xaero_box_distance2"), false),
    COLOURS("gui.xaero_block_colours", false, true, false),
    LIGHT("gui.xaero_lighting", false, true, false),
    REDSTONE("gui.xaero_display_redstone", false, true, false),
    DOTS_SIZE("gui.xaero_dots_size", true, false, EntityRadarCategorySettings.DOT_SIZE.getUiFirstOption(), EntityRadarCategorySettings.DOT_SIZE.getUiLastOption(), 1.0f, false),
    DOTS_STYLE("gui.xaero_dots_style", false, true, false),
    DOT_NAME_SCALE("gui.xaero_dot_name_scale", true, false, 1.0f, 3.0f, 0.5f, false),
    HEADS_SCALE("gui.xaero_entity_heads_scale", true, false, EntityRadarCategorySettings.ICON_SCALE.getUiFirstOption(), EntityRadarCategorySettings.ICON_SCALE.getUiLastOption(), 1.0f, false),
    COMPASS("gui.xaero_compass_over_everything", false, true, new CursorBox("gui.xaero_box_compass_over_everything"), false),
    ENTITY_HEIGHT("gui.xaero_entity_depth", false, true, new CursorBox("gui.xaero_box_entity_depth"), false),
    START_FADING_AT("gui.xaero_start_fading_at", true, false, EntityRadarCategorySettings.START_FADING_AT.getUiFirstOption(), EntityRadarCategorySettings.START_FADING_AT.getUiLastOption(), 1.0f, new CursorBox("gui.xaero_box_start_fading_at"), false),
    FLOWERS("gui.xaero_show_flowers", false, true, false),
    KEEP_WP_NAMES("gui.xaero_waypoint_names", false, true, false),
    WAYPOINTS_DISTANCE("gui.xaero_waypoints_distance", true, false, 0.0f, 20.0f, 1.0f, new CursorBox("gui.xaero_box_waypoints_distance2"), false),
    WAYPOINTS_DISTANCE_MIN("gui.xaero_waypoints_distance_min", true, false, 0.0f, 100.0f, 5.0f, false),
    WAYPOINTS_DEFAULT_TP("gui.xaero_teleport_default_command", false, true, new CursorBox("gui.xaero_box_teleport_default_command"), false),
    WAYPOINTS_ALL_SETS("gui.xaero_render_all_wp_sets", false, true, false),
    ARROW_SCALE("gui.xaero_arrow_scale", true, false, 1.0f, 2.0f, 0.1f, new CursorBox("gui.xaero_box_arrow_scale"), false),
    ARROW_COLOUR("gui.xaero_arrow_colour", false, true, new CursorBox("gui.xaero_box_arrow_color"), false),
    SMOOTH_DOTS("gui.xaero_smooth_dots", false, true, false),
    ENTITY_NAMETAGS("gui.xaero_always_entity_nametags", false, true, new CursorBox("gui.xaero_box_always_entity_nametags2"), false),
    HEIGHT_LIMIT("gui.xaero_height_limit", true, false, EntityRadarCategorySettings.HEIGHT_LIMIT.getUiFirstOption(), EntityRadarCategorySettings.HEIGHT_LIMIT.getUiLastOption(), 1.0f, new CursorBox("gui.xaero_box_height_limit"), false),
    WORLD_MAP("gui.xaero_use_world_map", false, true, false),
    TERRAIN_DEPTH("gui.xaero_terrain_depth", false, true, false),
    TERRAIN_SLOPES("gui.xaero_terrain_slopes", false, true, false),
    MAIN_ENTITY_AS("gui.xaero_main_entity_as", false, true, false),
    BLOCK_TRANSPARENCY("gui.xaero_block_transparency", false, true, false),
    WAYPOINT_OPACITY_INGAME("gui.xaero_waypoint_opacity_ingame", true, false, 10.0f, 100.0f, 1.0f, false),
    WAYPOINT_OPACITY_MAP("gui.xaero_waypoint_opacity_map", true, false, 10.0f, 100.0f, 1.0f, false),
    WAYPOINT_LOOKING_ANGLE("gui.xaero_waypoint_distance_visibility_angle", true, false, 1.0f, 180.0f, 1.0f, false),
    WAYPOINT_VERTICAL_LOOKING_ANGLE("gui.xaero_waypoint_distance_vertical_visibility_angle", true, false, 1.0f, 180.0f, 1.0f, false),
    HIDE_WORLD_NAMES("gui.xaero_hide_world_names", false, true, false),
    OPEN_SLIME_SETTINGS("gui.xaero_open_slime", false, true, false),
    ALWAYS_SHOW_DISTANCE("gui.xaero_always_show_distance", false, true, new CursorBox("gui.xaero_box_always_distance"), false),
    RENDER_LAYER("gui.xaero_render_layer", false, true, false),
    BIOMES_VANILLA("gui.xaero_biomes_vanilla", false, true, false),
    CENTERED_ENLARGED("gui.xaero_centered_enlarged", false, true, false),
    ZOOM_ON_ENLARGE("gui.xaero_zoom_on_enlarge", false, true, false),
    MINIMAP_TEXT_ALIGN("gui.xaero_minimap_text_align", false, true, false),
    COMPASS_LOCATION("gui.xaero_compass", false, true, new CursorBox("gui.xaero_box_compass"), false),
    CAVE_MAPS_DEPTH("gui.xaero_cave_maps_depth", true, false, 0.0f, 64.0f, 1.0f, false),
    HIDE_WP_COORDS("gui.xaero_hide_wp_coords", false, true, false),
    PLAYER_ARROW_OPACITY("gui.xaero_player_arrow_opacity", true, false, 1.0f, 100.0f, 1.0f, false),
    WAYPOINTS_BOTTOM("gui.xaero_waypoints_bottom", false, true, new CursorBox("gui.xaero_box_waypoints_bottom"), false),
    MINIMAP_SHAPE("gui.xaero_minimap_shape", false, true, false),
    LIGHT_OVERLAY_TYPE("gui.xaero_light_overlay_type", false, true, new CursorBox("gui.xaero_box_light_overlay_type"), false),
    LIGHT_OVERLAY_COLOR("gui.xaero_light_overlay_color", true, false, 0.0f, 15.0f, 1.0f, false),
    LIGHT_OVERLAY_MAX_LIGHT("gui.xaero_light_overlay_max_light", true, false, 0.0f, 15.0f, 1.0f, false),
    LIGHT_OVERLAY_MIN_LIGHT("gui.xaero_light_overlay_min_light", true, false, 0.0f, 15.0f, 1.0f, false),
    UI_SCALE("gui.xaero_ui_scale", true, false, 1.0f, 11.0f, 1.0f, new CursorBox("gui.xaero_box_ui_scale"), false),
    BOSS_HEALTH_PUSHBOX("gui.xaero_pushbox_boss_health", false, true, new CursorBox("gui.xaero_box_pushbox_boss_health"), false),
    POTION_EFFECTS_PUSHBOX("gui.xaero_pushbox_potion_effects", false, true, new CursorBox("gui.xaero_box_pushbox_potion_effects"), false),
    MINIMAP_FRAME("gui.xaero_minimap_frame", false, true, false),
    MINIMAP_FRAME_COLOR("gui.xaero_minimap_frame_color", true, false, 0.0f, ModSettings.COLORS.length - 1, 1.0f, new CursorBox("gui.xaero_box_minimap_frame_color"), false),
    COMPASS_SCALE("gui.xaero_compass_scale2", true, false, 0.0f, 16.0f, 1.0f, new CursorBox("gui.xaero_box_compass_scale2"), false),
    COMPASS_COLOR("gui.xaero_compass_color", true, false, 0.0f, ModSettings.COLORS.length - 1, 1.0f, new CursorBox("gui.xaero_box_compass_color"), false),
    RADAR_ITEM_FRAMES("gui.xaero_radar_item_frames", false, true, false),
    ICON_NAME_FALLBACK("gui.xaero_entity_icon_name_fallback", false, true, false),
    UPDATE_NOTIFICATION("gui.xaero_update_notification", false, true, false),
    ADJUST_HEIGHT_FOR_SHORT_BLOCKS("gui.xaero_adjust_height_for_carpetlike_blocks", false, true, new CursorBox("gui.xaero_box_adjust_height_for_carpetlike_blocks"), false),
    AUTO_CONVERT_TO_KM("gui.xaero_auto_convert_wp_distance_km", true, false, -1.0f, 10.0f, 1.0f, false),
    WP_DISTANCE_PRECISION("gui.xaero_waypoint_distance_precision", true, false, 0.0f, 10.0f, 1.0f, false),
    MAIN_DOT_SIZE("gui.xaero_main_entity_dot_size", true, false, 1.0f, 4.0f, 1.0f, false),
    PARTIAL_Y_TELEPORTATION("gui.xaero_partial_y_teleportation", false, true, new CursorBox("gui.xaero_box_partial_y_teleportation"), false),
    DELETE_REACHED_DEATHPOINTS("gui.xaero_delete_reached_deathpoints", false, true, new CursorBox("gui.xaero_box_delete_reached_deathpoints"), false),
    HIDE_MINIMAP_UNDER_SCREEN("gui.xaero_hide_minimap_under_screen", false, true, new CursorBox("gui.xaero_box_hide_minimap_under_screen"), false),
    HIDE_MINIMAP_UNDER_F3("gui.xaero_hide_minimap_under_f3", false, true, new CursorBox("gui.xaero_box_hide_minimap_under_f3"), false),
    NORTH_COMPASS_COLOR("gui.xaero_north_compass_color", true, false, -1.0f, ModSettings.COLORS.length - 1, 1.0f, new CursorBox("gui.xaero_box_north_compass_color"), false),
    RADAR_Y_DISPLAYED("gui.xaero_entity_display_height_full", false, true, false),
    MANUAL_CAVE_MODE_START("gui.xaero_manual_cave_mode_start", true, false, 0.0f, 32.0f, 1.0f, new CursorBox("gui.xaero_box_manual_cave_mode_start"), false),
    CHUNK_GRID_LINE_WIDTH("gui.xaero_chunk_grid_line_width", true, false, 1.0f, 8.0f, 1.0f, false),
    RADAR_OVER_FRAME("gui.xaero_radar_render_radar_over_frame", false, true, new CursorBox("gui.xaero_box_radar_render_over_minimap"), false),
    TEMPORARY_WAYPOINTS_GLOBAL("gui.xaero_temp_waypoints_global", false, true, new CursorBox("gui.xaero_box_temp_waypoints_global"), false),
    KEEP_ENLARGED_UNLOCKED("gui.xaero_keep_enlarged_minimap_unlocked", false, true, new CursorBox("gui.xaero_box_keep_enlarged_minimap_unlocked"), false),
    TOGGLED_ENLARGED("gui.xaero_enlarged_minimap_a_toggle", false, true, new CursorBox("gui.xaero_box_enlarged_minimap_a_toggle"), false),
    IGNORE_HEIGHTMAPS("gui.xaero_ignore_heightmaps", false, true, new CursorBox("gui.xaero_box_ignore_heightmaps"), true),
    MULTIPLE_WAYPOINT_INFO("gui.xaero_multiple_waypoint_info", false, true, new CursorBox("gui.xaero_box_multiple_waypoint_info"), false),
    RADAR_DISPLAYED("gui.xaero_radar_setting_displayed", false, true, false),
    RADAR_NAMES_DISPLAYED("gui.xaero_radar_setting_names", false, true, new CursorBox("gui.xaero_box_entity_radar_names"), false),
    RADAR_ICONS_DISPLAYED("gui.xaero_radar_setting_icons", false, true, new CursorBox("gui.xaero_box_entity_radar_icons"), false),
    DISPLAY_STAINED_GLASS("gui.xaero_display_stained_glass", false, true, false),
    WAYPOINT_ONMAP_SCALE("gui.xaero_waypoint_onmap_scale", true, false, 0.0f, 16.0f, 1.0f, false),
    SWITCH_TO_AUTO_ON_DEATH("gui.xaero_switch_to_auto_on_death", false, true, new CursorBox("gui.xaero_box_switch_to_auto_on_death"), false),
    INFO_DISPLAY_BG_OPACITY("gui.xaero_info_display_background_opacity", true, false, 1.0f, 100.0f, 1.0f, new CursorBox("gui.xaero_box_info_display_background_opacity"), false),
    CAVE_MODE_TOGGLE_TIMER("gui.xaero_cave_mode_toggle_timer", true, false, 0.0f, 10000.0f, 100.0f, new CursorBox("gui.xaero_box_cave_mode_toggle_timer"), false),
    LEGIBLE_CAVE_MAPS("gui.xaero_legible_cave_maps", false, true, new CursorBox("gui.xaero_box_legible_cave_maps"), false),
    TRACKED_PLAYERS_ON_MAP("gui.xaero_tracked_players_on_map", false, true, new CursorBox("gui.xaero_box_tracked_players_on_map"), false),
    TRACKED_PLAYERS_IN_WORLD("gui.xaero_tracked_players_in_world", false, true, new CursorBox("gui.xaero_box_tracked_players_in_world"), false),
    SCALED_MAX_WAYPOINT_DISTANCE("gui.xaero_dimension_scaled_max_waypoint_distance", false, true, new CursorBox("gui.xaero_box_dimension_scaled_max_waypoint_distance"), false),
    TRACKED_PLAYER_WORLD_ICON_SCALE("gui.xaero_tracked_player_world_icon_scale", true, false, 0.0f, 17.0f, 1.0f, new CursorBox("gui.xaero_box_tracked_player_world_icon_scale"), false),
    TRACKED_PLAYER_WORLD_NAME_SCALE("gui.xaero_tracked_player_world_name_scale", true, false, 0.0f, 17.0f, 1.0f, new CursorBox("gui.xaero_box_tracked_player_world_name_scale"), false),
    TRACKED_PLAYER_MINIMAP_ICON_SCALE("gui.xaero_tracked_player_minimap_icon_scale", true, false, 0.0f, 17.0f, 1.0f, new CursorBox("gui.xaero_box_tracked_player_minimap_icon_scale"), false),
    SHOW_EFFECTS("gui.xaero_potion_status", false, true, new CursorBox("gui.xaero_box_potion_effects"), false),
    SHOW_ARMOR("gui.xaero_armour_status", false, true, new CursorBox("gui.xaero_box_armour_status"), false),
    BETTER_SPRINT("gui.xaero_sprint", false, true, new CursorBox("gui.xaero_box_sprint"), false),
    KEEP_SNEAK("gui.xaero_sneak", false, true, new CursorBox("gui.xaero_box_sneak"), false),
    ENCHANT_COLOR("gui.xaero_enchants_color", false, true, false),
    DURABILITY("gui.xaero_durability", false, true, false),
    NOTIFICATIONS("gui.xaero_notifications", false, true, new CursorBox("gui.xaero_box_notifications"), false),
    NOTIFICATIONS_HUNGER("gui.xaero_hunger_setting", false, true, false),
    NOTIFICATIONS_HUNGER_LOW("gui.xaero_hunger_low", false, true, false),
    NOTIFICATIONS_HP("gui.xaero_hp_setting", false, true, false),
    NOTIFICATIONS_HP_LOW("gui.xaero_hp_low", false, true, false),
    NOTIFICATIONS_TNT("gui.xaero_explosion_setting", false, true, false),
    NOTIFICATIONS_ARROW("gui.xaero_being_shot_setting", false, true, false),
    NOTIFICATIONS_AIR("gui.xaero_air_setting", false, true, false),
    NOTIFICATIONS_AIR_LOW("gui.xaero_air_low", false, true, false),
    XP("gui.xaero_xp_setting", false, true, new CursorBox("gui.xaero_box_xp"), false),
    NUMBERS("gui.xaero_quick_use", false, true, new CursorBox("gui.xaero_box_quick_use"), false),
    SHOW_ENCHANTS("gui.xaero_show_enchants", false, true, false),
    ARCHERY("gui.xaero_archery_status", false, true, false),
    POTION_NAMES("gui.xaero_potion_names", false, true, false),
    POTION_EFFECTS_BLINK("gui.xaero_potion_effects_blink", false, true, false),
    ENTITY_INFO("gui.xaero_entity_info", false, true, new CursorBox("gui.xaero_box_entity_info"), false),
    ENTITY_INFO_STAY("gui.xaero_entity_info_stay", false, true, false),
    ENTITY_INFO_DISTANCE("gui.xaero_entity_info_distance", true, false, 1.0f, 40.0f, 1.0f, false),
    ENTITY_INFO_MAX_HEARTS("gui.xaero_entity_info_max_hearts", true, false, 10.0f, 1000.0f, 10.0f, false),
    ENTITY_INFO_NUMBERS("gui.xaero_entity_info_numbers", false, true, false),
    ENTITY_INFO_EFFECTS("gui.xaero_entity_info_potion_effects", false, true, false),
    ENTITY_INFO_EFFECTS_SCALE("gui.xaero_entity_info_potion_effects_scale", true, false, 1.0f, 4.0f, 1.0f, false),
    SHOW_FULL_AMOUNT("gui.xaero_show_full_amount", false, true, false),
    ENTITY_INFO_ARMOUR_NUMBERS("gui.xaero_entity_info_armour_numbers", false, true, false),
    ENTITY_INFO_ARMOUR("gui.xaero_entity_info_armour", false, true, false),
    SHOW_ENTITY_MODEL("gui.xaero_show_entity_model", false, true, false),
    ITEM_TOOLTIP("gui.xaero_item_tooltip", false, true, false),
    ITEM_TOOLTIP_MIN_LINES("gui.xaero_item_tooltip_min_lines", true, false, 0.0f, 10.0f, 1.0f, false),
    ITEM_TOOLTIP_TIME("gui.xaero_item_tooltip_time", true, false, 1.0f, 40.0f, 1.0f, false),
    ARMOUR_MAIN_HAND("gui.xaero_armour_main_hand", false, true, false),
    ARMOUR_OFF_HAND("gui.xaero_armour_off_hand", false, true, false),
    HELD_ITEMS_CENTERED_POSITION("gui.xaero_held_centered_position", false, true, false);

    private static final CursorBox REQUIRES_INGAME;
    private static final CursorBox WORLD_MAP_BOX;
    private static final CursorBox WORLD_MAP_HARD_BOX;
    private static final CursorBox WORLD_MAP_SCREEN_BOX;
    private final boolean enumFloat;
    private final boolean enumBoolean;
    private final String enumString;
    private double valueMin;
    private double valueMax;
    private double valueStep;
    private CursorBox tooltip;
    private boolean ingameOnly;

    private ModOptions(String par3Str, boolean par4, boolean par5, boolean ingameOnly) {
        this(par3Str, par4, par5, null, ingameOnly);
    }

    public static ModOptions getModOptions(int par0) {
        for (ModOptions enumoptions : ModOptions.values()) {
            if (enumoptions.returnEnumOrdinal() != par0) continue;
            return enumoptions;
        }
        return null;
    }

    private ModOptions(String par3Str, boolean par4, boolean par5, CursorBox tooltip, boolean ingameOnly) {
        this.enumString = par3Str;
        this.enumFloat = par4;
        this.enumBoolean = par5;
        this.tooltip = tooltip;
        this.ingameOnly = ingameOnly;
    }

    private ModOptions(String p_i45004_3_, boolean p_i45004_4_, boolean p_i45004_5_, float p_i45004_6_, float p_i45004_7_, float p_i45004_8_, boolean ingameOnly) {
        this(p_i45004_3_, p_i45004_4_, p_i45004_5_, p_i45004_6_, p_i45004_7_, p_i45004_8_, null, ingameOnly);
    }

    private ModOptions(String p_i45004_3_, boolean p_i45004_4_, boolean p_i45004_5_, float p_i45004_6_, float p_i45004_7_, float p_i45004_8_, CursorBox tooltip, boolean ingameOnly) {
        this.enumString = p_i45004_3_;
        this.enumFloat = p_i45004_4_;
        this.enumBoolean = p_i45004_5_;
        this.valueMin = p_i45004_6_;
        this.valueMax = p_i45004_7_;
        this.valueStep = p_i45004_8_;
        this.tooltip = tooltip;
        this.ingameOnly = ingameOnly;
    }

    public boolean getEnumFloat() {
        return this.enumFloat;
    }

    public boolean getEnumBoolean() {
        return this.enumBoolean;
    }

    public double getValueMin() {
        return this.valueMin;
    }

    public int returnEnumOrdinal() {
        return this.ordinal();
    }

    public double getValueMax() {
        return this.valueMax;
    }

    public double getValueStep() {
        return this.valueStep;
    }

    public void setValueMax(double p_148263_1_) {
        this.valueMax = p_148263_1_;
    }

    public double normalizeValue(double p_148266_1_) {
        return MathHelper.func_151237_a((double)((this.snapToStepClamp(p_148266_1_) - this.valueMin) / (this.valueMax - this.valueMin)), (double)0.0, (double)1.0);
    }

    public double denormalizeValue(double p_148262_1_) {
        return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * MathHelper.func_151237_a((double)p_148262_1_, (double)0.0, (double)1.0));
    }

    public double snapToStepClamp(double p_148268_1_) {
        p_148268_1_ = this.snapToStep(p_148268_1_);
        return MathHelper.func_151237_a((double)p_148268_1_, (double)this.valueMin, (double)this.valueMax);
    }

    protected double snapToStep(double p_148264_1_) {
        if (this.valueStep > 0.0) {
            p_148264_1_ = this.valueStep * (double)Math.round(p_148264_1_ / this.valueStep);
        }
        return p_148264_1_;
    }

    public String getEnumString() {
        return I18n.func_135052_a((String)this.enumString, (Object[])new Object[0]);
    }

    public String getEnumStringRaw() {
        return this.enumString;
    }

    public CursorBox getTooltip(IXaeroMinimap modMain) {
        if (this.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return REQUIRES_INGAME;
        }
        return modMain.getSettings().usesWorldMapOptionValue(this) ? WORLD_MAP_BOX : (modMain.getSettings().usesWorldMapHardValue(this) ? WORLD_MAP_HARD_BOX : (modMain.getSettings().usesWorldMapScreenValue(this) ? WORLD_MAP_SCREEN_BOX : this.tooltip));
    }

    public boolean isIngameOnly() {
        return this.ingameOnly;
    }

    static {
        REQUIRES_INGAME = new CursorBox("gui.xaero_option_requires_ingame");
        WORLD_MAP_BOX = new CursorBox("gui.xaero_uses_worldmap_value");
        WORLD_MAP_HARD_BOX = new CursorBox("gui.xaero_uses_worldmap_hard_value");
        WORLD_MAP_SCREEN_BOX = new CursorBox("gui.xaero_uses_worldmap_screen_value");
    }
}

