/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message.tracker;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import xaero.common.XaeroMinimapSession;
import xaero.common.message.MinimapMessage;
import xaero.common.message.client.ClientMessageConsumer;

public class ClientboundTrackedPlayerPacket
extends MinimapMessage<ClientboundTrackedPlayerPacket> {
    private boolean remove;
    private UUID id;
    private double x;
    private double y;
    private double z;
    private int dimension;

    public ClientboundTrackedPlayerPacket(boolean remove, UUID id, double x, double y, double z, int dimension) {
        this.remove = remove;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public ClientboundTrackedPlayerPacket() {
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound nbt;
        PacketBuffer buffer = new PacketBuffer(buf);
        try {
            nbt = buffer.func_150793_b();
        }
        catch (IOException e) {
            return;
        }
        this.remove = nbt.func_74767_n("r");
        this.id = nbt.func_186857_a("i");
        if (!this.remove) {
            this.x = nbt.func_74769_h("x");
            this.y = nbt.func_74769_h("y");
            this.z = nbt.func_74769_h("z");
            this.dimension = nbt.func_74762_e("d");
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("r", this.remove);
        nbt.func_186854_a("i", this.id);
        if (!this.remove) {
            nbt.func_74780_a("x", this.x);
            nbt.func_74780_a("y", this.y);
            nbt.func_74780_a("z", this.z);
            nbt.func_74768_a("d", this.dimension);
        }
        buffer.func_150786_a(nbt);
    }

    public static class Handler
    implements ClientMessageConsumer<ClientboundTrackedPlayerPacket> {
        @Override
        public void handle(ClientboundTrackedPlayerPacket t) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession == null) {
                return;
            }
            if (t.remove) {
                minimapSession.getMinimapProcessor().getClientSyncedTrackedPlayerManager().remove(t.id);
                return;
            }
            minimapSession.getMinimapProcessor().getClientSyncedTrackedPlayerManager().update(t.id, t.x, t.y, t.z, t.dimension);
        }
    }
}

