/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.FileUtils;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiTransfer;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWorldTpCommand;
import xaero.common.gui.MyBigButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.hud.minimap.world.container.MinimapWorldContainer;
import xaero.hud.minimap.world.container.MinimapWorldContainerUtil;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.path.XaeroPath;

public class GuiWaypointsOptions
extends ScreenBase
implements GuiYesNoCallback {
    private MinimapSession session;
    private MinimapWorldManager manager;
    private GuiButton automaticButton;
    private GuiButton subAutomaticButton;
    private GuiButton deleteButton;
    private GuiButton subDeleteButton;
    private GuiButton connectButton;
    private boolean buttonTest;
    private MinimapWorld minimapWorld;
    private MinimapWorld automaticMinimapWorld;
    private MinimapWorldRootContainer rootContainer;
    private boolean teleportationOptionShown;
    private boolean selectedWorldIsConnected;
    public CursorBox mwTooltip = new CursorBox("gui.xaero_use_multiworld_tooltip");
    public CursorBox teleportationTooltip = new CursorBox("gui.xaero_teleportation_tooltip", new Style().func_150238_a(TextFormatting.RED));
    public CursorBox connectionTooltip = new CursorBox("gui.xaero_world_connection_tooltip");

    public GuiWaypointsOptions(IXaeroMinimap modMain, MinimapSession session, GuiScreen parent, GuiScreen escapeScreen, MinimapWorld minimapWorld, XaeroPath frozenAutoWorldPath) {
        super(modMain, parent, escapeScreen);
        this.session = session;
        this.manager = this.session.getWorldManager();
        this.minimapWorld = minimapWorld;
        this.rootContainer = minimapWorld.getContainer().getRoot();
        this.automaticMinimapWorld = this.manager.getWorld(frozenAutoWorldPath);
        this.teleportationOptionShown = this.rootContainer.getConfig().isTeleportationEnabled();
    }

    @Override
    public void func_73866_w_() {
        this.parent.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.selectedWorldIsConnected = this.rootContainer.getSubWorldConnections().isConnected(this.automaticMinimapWorld, this.minimapWorld);
        this.field_146292_n.clear();
        this.field_146292_n.add(new MyTinyButton(5, this.field_146294_l / 2 - 203, 32, I18n.func_135052_a((String)"gui.xaero_close", (Object[])new Object[0])));
        this.field_146292_n.add(new MyBigButton(6, this.field_146294_l / 2 - 203, 57, I18n.func_135052_a((String)"gui.xaero_transfer", (Object[])new Object[0])));
        this.automaticButton = new MyBigButton(7, this.field_146294_l / 2 - 203, 82, I18n.func_135052_a((String)"gui.xaero_make_automatic", (Object[])new Object[0]));
        this.field_146292_n.add(this.automaticButton);
        this.subAutomaticButton = new MyBigButton(8, this.field_146294_l / 2 - 203, 107, I18n.func_135052_a((String)"gui.xaero_make_multi_automatic", (Object[])new Object[0]));
        this.field_146292_n.add(this.subAutomaticButton);
        this.deleteButton = new MyBigButton(9, this.field_146294_l / 2 - 203, 132, I18n.func_135052_a((String)"gui.xaero_delete_world", (Object[])new Object[0]));
        this.field_146292_n.add(this.deleteButton);
        this.subDeleteButton = new MyBigButton(10, this.field_146294_l / 2 - 203, 157, I18n.func_135052_a((String)"gui.xaero_delete_multi_world", (Object[])new Object[0]));
        this.field_146292_n.add(this.subDeleteButton);
        this.field_146292_n.add(new MyBigButton(200, this.field_146294_l / 2 + 3, 57, this.getConfigButtonName(0)));
        MyBigButton teleportationEnabledButton = new MyBigButton(201, this.field_146294_l / 2 + 3, 82, this.getConfigButtonName(1));
        this.field_146292_n.add(teleportationEnabledButton);
        teleportationEnabledButton.field_146124_l = this.teleportationOptionShown;
        this.func_189646_b(new MyBigButton(13, this.field_146294_l / 2 + 3, 107, I18n.func_135052_a((String)"gui.xaero_world_teleport_command", (Object[])new Object[0])));
        this.connectButton = new MyBigButton(14, this.field_146294_l / 2 + 3, 132, this.getConfigButtonName(4));
        this.func_189646_b(this.connectButton);
        this.connectButton.field_146124_l = MinimapWorldContainerUtil.isMultiplayer(this.rootContainer.getPath()) && this.rootContainer == this.automaticMinimapWorld.getContainer().getRoot();
        this.func_189646_b(new MyBigButton(202, this.field_146294_l / 2 + 3, 182, this.getConfigButtonName(2)));
        this.func_189646_b(new MyBigButton(203, this.field_146294_l / 2 + 3, 207, this.getConfigButtonName(3)));
    }

    private String getConfigButtonName(int buttonId) {
        switch (buttonId) {
            case 0: {
                return I18n.func_135052_a((String)"gui.xaero_use_multiworld", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.getConfig().isUsingMultiworldDetection());
            }
            case 1: {
                return I18n.func_135052_a((String)"gui.xaero_teleportation", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.getConfig().isTeleportationEnabled());
            }
            case 2: {
                return I18n.func_135052_a((String)"gui.xaero_sort", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)this.rootContainer.getConfig().getSortType().optionName, (Object[])new Object[0]);
            }
            case 3: {
                return I18n.func_135052_a((String)"gui.xaero_sort_reversed", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.rootContainer.getConfig().isSortReversed());
            }
            case 4: {
                return this.selectedWorldIsConnected ? I18n.func_135052_a((String)"gui.xaero_disconnect_from_auto", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_connect_with_auto", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private void onConfigButtonClick(MyBigButton button) {
        this.buttonTest = true;
        MinimapWorldRootContainer wc = this.rootContainer;
        switch (button.getId() - 200) {
            case 0: {
                wc.getConfig().setUsingMultiworldDetection(!this.rootContainer.getConfig().isUsingMultiworldDetection());
                wc.getConfig().setDefaultMultiworldId(null);
                break;
            }
            case 1: {
                wc.getConfig().setTeleportationEnabled(!wc.getConfig().isTeleportationEnabled());
                break;
            }
            case 2: {
                this.rootContainer.getConfig().toggleSortType();
                this.parent.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
                break;
            }
            case 3: {
                this.rootContainer.getConfig().toggleSortReversed();
                this.parent.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            }
        }
        this.session.getWorldManagerIO().getRootConfigIO().save(wc);
        button.field_146126_j = this.getConfigButtonName(button.getId() - 200);
    }

    @Override
    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        this.buttonTest = false;
        super.func_73864_a(par1, par2, par3);
        if (this.handledMouseInput) {
            return;
        }
        if (!this.buttonTest) {
            this.goBack();
            this.handledMouseInput = true;
        }
    }

    @Override
    protected void func_146284_a(GuiButton p_146284_1_) {
        this.buttonTest = true;
        if (p_146284_1_.field_146124_l) {
            if (p_146284_1_.field_146127_k >= 200) {
                this.onConfigButtonClick((MyBigButton)p_146284_1_);
                return;
            }
            switch (p_146284_1_.field_146127_k) {
                case 5: {
                    this.goBack();
                    break;
                }
                case 6: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiTransfer(this.modMain, this.session, this.parent, this.escape));
                    break;
                }
                case 7: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_make_automatic_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_make_automatic_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 8: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_make_multi_automatic_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_make_multi_automatic_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 9: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_delete_world_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_delete_world_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 10: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_delete_multi_world_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_delete_multi_world_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 11: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_multiply_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_multiply_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 12: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_multiply_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_divide_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 13: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldTpCommand(this.modMain, (GuiScreen)this, this.escape, this.minimapWorld.getContainer().getRoot()));
                    break;
                }
                case 14: {
                    MinimapWorldContainer autoContainer = this.automaticMinimapWorld.getContainer();
                    MinimapWorldContainer selectedContainer = this.minimapWorld.getContainer();
                    String autoWorldName = autoContainer.getFullWorldName(this.automaticMinimapWorld.getNode(), autoContainer.getSubName()) + " (auto)";
                    String selectedWorldName = selectedContainer.getFullWorldName(this.minimapWorld.getNode(), selectedContainer.getSubName());
                    String connectionDisplayString = autoWorldName + "   \u00a7e<=>\u00a7r   " + selectedWorldName;
                    if (this.selectedWorldIsConnected) {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_disconnect_from_auto_msg", (Object[])new Object[0]), connectionDisplayString, p_146284_1_.field_146127_k));
                        break;
                    }
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_connect_with_auto_msg", (Object[])new Object[0]), connectionDisplayString, p_146284_1_.field_146127_k));
                }
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        block30: {
            block29: {
                boolean differentRoot = this.isDifferentRootContainer();
                boolean differentSub = this.isDifferentSubWorld(differentRoot);
                boolean exitOptions = true;
                if (!result) break block29;
                switch (id) {
                    case 7: {
                        if (!differentRoot) break;
                        MinimapWorldRootContainer selected = this.rootContainer;
                        MinimapWorldRootContainer auto = this.manager.getAutoRootContainer();
                        if (selected == null || auto == null) break;
                        XaeroPath buKey = selected.getPath();
                        this.manager.removeContainer(selected.getPath());
                        this.manager.removeContainer(auto.getPath());
                        selected.setPath(auto.getPath());
                        auto.setPath(buKey);
                        this.manager.addRootWorldContainer(selected);
                        this.manager.addRootWorldContainer(auto);
                        selected.updateConnectionsField(this.session.getWaypointSession());
                        auto.updateConnectionsField(this.session.getWaypointSession());
                        Path selectedPath = selected.getDirectoryPath();
                        Path autoPath = auto.getDirectoryPath();
                        Path tempFolder = this.modMain.getWaypointsFolder().resolve("temp_to_add");
                        try {
                            Files.createDirectories(tempFolder, new FileAttribute[0]);
                            Path selectedTemp = tempFolder.resolve(selectedPath.getFileName());
                            if (Files.exists(selectedPath, new LinkOption[0])) {
                                Files.move(selectedPath, selectedTemp, new CopyOption[0]);
                            }
                            if (Files.exists(autoPath, new LinkOption[0])) {
                                Files.move(autoPath, selectedPath, new CopyOption[0]);
                            }
                            if (Files.exists(selectedTemp, new LinkOption[0])) {
                                Files.move(selectedTemp, autoPath, new CopyOption[0]);
                            }
                            Files.deleteIfExists(tempFolder);
                            this.session.getWorldManagerIO().getRootConfigIO().load(selected);
                            this.session.getWorldManagerIO().getRootConfigIO().load(auto);
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                        }
                        this.session.getWorldState().setCustomWorldPath(null);
                        break;
                    }
                    case 8: {
                        if (!differentSub) break;
                        MinimapWorld autoWorld = this.automaticMinimapWorld;
                        MinimapWorld selectedWorld = this.minimapWorld;
                        try {
                            Path autoFile = this.session.getWorldManagerIO().getWorldFile(autoWorld);
                            Path selectedFile = this.session.getWorldManagerIO().getWorldFile(selectedWorld);
                            Path autoTempFile = autoFile.getParent().resolve("temp_to_add").resolve(autoFile.getFileName());
                            Files.createDirectories(autoTempFile.getParent(), new FileAttribute[0]);
                            if (!Files.exists(autoFile, new LinkOption[0])) {
                                Files.createFile(autoFile, new FileAttribute[0]);
                            }
                            Files.move(autoFile, autoTempFile, new CopyOption[0]);
                            if (!Files.exists(selectedFile, new LinkOption[0])) {
                                Files.createFile(selectedFile, new FileAttribute[0]);
                            }
                            Files.move(selectedFile, autoFile, new CopyOption[0]);
                            if (Files.exists(autoTempFile, new LinkOption[0])) {
                                Files.move(autoTempFile, selectedFile, new CopyOption[0]);
                            }
                            Files.deleteIfExists(autoTempFile.getParent());
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                            break;
                        }
                        MinimapWorldContainer autoWc = autoWorld.getContainer();
                        MinimapWorldContainer selectedWc = selectedWorld.getContainer();
                        autoWorld.setContainer(selectedWc);
                        selectedWorld.setContainer(autoWc);
                        selectedWc.removeWorld(selectedWorld.getNode());
                        autoWc.removeWorld(autoWorld.getNode());
                        String buSelected = selectedWorld.getNode();
                        selectedWorld.setNode(autoWorld.getNode());
                        autoWorld.setNode(buSelected);
                        selectedWc.addWorld(autoWorld);
                        autoWc.addWorld(selectedWorld);
                        int buDimId = selectedWorld.getDimId();
                        selectedWorld.setDimId(autoWorld.getDimId());
                        autoWorld.setDimId(buDimId);
                        this.rootContainer.getSubWorldConnections().swapConnections(autoWorld, selectedWorld);
                        this.session.getWorldManagerIO().getRootConfigIO().save(this.rootContainer);
                        this.session.getWorldState().setCustomWorldPath(null);
                        break;
                    }
                    case 9: {
                        if (!differentRoot) break;
                        XaeroPath selectedRootContainerId = this.rootContainer.getPath();
                        try {
                            File directory = selectedRootContainerId.applyToFilePath(this.modMain.getWaypointsFolder()).toFile();
                            if (directory.exists()) {
                                FileUtils.deleteDirectory((File)directory);
                            }
                        }
                        catch (Throwable e) {
                            this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(e);
                            break;
                        }
                        this.manager.removeContainer(selectedRootContainerId);
                        this.session.getWorldState().setCustomWorldPath(null);
                        break;
                    }
                    case 10: {
                        if (!differentSub) break;
                        MinimapWorld selectedWorld = this.minimapWorld;
                        try {
                            Files.deleteIfExists(this.session.getWorldManagerIO().getWorldFile(selectedWorld));
                        }
                        catch (IOException e) {
                            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                        }
                        selectedWorld.getContainer().removeWorld(selectedWorld.getNode());
                        selectedWorld.getContainer().removeName(selectedWorld.getNode());
                        this.session.getWorldState().setCustomWorldPath(null);
                        break;
                    }
                    case 11: {
                        this.multiplyWaypoints(this.minimapWorld, 8.0);
                        break;
                    }
                    case 12: {
                        this.multiplyWaypoints(this.minimapWorld, 0.125);
                        break;
                    }
                    case 14: {
                        if (!this.selectedWorldIsConnected) {
                            this.rootContainer.getSubWorldConnections().addConnection(this.automaticMinimapWorld, this.minimapWorld);
                        } else {
                            this.rootContainer.getSubWorldConnections().removeConnection(this.automaticMinimapWorld, this.minimapWorld);
                        }
                        this.session.getWorldManagerIO().getRootConfigIO().save(this.rootContainer);
                    }
                }
                if (exitOptions) {
                    if (this.parent instanceof GuiWaypoints) {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiWaypoints((HudMod)this.modMain, this.session, ((GuiWaypoints)this.parent).parent, this.escape));
                    } else {
                        this.goBack();
                    }
                }
                break block30;
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    private void multiplyWaypoints(MinimapWorld world, double factor) {
        for (WaypointSet set : world.getIterableWaypointSets()) {
            for (Waypoint wp : set.getWaypoints()) {
                wp.setX((int)Math.floor((double)wp.getX() * factor));
                wp.setZ((int)Math.floor((double)wp.getZ() * factor));
            }
        }
        try {
            this.session.getWorldManagerIO().saveWorld(world);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    private boolean isDifferentRootContainer() {
        return this.session.getWorldState().getAutoRootContainerPath() != null && !this.session.getWorldState().getAutoRootContainerPath().equals(this.rootContainer.getPath());
    }

    private boolean isDifferentSubWorld(boolean differentRoot) {
        return !differentRoot && this.minimapWorld != this.automaticMinimapWorld;
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        this.automaticButton.field_146124_l = this.deleteButton.field_146124_l = this.isDifferentRootContainer();
        this.subAutomaticButton.field_146124_l = this.subDeleteButton.field_146124_l = this.isDifferentSubWorld(this.automaticButton.field_146124_l);
        this.parent.func_73863_a(0, 0, par3);
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton w = (GuiButton)this.field_146292_n.get(k);
            if (!(w instanceof MyBigButton)) continue;
            MyBigButton b = (MyBigButton)w;
            if (par1 < b.field_146128_h || par2 < b.field_146129_i || par1 >= b.field_146128_h + b.func_146117_b() || par2 >= b.field_146129_i + 20) continue;
            if (b.getId() >= 200) {
                switch (b.getId() - 200) {
                    case 0: {
                        this.mwTooltip.drawBox(par1, par2, this.field_146294_l, this.field_146295_m);
                        break;
                    }
                    case 1: {
                        this.teleportationTooltip.drawBox(par1, par2, this.field_146294_l, this.field_146295_m);
                    }
                }
                continue;
            }
            if (b.getId() != 14 || !b.field_146124_l) continue;
            this.connectionTooltip.drawBox(par1, par2, this.field_146294_l, this.field_146295_m);
        }
    }
}

