/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.util.function.BiFunction;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.ConfigSettingEntry;
import xaero.common.gui.GuiLightOverlay;
import xaero.common.gui.GuiMinimapSettings;
import xaero.common.gui.GuiSlimeSeed;
import xaero.common.gui.ISettingEntry;
import xaero.common.gui.ScreenSwitchSettingEntry;
import xaero.common.settings.ModOptions;
import xaero.hud.HudSession;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;

public class GuiMinimapOverlaysSettings
extends GuiMinimapSettings {
    public GuiMinimapOverlaysSettings(final IXaeroMinimap modMain, GuiScreen backScreen, GuiScreen escScreen) {
        super(modMain, (ITextComponent)new TextComponentTranslation("gui.xaero_overlay_settings", new Object[0]), backScreen, escScreen);
        ScreenSwitchSettingEntry lightOverlayEntry = new ScreenSwitchSettingEntry("gui.xaero_light_overlay", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiLightOverlay(modMain, current, escape);
            }
        }, null, true);
        ScreenSwitchSettingEntry slimeChunksMultiplayerEntry = null;
        final MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (modMain.getSettings().customSlimeSeedNeeded(HudSession.getCurrentSession())) {
            slimeChunksMultiplayerEntry = new ScreenSwitchSettingEntry("gui.xaero_slime_chunks", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

                @Override
                public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                    return new GuiSlimeSeed(modMain, minimapSession, current, escape);
                }
            }, null, true);
        }
        this.entries = new ISettingEntry[]{new ConfigSettingEntry(ModOptions.CHUNK_GRID), new ConfigSettingEntry(ModOptions.CHUNK_GRID_LINE_WIDTH), lightOverlayEntry, slimeChunksMultiplayerEntry == null ? new ConfigSettingEntry(ModOptions.SLIME_CHUNKS) : slimeChunksMultiplayerEntry};
    }
}

