/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.entry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.entry.CategorySettingsListEntryWidget;
import xaero.common.graphics.CursorBox;

public abstract class CategorySettingsListEntry
extends Gui {
    protected final int entryRelativeX;
    protected final int entryRelativeY;
    protected final int entryW;
    protected final int entryH;
    protected final int index;
    protected final GuiCategorySettings.SettingRowList rowList;
    protected final List<CategorySettingsListEntry> subEntries;
    protected final Supplier<CursorBox> tooltipSupplier;
    protected int focusedSubEntryIndex;

    public CategorySettingsListEntry(int entryX, int entryY, int entryW, int entryH, int index, GuiCategorySettings.SettingRowList rowList, Supplier<CursorBox> tooltipSupplier) {
        this.entryRelativeX = entryX;
        this.entryRelativeY = entryY;
        this.entryW = entryW;
        this.entryH = entryH;
        this.index = index;
        this.rowList = rowList;
        this.subEntries = new ArrayList<CategorySettingsListEntry>();
        this.focusedSubEntryIndex = -1;
        this.tooltipSupplier = tooltipSupplier;
    }

    public CategorySettingsListEntry onSelected() {
        if (!this.subEntries.isEmpty() && this.focusedSubEntryIndex >= 0) {
            CategorySettingsListEntry subEntry = this.subEntries.get(this.focusedSubEntryIndex);
            return subEntry.onSelected();
        }
        if (this.selectAction()) {
            if (!(this instanceof CategorySettingsListEntryWidget)) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
            this.rowList.updateEntries();
        }
        return this;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public boolean mouseClicked(GuiCategorySettings.SettingRowList.Entry entry, int relativeMouseX, int relativeMouseY, int i) {
        for (int subIndex = 0; subIndex < this.subEntries.size(); ++subIndex) {
            CategorySettingsListEntry subEntry = this.subEntries.get(subIndex);
            int subRelativeMouseX = relativeMouseX - subEntry.entryRelativeX;
            int subRelativeMouseY = relativeMouseY - subEntry.entryRelativeY;
            if (!subEntry.isHoveredOver(relativeMouseX, relativeMouseY)) continue;
            if (this.focusedSubEntryIndex != subIndex) {
                this.unfocusRecursively();
                this.focusedSubEntryIndex = subIndex;
            }
            if (!subEntry.mouseClicked(entry, subRelativeMouseX, subRelativeMouseY, subIndex)) {
                subEntry.confirmSelection();
            }
            return true;
        }
        return false;
    }

    public boolean mouseReleased(int relativeMouseX, int relativeMouseY, int i) {
        for (int subIndex = 0; subIndex < this.subEntries.size(); ++subIndex) {
            CategorySettingsListEntry subEntry = this.subEntries.get(subIndex);
            subEntry.mouseReleased(relativeMouseX, relativeMouseY, i);
        }
        return false;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public boolean mouseDragged(GuiCategorySettings.SettingRowList.Entry entry, int relativeMouseX, int relativeMouseY, int i, long timeSinceLastClick) {
        return false;
    }

    public CategorySettingsListEntry confirmSelection() {
        if (this.focusedSubEntryIndex >= 0) {
            return this.subEntries.get(this.focusedSubEntryIndex).confirmSelection();
        }
        return this.onSelected();
    }

    public boolean keyTyped(char c, int i, boolean isRoot) {
        if (isRoot && (i == 203 && this.moveFocus(-1) || i == 205 && this.moveFocus(1))) {
            return false;
        }
        if (!this.subEntries.isEmpty() && this.focusedSubEntryIndex >= 0) {
            CategorySettingsListEntry subEntry = this.subEntries.get(this.focusedSubEntryIndex);
            return subEntry.keyTyped(c, i, false);
        }
        return false;
    }

    public void tick() {
        if (!this.subEntries.isEmpty()) {
            for (CategorySettingsListEntry subEntry : this.subEntries) {
                subEntry.tick();
            }
        }
    }

    public Supplier<CursorBox> getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    public abstract String getMessage();

    public void preRender(boolean includesSelected, boolean isRoot) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.entryRelativeX, (float)this.entryRelativeY, (float)0.0f);
        if (includesSelected && this.focusedSubEntryIndex == -1) {
            CategorySettingsListEntry.func_73734_a((int)0, (int)0, (int)this.entryW, (int)this.entryH, (int)-1);
            CategorySettingsListEntry.func_73734_a((int)1, (int)1, (int)(this.entryW - 1), (int)(this.entryH - 1), (int)-16777216);
        }
    }

    public CategorySettingsListEntry render(int index, int rowWidth, int rowHeight, int relativeMouseX, int relativeMouseY, boolean isMouseOver, float partialTicks, FontRenderer font, int globalMouseX, int globalMouseY, boolean includesSelected, boolean isRoot) {
        CategorySettingsListEntry result = isMouseOver ? this : null;
        for (int i = 0; i < this.subEntries.size(); ++i) {
            CategorySettingsListEntry subEntry = this.subEntries.get(i);
            boolean subIsHovered = subEntry.isHoveredOver(relativeMouseX, relativeMouseY);
            boolean subIncludesSelected = includesSelected && this.focusedSubEntryIndex == i;
            subEntry.preRender(subIncludesSelected, false);
            CategorySettingsListEntry subResult = subEntry.render(index, rowWidth, rowHeight, relativeMouseX - subEntry.entryRelativeX, relativeMouseY - subEntry.entryRelativeY, subIsHovered, partialTicks, font, globalMouseX, globalMouseY, subIncludesSelected, false);
            subEntry.postRender();
            if (!subIsHovered) continue;
            result = subResult;
        }
        return result;
    }

    public void postRender() {
        GlStateManager.func_179121_F();
    }

    public boolean isHoveredOver(double relativeMouseX, double relativeMouseY) {
        return relativeMouseX >= (double)this.entryRelativeX && relativeMouseX < (double)(this.entryRelativeX + this.entryW) && relativeMouseY >= (double)this.entryRelativeY && relativeMouseY < (double)(this.entryRelativeY + this.entryH);
    }

    protected abstract boolean selectAction();

    public void setFocused(boolean bl) {
    }

    public boolean moveFocus(int direction) {
        return this.moveFocus(direction, true);
    }

    public boolean moveFocus(int direction, boolean isRoot) {
        if (!this.subEntries.isEmpty()) {
            CategorySettingsListEntry focusedSub = null;
            boolean shouldSwitchLocal = true;
            if (this.focusedSubEntryIndex >= 0) {
                focusedSub = this.subEntries.get(this.focusedSubEntryIndex);
                boolean bl = shouldSwitchLocal = !focusedSub.moveFocus(direction, false);
            }
            if (shouldSwitchLocal) {
                int potentialValue = this.focusedSubEntryIndex + direction;
                if (potentialValue < 0 || potentialValue >= this.subEntries.size()) {
                    if (!isRoot) {
                        return false;
                    }
                    potentialValue = potentialValue < 0 ? this.subEntries.size() - 1 : 0;
                }
                if (this.focusedSubEntryIndex == potentialValue) {
                    return false;
                }
                this.focusedSubEntryIndex = potentialValue;
                focusedSub = this.subEntries.get(this.focusedSubEntryIndex);
                if (direction < 0) {
                    focusedSub.focusLastRecursively();
                } else {
                    focusedSub.focusFirstRecursively();
                }
            }
            return true;
        }
        return false;
    }

    public void unfocusRecursively() {
        this.setFocused(false);
        if (!this.subEntries.isEmpty()) {
            if (this.focusedSubEntryIndex >= 0) {
                this.subEntries.get(this.focusedSubEntryIndex).unfocusRecursively();
            }
            this.focusedSubEntryIndex = -1;
        }
    }

    public void focusFirstRecursively() {
        this.setFocused(true);
        if (!this.subEntries.isEmpty()) {
            this.focusedSubEntryIndex = 0;
            this.subEntries.get(this.focusedSubEntryIndex).focusFirstRecursively();
        }
    }

    public void focusLastRecursively() {
        this.setFocused(true);
        if (!this.subEntries.isEmpty()) {
            this.focusedSubEntryIndex = this.subEntries.size() - 1;
            this.subEntries.get(this.focusedSubEntryIndex).focusLastRecursively();
        }
    }

    public CategorySettingsListEntry withSubEntry(CategorySettingsListEntry entry) {
        this.subEntries.add(entry);
        return this;
    }

    public int getEntryRelativeX() {
        return this.entryRelativeX;
    }

    public int getEntryRelativeY() {
        return this.entryRelativeY;
    }
}

