/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data.rule;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import xaero.common.category.rule.ObjectCategoryListRuleType;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.GuiCategoryUIEditorSimpleDeletableWrapperData;
import xaero.common.category.ui.data.GuiCategoryUIEditorSimpleWrapperData;
import xaero.common.category.ui.data.options.text.GuiCategoryUIEditorTextFieldOptionsData;
import xaero.common.category.ui.entry.CategorySettingsListEntry;
import xaero.common.category.ui.entry.CategorySettingsListEntryWidget;
import xaero.common.category.ui.entry.CategorySettingsListEntryWrapper;
import xaero.common.category.ui.entry.CategorySettingsListMainEntry;
import xaero.common.category.ui.entry.CategorySettingsListMainEntryFactory;
import xaero.common.category.ui.entry.ConnectionLineType;
import xaero.common.category.ui.entry.widget.CategorySettingsButton;
import xaero.common.graphics.CursorBox;
import xaero.common.misc.ListFactory;

abstract class GuiCategoryUIEditorListData
extends GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> {
    protected final List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> list;
    private final GuiCategoryUIEditorTextFieldOptionsData topAdder;
    private final GuiCategoryUIEditorTextFieldOptionsData bottomAdder;
    private final ListFactory listFactory;
    private final GuiCategoryUIEditorSimpleDeletableWrapperData.DeletionCallback deletionCallback;
    private final BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>> helpTooltipSupplier;

    protected GuiCategoryUIEditorListData(@Nonnull List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> list, @Nonnull ListFactory listFactory, @Nonnull GuiCategoryUIEditorTextFieldOptionsData topAdder, @Nonnull GuiCategoryUIEditorTextFieldOptionsData bottomAdder, boolean movable, @Nonnull CategorySettingsListMainEntryFactory listEntryFactory, BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>> tooltipSupplier, @Nonnull GuiCategoryUIEditorSimpleDeletableWrapperData.DeletionCallback deletionCallback, @Nonnull BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>> helpTooltipSupplier) {
        super(movable, listEntryFactory, tooltipSupplier);
        this.list = list;
        this.listFactory = listFactory;
        this.topAdder = topAdder;
        this.bottomAdder = bottomAdder;
        this.deletionCallback = deletionCallback;
        this.helpTooltipSupplier = helpTooltipSupplier;
    }

    public List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> getList() {
        return this.list;
    }

    public GuiCategoryUIEditorSimpleDeletableWrapperData.DeletionCallback getDeletionCallback() {
        return this.deletionCallback;
    }

    private Consumer<GuiCategoryUIEditorTextFieldOptionsData> getAdderHandler() {
        return new Consumer<GuiCategoryUIEditorTextFieldOptionsData>(){

            @Override
            public void accept(GuiCategoryUIEditorTextFieldOptionsData adder) {
                String adderRequest = adder.getResult();
                if (!adderRequest.isEmpty()) {
                    GuiCategoryUIEditorSimpleWrapperData element = ((GuiCategoryUIEditorSimpleDeletableWrapperData.Builder)GuiCategoryUIEditorSimpleDeletableWrapperData.Builder.getDefault().setElement(adderRequest)).setDeletionCallback(GuiCategoryUIEditorListData.this.getDeletionCallback()).build();
                    int sortedIndex = Collections.binarySearch(GuiCategoryUIEditorListData.this.list, element);
                    if (sortedIndex < 0) {
                        GuiCategoryUIEditorListData.this.list.add(sortedIndex ^= 0xFFFFFFFF, (GuiCategoryUIEditorSimpleDeletableWrapperData<String>)element);
                    }
                    adder.resetInput("");
                }
            }
        };
    }

    @Override
    public List<GuiCategoryUIEditorExpandableData<?>> getSubExpandables() {
        Consumer<GuiCategoryUIEditorTextFieldOptionsData> adderHandler = this.getAdderHandler();
        adderHandler.accept(this.topAdder);
        adderHandler.accept(this.bottomAdder);
        List<GuiCategoryUIEditorExpandableData<?>> result = this.listFactory.get();
        if (this.list.size() > 0) {
            result.add(this.topAdder);
        }
        result.addAll(this.list);
        result.add(this.bottomAdder);
        return result;
    }

    public static abstract class Builder<E, P, ED extends GuiCategoryUIEditorListData, B extends Builder<E, P, ED, B>>
    extends GuiCategoryUIEditorExpandableData.Builder<GuiCategoryUIEditorExpandableData<?>, B> {
        private final B self = this;
        protected final List<GuiCategoryUIEditorSimpleDeletableWrapperData.Builder<String>> list;
        protected final GuiCategoryUIEditorTextFieldOptionsData.Builder adderBuilder;
        protected ListFactory listFactory;
        protected GuiCategoryUIEditorSimpleDeletableWrapperData.DeletionCallback deletionCallback;
        private Predicate<String> inputRuleTypeStringValidator;
        protected BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>> helpTooltipSupplier;
        private ObjectCategoryListRuleType<E, P, ?> defaultListRuleType;
        private Iterable<ObjectCategoryListRuleType<E, P, ?>> listRuleTypes;
        private String listRuleTypePrefixSeparator;

        protected Builder(ListFactory listFactory) {
            this.list = listFactory.get();
            this.listFactory = listFactory;
            this.adderBuilder = GuiCategoryUIEditorTextFieldOptionsData.Builder.getDefault(listFactory);
        }

        @Override
        public B setDefault() {
            super.setDefault();
            this.list.clear();
            this.setDeletionCallback(null);
            this.adderBuilder.setDefault().setAllowCustomInput(false).setAutoConfirm(false).setDisplayName(I18n.func_135052_a((String)"gui.xaero_category_list_add", (Object[])new Object[0]));
            this.setDeletionCallback(new GuiCategoryUIEditorSimpleDeletableWrapperData.DeletionCallback(){

                @Override
                public boolean delete(GuiCategoryUIEditorExpandableData<?> parent, GuiCategoryUIEditorSimpleDeletableWrapperData<?> element, GuiCategorySettings.SettingRowList rowList) {
                    GuiCategoryUIEditorListData listData = (GuiCategoryUIEditorListData)parent;
                    if (listData.getList().remove(element)) {
                        rowList.restoreScrollAfterUpdate();
                        return true;
                    }
                    return false;
                }
            });
            this.setListEntryFactory(new CategorySettingsListMainEntryFactory(){

                @Override
                public CategorySettingsListMainEntry<?> get(final GuiCategoryUIEditorExpandableData<?> data, final GuiCategoryUIEditorExpandableData<?> parent, final int index, ConnectionLineType lineType, final GuiCategorySettings.SettingRowList rowList, int screenWidth, boolean isFinalExpanded) {
                    return new CategorySettingsListEntryWrapper(new CategorySettingsListMainEntry.CenteredEntryFactory(){

                        @Override
                        public CategorySettingsListEntry get(int x, int y, int width, int height, CategorySettingsListMainEntry<?> root) {
                            return new CategorySettingsListEntryWidget(x, y, width, height, index, rowList, root, new CategorySettingsButton(parent, new Supplier<String>(){

                                @Override
                                public String get() {
                                    return data.getDisplayName();
                                }
                            }, true, 216, 20, new CategorySettingsButton.PressAction(){

                                @Override
                                public void onPress(CategorySettingsButton b) {
                                    data.getExpandAction(rowList).run();
                                }
                            }, rowList), data.getTooltipSupplier(parent));
                        }
                    }, screenWidth, index, rowList, lineType, data, (Supplier<CursorBox>)((Supplier)((GuiCategoryUIEditorListData)data).helpTooltipSupplier.apply(parent, (GuiCategoryUIEditorListData)data)));
                }
            });
            this.setHelpTooltipSupplier(new BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>>(){

                @Override
                public Supplier<CursorBox> apply(GuiCategoryUIEditorExpandableData<?> parent, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> data) {
                    return null;
                }
            });
            this.setDefaultListRuleType(null);
            this.setListRuleTypes(null);
            this.setListRuleTypePrefixSeparator(null);
            this.setInputRuleTypeStringValidator(null);
            return this.self;
        }

        public List<GuiCategoryUIEditorSimpleDeletableWrapperData.Builder<String>> getList() {
            return this.list;
        }

        public B setDeletionCallback(GuiCategoryUIEditorSimpleDeletableWrapperData.DeletionCallback deletionCallback) {
            this.deletionCallback = deletionCallback;
            return this.self;
        }

        public GuiCategoryUIEditorTextFieldOptionsData.Builder getAdderBuilder() {
            return this.adderBuilder;
        }

        protected List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> buildList() {
            return this.list.stream().map(new Function<GuiCategoryUIEditorSimpleDeletableWrapperData.Builder<String>, GuiCategoryUIEditorSimpleDeletableWrapperData<String>>(){

                @Override
                public GuiCategoryUIEditorSimpleDeletableWrapperData<String> apply(GuiCategoryUIEditorSimpleDeletableWrapperData.Builder<String> builder) {
                    builder.setDeletionCallback(Builder.this.deletionCallback);
                    return builder.build();
                }
            }).sorted().collect(new Supplier<List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>>>(){

                @Override
                public List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> get() {
                    return Builder.this.listFactory.get();
                }
            }, new BiConsumer<List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>>, GuiCategoryUIEditorSimpleDeletableWrapperData<String>>(){

                @Override
                public void accept(List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> l, GuiCategoryUIEditorSimpleDeletableWrapperData<String> e) {
                    l.add(e);
                }
            }, new BiConsumer<List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>>, List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>>>(){

                @Override
                public void accept(List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> l1, List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> l2) {
                    l1.addAll(l2);
                }
            });
        }

        public B setInputRuleTypeStringValidator(Predicate<String> inputRuleTypeStringValidator) {
            this.inputRuleTypeStringValidator = inputRuleTypeStringValidator;
            return this.self;
        }

        public B setHelpTooltipSupplier(BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>> helpTooltipSupplier) {
            this.helpTooltipSupplier = helpTooltipSupplier;
            return this.self;
        }

        public B setDefaultListRuleType(ObjectCategoryListRuleType<E, P, ?> defaultListRuleType) {
            this.defaultListRuleType = defaultListRuleType;
            return this.self;
        }

        public B setListRuleTypes(Iterable<ObjectCategoryListRuleType<E, P, ?>> listRuleTypes) {
            this.listRuleTypes = listRuleTypes;
            return this.self;
        }

        public B setListRuleTypePrefixSeparator(String listRuleTypePrefixSeparator) {
            this.listRuleTypePrefixSeparator = listRuleTypePrefixSeparator;
            return this.self;
        }

        @Override
        public GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> build() {
            if (this.deletionCallback == null || this.helpTooltipSupplier == null || this.defaultListRuleType == null || this.listRuleTypes == null || this.listRuleTypePrefixSeparator == null) {
                throw new IllegalStateException("required fields not set!");
            }
            final String listRuleTypePrefixSeparator = this.listRuleTypePrefixSeparator;
            final Predicate<String> inputRuleTypeStringValidator = this.inputRuleTypeStringValidator;
            final Iterable<ObjectCategoryListRuleType<E, P, ?>> listRuleTypes = this.listRuleTypes;
            final Predicate<String> inputStringValidator = new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    for (ObjectCategoryListRuleType listRuleType : listRuleTypes) {
                        if (!listRuleType.getStringValidator().test(s)) continue;
                        return true;
                    }
                    return false;
                }
            };
            if (this.adderBuilder.needsInputStringValidator()) {
                this.adderBuilder.setInputStringValidator(new Predicate<String>(){

                    @Override
                    public boolean test(String s) {
                        int separatorIndex = s.indexOf(listRuleTypePrefixSeparator);
                        if (separatorIndex == -1) {
                            return inputStringValidator.test(s);
                        }
                        String listRuleTypeString = s.substring(0, separatorIndex);
                        if (inputRuleTypeStringValidator != null && !inputRuleTypeStringValidator.test(listRuleTypeString)) {
                            return false;
                        }
                        String elementString = s.substring(separatorIndex + 1);
                        return inputStringValidator.test(elementString);
                    }
                });
            }
            for (ObjectCategoryListRuleType<E, P, ?> listRuleType : listRuleTypes) {
                String prefix = listRuleType == this.defaultListRuleType ? "" : listRuleType.getId() + listRuleTypePrefixSeparator;
                this.addSuggestionsForListRuleType(listRuleType, prefix);
            }
            return super.build();
        }

        private <S> void addSuggestionsForListRuleType(final ObjectCategoryListRuleType<E, P, S> listRuleType, final String prefix) {
            listRuleType.getAllElementSupplier().get().forEach(new Consumer<S>(){

                @Override
                public void accept(S e) {
                    Builder.this.adderBuilder.addOptionBuilderFor(prefix + listRuleType.getSerializer().apply(e));
                }
            });
        }

        protected abstract ED buildInternally();
    }
}

