/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data.options.text;

import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionData;
import xaero.common.misc.ListFactory;

public final class TextFieldSuggestionsResolver {
    private ListFactory listFactory;

    private TextFieldSuggestionsResolver(@Nonnull ListFactory listFactory) {
        this.listFactory = listFactory;
    }

    public List<GuiCategoryUIEditorOptionData<String>> getSuggestions(String input, List<GuiCategoryUIEditorOptionData<String>> allOptions) {
        if (input.isEmpty()) {
            return this.listFactory.get();
        }
        final String lowerCaseInput = input.toLowerCase();
        List<GuiCategoryUIEditorOptionData<String>> result = allOptions.stream().filter(new Predicate<GuiCategoryUIEditorOptionData<String>>(){

            @Override
            public boolean test(GuiCategoryUIEditorOptionData<String> o) {
                return o.getValue() != null && o.getValue().toString().toLowerCase().contains(lowerCaseInput);
            }
        }).sorted(new Comparator<GuiCategoryUIEditorOptionData<String>>(){

            @Override
            public int compare(GuiCategoryUIEditorOptionData<String> o1, GuiCategoryUIEditorOptionData<String> o2) {
                boolean secondStarts;
                boolean firstStarts = o1.getValue().toString().toLowerCase().startsWith(lowerCaseInput);
                return firstStarts == (secondStarts = o2.getValue().toString().toLowerCase().startsWith(lowerCaseInput)) ? 0 : (firstStarts ? -1 : 1);
            }
        }).limit(100L).collect(new Supplier<List<GuiCategoryUIEditorOptionData<String>>>(){

            @Override
            public List<GuiCategoryUIEditorOptionData<String>> get() {
                return TextFieldSuggestionsResolver.this.listFactory.get();
            }
        }, new BiConsumer<List<GuiCategoryUIEditorOptionData<String>>, GuiCategoryUIEditorOptionData<String>>(){

            @Override
            public void accept(List<GuiCategoryUIEditorOptionData<String>> l, GuiCategoryUIEditorOptionData<String> e) {
                l.add(e);
            }
        }, new BiConsumer<List<GuiCategoryUIEditorOptionData<String>>, List<GuiCategoryUIEditorOptionData<String>>>(){

            @Override
            public void accept(List<GuiCategoryUIEditorOptionData<String>> l1, List<GuiCategoryUIEditorOptionData<String>> l2) {
                l1.addAll(l2);
            }
        });
        return result;
    }

    public static final class Builder {
        private final ListFactory listFactory;

        private Builder(ListFactory listFactory) {
            this.listFactory = listFactory;
        }

        public Builder setDefault() {
            return this;
        }

        public TextFieldSuggestionsResolver build() {
            if (this.listFactory == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return new TextFieldSuggestionsResolver(this.listFactory);
        }

        public static Builder getDefault(ListFactory listFactory) {
            return new Builder(listFactory).setDefault();
        }
    }
}

