/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import xaero.common.category.setting.ObjectCategorySetting;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.data.GuiCategoryUIEditorCategoryData;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionsData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorSimpleButtonData;
import xaero.common.category.ui.data.options.range.setting.IGuiCategoryUIEditorSettingData;
import xaero.common.category.ui.data.options.range.setting.IGuiCategoryUIEditorSettingDataBuilder;
import xaero.common.category.ui.data.options.text.GuiCategoryUIEditorTextFieldOptionsData;
import xaero.common.category.ui.entry.CategorySettingsListEntry;
import xaero.common.category.ui.entry.CategorySettingsListEntryWidget;
import xaero.common.category.ui.entry.CategorySettingsListEntryWrapper;
import xaero.common.category.ui.entry.CategorySettingsListMainEntry;
import xaero.common.category.ui.entry.CategorySettingsListMainEntryFactory;
import xaero.common.category.ui.entry.ConnectionLineType;
import xaero.common.category.ui.entry.widget.CategorySettingsButton;
import xaero.common.graphics.CursorBox;
import xaero.common.misc.ListFactory;
import xaero.common.misc.MapFactory;

public class GuiCategoryUIEditorSettingsData<SETTING_DATA extends GuiCategoryUIEditorOptionsData<?>>
extends GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> {
    private final Map<ObjectCategorySetting<?>, SETTING_DATA> settings;
    private final List<SETTING_DATA> settingList;
    private boolean toBeDeleted;
    private final GuiCategoryUIEditorSimpleButtonData deleteButton;
    private final GuiCategoryUIEditorSimpleButtonData protectionButton;
    private final GuiCategoryUIEditorTextFieldOptionsData nameOption;
    private final ListFactory listFactory;
    private final boolean rootSettings;
    private boolean protection;

    protected GuiCategoryUIEditorSettingsData(@Nonnull Map<ObjectCategorySetting<?>, SETTING_DATA> settings, @Nonnull List<SETTING_DATA> settingList, @Nonnull GuiCategoryUIEditorSimpleButtonData deleteButton, @Nonnull GuiCategoryUIEditorSimpleButtonData protectionButton, @Nonnull GuiCategoryUIEditorTextFieldOptionsData nameOption, @Nonnull ListFactory listFactory, boolean rootSettings, boolean movable, @Nonnull CategorySettingsListMainEntryFactory listEntryFactory, BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>> tooltipSupplier, boolean protection) {
        super(movable, listEntryFactory, tooltipSupplier);
        this.settings = settings;
        this.settingList = settingList;
        this.listFactory = listFactory;
        this.rootSettings = rootSettings;
        this.deleteButton = deleteButton;
        this.protectionButton = protectionButton;
        this.nameOption = nameOption;
        this.protection = protection;
    }

    public Map<ObjectCategorySetting<?>, SETTING_DATA> getSettings() {
        return this.settings;
    }

    public IGuiCategoryUIEditorSettingData<?> getSettingData(ObjectCategorySetting<?> setting) {
        return (IGuiCategoryUIEditorSettingData)this.settings.get(setting);
    }

    public boolean isRootSettings() {
        return this.rootSettings;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public void setToBeDeleted() {
        this.toBeDeleted = true;
    }

    public boolean getProtection() {
        return this.protection;
    }

    public void setProtected(boolean protection) {
        this.protection = protection;
    }

    @Override
    public List<GuiCategoryUIEditorExpandableData<?>> getSubExpandables() {
        List<GuiCategoryUIEditorExpandableData<?>> result = this.listFactory.get();
        result.addAll(this.settingList);
        if (!this.protection) {
            result.add(this.nameOption);
        }
        result.add(this.deleteButton);
        result.add(this.protectionButton);
        return result;
    }

    @Override
    public String getDisplayName() {
        return I18n.func_135052_a((String)"gui.xaero_category_settings", (Object[])new Object[0]);
    }

    public GuiCategoryUIEditorTextFieldOptionsData getNameOption() {
        return this.nameOption;
    }

    public static final class FinalBuilder
    extends Builder<GuiCategoryUIEditorSettingsData<?>, FinalBuilder> {
        protected FinalBuilder(MapFactory mapFactory, ListFactory listFactory, List<ObjectCategorySetting<?>> allSettings) {
            super(mapFactory, listFactory, allSettings);
        }

        @Override
        protected GuiCategoryUIEditorSettingsData<?> buildInternally(List<IGuiCategoryUIEditorSettingData<?>> builtSettingData, Map<ObjectCategorySetting<?>, IGuiCategoryUIEditorSettingData<?>> builtSettingsDataMap) {
            GuiCategoryUIEditorSettingsData result = new GuiCategoryUIEditorSettingsData(builtSettingsDataMap, builtSettingData, this.deleteButtonBuilder.build(), this.protectionButtonBuilder.build(), this.nameOptionBuilder.build(), this.listFactory, this.rootSettings, this.movable, this.listEntryFactory, this.tooltipSupplier, this.protection);
            return result;
        }
    }

    public static abstract class Builder<SD extends GuiCategoryUIEditorSettingsData<?>, SDB extends Builder<SD, SDB>>
    extends GuiCategoryUIEditorExpandableData.Builder<GuiCategoryUIEditorExpandableData<?>, Builder<SD, SDB>> {
        protected final SDB self = this;
        protected final Map<ObjectCategorySetting<?>, IGuiCategoryUIEditorSettingDataBuilder<?, ?>> settingMap;
        protected final List<IGuiCategoryUIEditorSettingDataBuilder<?, ?>> settingList;
        protected final GuiCategoryUIEditorSimpleButtonData.Builder deleteButtonBuilder;
        protected final GuiCategoryUIEditorSimpleButtonData.Builder protectionButtonBuilder;
        protected final GuiCategoryUIEditorTextFieldOptionsData.Builder nameOptionBuilder;
        protected final MapFactory mapFactory;
        protected final ListFactory listFactory;
        protected boolean rootSettings;
        protected boolean protection;

        protected Builder(MapFactory mapFactory, ListFactory listFactory, List<ObjectCategorySetting<?>> allSettings) {
            this.settingMap = mapFactory.get();
            this.settingList = listFactory.get();
            this.deleteButtonBuilder = GuiCategoryUIEditorSimpleButtonData.Builder.getDefault();
            this.protectionButtonBuilder = GuiCategoryUIEditorSimpleButtonData.Builder.getDefault();
            this.nameOptionBuilder = GuiCategoryUIEditorTextFieldOptionsData.Builder.getDefault(listFactory);
            this.mapFactory = mapFactory;
            this.listFactory = listFactory;
            for (ObjectCategorySetting<?> setting : allSettings) {
                this.addSetting(setting);
            }
        }

        private <V> void addSetting(ObjectCategorySetting<V> setting) {
            IGuiCategoryUIEditorSettingDataBuilder builder = setting.getSettingUIType().getSettingDataBuilderFactory().apply(this.listFactory).setSetting(setting);
            this.settingMap.put(setting, builder);
            this.settingList.add(builder);
        }

        @Override
        public SDB setDefault() {
            super.setDefault();
            for (IGuiCategoryUIEditorSettingDataBuilder<?, ?> builder : this.settingList) {
                builder.setSettingValue(null);
            }
            this.setRootSettings(false);
            this.setListEntryFactory(new CategorySettingsListMainEntryFactory(){

                @Override
                public CategorySettingsListMainEntry<?> get(final GuiCategoryUIEditorExpandableData<?> data, final GuiCategoryUIEditorExpandableData<?> parent, final int index, ConnectionLineType lineType, final GuiCategorySettings.SettingRowList rowList, int screenWidth, boolean isFinalExpanded) {
                    return new CategorySettingsListEntryWrapper(new CategorySettingsListMainEntry.CenteredEntryFactory(){

                        @Override
                        public CategorySettingsListEntry get(int x, int y, int width, int height, CategorySettingsListMainEntry<?> root) {
                            return new CategorySettingsListEntryWidget(x, y, width, height, index, rowList, root, new CategorySettingsButton(parent, new Supplier<String>(){

                                @Override
                                public String get() {
                                    return data.getDisplayName();
                                }
                            }, true, 216, 20, new CategorySettingsButton.PressAction(){

                                @Override
                                public void onPress(CategorySettingsButton b) {
                                    data.getExpandAction(rowList).run();
                                }
                            }, rowList), data.getTooltipSupplier(parent));
                        }
                    }, screenWidth, index, rowList, lineType, data);
                }
            });
            this.nameOptionBuilder.setDefault();
            this.deleteButtonBuilder.setDefault().setDisplayName(I18n.func_135052_a((String)"gui.xaero_category_delete", (Object[])new Object[0])).setCallback(new GuiCategoryUIEditorSimpleButtonData.ISimpleButtonCallback(){

                @Override
                public void onButtonPress(GuiCategoryUIEditorExpandableData<?> parent, GuiCategoryUIEditorSimpleButtonData bd, GuiCategorySettings.SettingRowList rl) {
                    final GuiCategoryUIEditorSettingsData settings = (GuiCategoryUIEditorSettingsData)parent;
                    final Minecraft mc = Minecraft.func_71410_x();
                    final GuiScreen configScreen = mc.field_71462_r;
                    mc.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                        public void func_73878_a(boolean result, int i) {
                            if (result) {
                                settings.setToBeDeleted();
                            }
                            mc.func_147108_a(configScreen);
                        }
                    }, I18n.func_135052_a((String)"gui.xaero_category_delete_confirm", (Object[])new Object[0]), "\u00a7c" + I18n.func_135052_a((String)settings.getNameOption().getResult(), (Object[])new Object[0]), 0));
                }
            }).setIsActiveSupplier(new GuiCategoryUIEditorSimpleButtonData.ISimpleButtonIsActiveSupplier(){

                @Override
                public boolean get(GuiCategoryUIEditorExpandableData<?> parent, GuiCategoryUIEditorSimpleButtonData data) {
                    return !((GuiCategoryUIEditorSettingsData)parent).getProtection();
                }
            });
            this.protectionButtonBuilder.setDefault().setDisplayName("").setCallback(new GuiCategoryUIEditorSimpleButtonData.ISimpleButtonCallback(){

                @Override
                public void onButtonPress(GuiCategoryUIEditorExpandableData<?> parent, GuiCategoryUIEditorSimpleButtonData bd, GuiCategorySettings.SettingRowList rl) {
                    final GuiCategoryUIEditorSettingsData settings = (GuiCategoryUIEditorSettingsData)parent;
                    boolean currentlyProtected = settings.getProtection();
                    final Minecraft mc = Minecraft.func_71410_x();
                    final GuiScreen configScreen = mc.field_71462_r;
                    mc.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                        public void func_73878_a(boolean result, int i) {
                            if (result) {
                                settings.setProtected(!settings.getProtection());
                            }
                            mc.func_147108_a(configScreen);
                        }
                    }, I18n.func_135052_a((String)(currentlyProtected ? "gui.xaero_category_disable_protection_confirm" : "gui.xaero_category_enable_protection_confirm"), (Object[])new Object[0]), (currentlyProtected ? "\u00a7c" : "\u00a7a") + I18n.func_135052_a((String)settings.getNameOption().getResult(), (Object[])new Object[0]), 0));
                }
            }).setMessageSupplier(new GuiCategoryUIEditorSimpleButtonData.ISimpleButtonMessageSupplier(){

                @Override
                public Supplier<String> get(final GuiCategoryUIEditorExpandableData<?> parent, GuiCategoryUIEditorSimpleButtonData bd) {
                    return new Supplier<String>(){

                        @Override
                        public String get() {
                            return ((GuiCategoryUIEditorSettingsData)parent).getProtection() ? I18n.func_135052_a((String)"gui.xaero_category_disable_protection", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_category_enable_protection", (Object[])new Object[0]);
                        }
                    };
                }
            }).setIsActiveSupplier(new GuiCategoryUIEditorSimpleButtonData.ISimpleButtonIsActiveSupplier(){

                @Override
                public boolean get(GuiCategoryUIEditorExpandableData<?> parent, GuiCategoryUIEditorSimpleButtonData bd) {
                    return !((GuiCategoryUIEditorSettingsData)parent).isRootSettings();
                }
            }).setTooltipSupplier(new BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>>(){

                @Override
                public Supplier<CursorBox> apply(GuiCategoryUIEditorExpandableData<?> parent, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> bd) {
                    final CursorBox protectionTooltip = new CursorBox(I18n.func_135052_a((String)"gui.xaero_box_category_protection", (Object[])new Object[0]));
                    return new Supplier<CursorBox>(){

                        @Override
                        public CursorBox get() {
                            return protectionTooltip;
                        }
                    };
                }
            });
            this.setTooltipSupplier(new BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>>(){

                @Override
                public Supplier<CursorBox> apply(GuiCategoryUIEditorExpandableData<?> parent, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> data) {
                    if (parent instanceof GuiCategoryUIEditorCategoryData) {
                        GuiCategoryUIEditorCategoryData category = (GuiCategoryUIEditorCategoryData)parent;
                        final CursorBox tooltip = new CursorBox(I18n.func_135052_a((String)"gui.xaero_box_category_settings", (Object[])new Object[]{I18n.func_135052_a((String)category.getDisplayName(), (Object[])new Object[0])}));
                        tooltip.setAutoLinebreak(false);
                        return new Supplier<CursorBox>(){

                            @Override
                            public CursorBox get() {
                                return tooltip;
                            }
                        };
                    }
                    return null;
                }
            });
            return this.self;
        }

        public <T> SDB setSettingValue(ObjectCategorySetting<T> setting, T value) {
            IGuiCategoryUIEditorSettingDataBuilder<?, ?> settingBuilder = this.settingMap.get(setting);
            settingBuilder.setSettingValue(value);
            return this.self;
        }

        public SDB setRootSettings(boolean rootSettings) {
            this.rootSettings = rootSettings;
            return this.self;
        }

        public SDB setProtection(boolean protection) {
            this.protection = protection;
            return this.self;
        }

        public GuiCategoryUIEditorTextFieldOptionsData.Builder getNameOptionBuilder() {
            return this.nameOptionBuilder;
        }

        public GuiCategoryUIEditorSimpleButtonData.Builder getDeleteButtonBuilder() {
            return this.deleteButtonBuilder;
        }

        @Override
        protected GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> buildInternally() {
            if (this.nameOptionBuilder.needsInputStringValidator()) {
                this.nameOptionBuilder.setInputStringValidator(new Predicate<String>(){

                    @Override
                    public boolean test(String s) {
                        return true;
                    }
                });
            }
            List builtSettingData = (List)this.settingList.stream().map(new Function<IGuiCategoryUIEditorSettingDataBuilder<?, ?>, IGuiCategoryUIEditorSettingData<?>>(){

                @Override
                public IGuiCategoryUIEditorSettingData<?> apply(IGuiCategoryUIEditorSettingDataBuilder<?, ?> b) {
                    return (IGuiCategoryUIEditorSettingData)b.setRootSettings(Builder.this.rootSettings).build();
                }
            }).collect(new Supplier<List<IGuiCategoryUIEditorSettingData<?>>>(){

                @Override
                public List<IGuiCategoryUIEditorSettingData<?>> get() {
                    return Builder.this.listFactory.get();
                }
            }, new BiConsumer<List<IGuiCategoryUIEditorSettingData<?>>, IGuiCategoryUIEditorSettingData<?>>(){

                @Override
                public void accept(List<IGuiCategoryUIEditorSettingData<?>> l, IGuiCategoryUIEditorSettingData<?> e) {
                    l.add(e);
                }
            }, new BiConsumer<List<IGuiCategoryUIEditorSettingData<?>>, List<IGuiCategoryUIEditorSettingData<?>>>(){

                @Override
                public void accept(List<IGuiCategoryUIEditorSettingData<?>> l1, List<IGuiCategoryUIEditorSettingData<?>> l2) {
                    l1.addAll(l2);
                }
            });
            Map<ObjectCategorySetting<?>, IGuiCategoryUIEditorSettingData<?>> builtSettingsDataMap = this.mapFactory.get();
            for (IGuiCategoryUIEditorSettingData sd : builtSettingData) {
                if (!(sd instanceof GuiCategoryUIEditorOptionsData)) {
                    throw new IllegalStateException("illegal setting data class! " + sd.getClass());
                }
                builtSettingsDataMap.put(sd.getSetting(), sd);
            }
            return this.buildInternally(builtSettingData, builtSettingsDataMap);
        }

        protected abstract SD buildInternally(List<IGuiCategoryUIEditorSettingData<?>> var1, Map<ObjectCategorySetting<?>, IGuiCategoryUIEditorSettingData<?>> var2);
    }
}

