/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.experimental.lighting;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.experimental.lighting.IColoredLightSource;
import vazkii.quark.experimental.lighting.LightSource;

public final class ColoredLightSystem {
    private static final List<LightSource> lightSources = new ArrayList<LightSource>();
    private static List<LightSource> currentSources = new ArrayList<LightSource>();
    private static int lastFrame;

    public static void tick(Minecraft mc) {
        ForgeModContainer.forgeLightPipelineEnabled = false;
        mc.field_71474_y.field_74348_k = 0;
        WorldClient world = mc.field_71441_e;
        if (world == null) {
            lightSources.clear();
            currentSources.clear();
        }
        ArrayList<LightSource> tempList = new ArrayList<LightSource>(lightSources);
        tempList.removeIf(arg_0 -> ColoredLightSystem.lambda$tick$0((World)world, arg_0));
        currentSources = tempList;
    }

    public static float[] getLightColor(IBlockAccess world, BlockPos pos) {
        float maxBrightness = 0.0f;
        float addB = 0.0f;
        float addG = 0.0f;
        float addR = 0.0f;
        int time = ClientTicker.ticksInGame;
        if (time != lastFrame) {
            ColoredLightSystem.prepareFrame();
        }
        lastFrame = time;
        for (LightSource src : currentSources) {
            BlockPos srcPos = src.pos;
            IBlockState srcState = world.func_180495_p(srcPos);
            Block srcBlock = srcState.func_177230_c();
            if (!(srcBlock instanceof IColoredLightSource)) continue;
            int srcLight = srcState.getLightValue(world, srcPos);
            float brightness = (float)srcLight / 15.0f;
            int incidence = src.getIncidence(pos);
            if (incidence <= 0) continue;
            float incidenceF = (float)incidence / 15.0f;
            float localBrightness = brightness * incidenceF;
            float[] colors = ((IColoredLightSource)srcBlock).getColoredLight(world, srcPos);
            if (colors.length != 3) {
                colors = new float[]{1.0f, 1.0f, 1.0f};
            }
            maxBrightness = Math.max(maxBrightness, localBrightness);
            addR += colors[0] * localBrightness;
            addG += colors[1] * localBrightness;
            addB += colors[2] * localBrightness;
        }
        float strongestColor = Math.max(addR, Math.max(addG, addB));
        if (maxBrightness > 0.0f && strongestColor > 0.0f) {
            float lower = 1.0f - maxBrightness;
            addR /= strongestColor;
            addG /= strongestColor;
            addB /= strongestColor;
            addR = MathHelper.func_76131_a((float)addR, (float)lower, (float)1.0f);
            addG = MathHelper.func_76131_a((float)addG, (float)lower, (float)1.0f);
            addB = MathHelper.func_76131_a((float)addB, (float)lower, (float)1.0f);
            return new float[]{addR, addG, addB};
        }
        return new float[0];
    }

    private static void prepareFrame() {
        for (LightSource src : currentSources) {
            src.newFrame();
        }
    }

    public static void addLightSource(IBlockAccess access, BlockPos pos, IBlockState state) {
        if (!(access instanceof World)) {
            return;
        }
        World world = (World)access;
        ListIterator<LightSource> iterator = lightSources.listIterator();
        while (iterator.hasNext()) {
            LightSource src = iterator.next();
            if (!src.pos.equals((Object)pos)) continue;
            if (!src.isValid(world)) {
                iterator.remove();
                continue;
            }
            return;
        }
        int brightness = state.func_177230_c().getLightValue(state, access, pos);
        lightSources.add(new LightSource(world, pos, state, brightness));
    }

    private static /* synthetic */ boolean lambda$tick$0(World world, LightSource src) {
        return src == null || !src.isValid(world);
    }
}

