/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.util;

public class ExpCalculator {
    private static int LEVEL15EXP = 255;
    private static int LEVEL30EXP = 825;

    private static float area15to30(int x) {
        return 3.0f * (float)x * (float)x / 2.0f + (float)(17 * x);
    }

    private static int value15to30(int x) {
        return 3 * x + 17;
    }

    private static float area30plus(int x) {
        return 7.0f * (float)x * (float)x / 2.0f + (float)(62 * x);
    }

    private static int value30plus(int x) {
        return 7 * x + 62;
    }

    private static int xpBarCap(int xpLevel) {
        return xpLevel >= 30 ? 62 + (xpLevel - 30) * 7 : (xpLevel >= 15 ? 17 + (xpLevel - 15) * 3 : 17);
    }

    private static int additionalExp(int expLevel, float xpBar) {
        return (int)((float)ExpCalculator.xpBarCap(expLevel) * xpBar);
    }

    public static int getExp(int expLevel, float expBar) {
        if (expLevel <= 15) {
            return 17 * expLevel + ExpCalculator.additionalExp(expLevel, expBar);
        }
        if (expLevel <= 30) {
            int diff = expLevel - 15;
            return (int)((double)(ExpCalculator.area15to30(diff) - ExpCalculator.area15to30(0)) - (double)((float)ExpCalculator.value15to30(diff) - (float)ExpCalculator.value15to30(0)) / 2.0 + 255.0 + (double)ExpCalculator.additionalExp(expLevel, expBar));
        }
        int diff = expLevel - 30;
        return (int)((double)(ExpCalculator.area30plus(diff) - ExpCalculator.area30plus(0)) - (double)((float)ExpCalculator.value30plus(diff) - (float)ExpCalculator.value30plus(0)) / 2.0 + 825.0 + (double)ExpCalculator.additionalExp(expLevel, expBar));
    }
}

