/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.configuration;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import portablejim.veinminer.configuration.json.ToolStruct;
import portablejim.veinminer.util.BlockID;

public class Tool {
    public String name;
    public String icon;
    public Set<String> toollist;
    public Set<BlockID> blocklist;

    public Tool(String name, String icon, String[] toollist, String[] blocklist) {
        this.name = name;
        this.icon = icon;
        this.toollist = new HashSet<String>(toollist.length);
        this.blocklist = new HashSet<BlockID>(blocklist.length);
        Collections.addAll(this.toollist, toollist);
        for (String block : blocklist) {
            this.blocklist.add(new BlockID(block));
        }
    }

    public Tool(ToolStruct baseTool) {
        this.name = baseTool.name;
        this.icon = baseTool.icon;
        this.toollist = new HashSet<String>();
        Collections.addAll(this.toollist, baseTool.toollist);
        this.blocklist = new HashSet<BlockID>();
        for (String block : baseTool.blocklist) {
            this.blocklist.add(new BlockID(block));
        }
    }

    public Tool addTool(String tool) {
        this.toollist.add(tool);
        return this;
    }

    public Tool removeTool(String tool) {
        this.toollist.remove(tool);
        return this;
    }

    public Tool addBlock(BlockID block) {
        this.blocklist.add(block);
        return this;
    }

    public Tool removeBlock(BlockID block) {
        this.blocklist.remove(block);
        return this;
    }
}

