/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.item;

import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.StackUtil;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGateCopier
extends ItemBC_Neptune {
    private static final String NBT_DATA = "gate_data";

    public ItemGateCopier(String id) {
        super(id);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void addModelVariants(TIntObjectHashMap<ModelResourceLocation> variants) {
        this.addVariant(variants, 0, "empty");
        this.addVariant(variants, 1, "full");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (this.getMetadata(stack) != 0) {
            tooltip.add(LocaleUtil.localize((String)"buildcraft.item.nonclean.usage"));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af()) {
            return this.clearData((ItemStack)StackUtil.asNonNull((Object)stack));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private ActionResult<ItemStack> clearData(@Nonnull ItemStack stack) {
        if (this.getMetadata(stack) == 0) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        NBTTagCompound nbt = NBTUtilBC.getItemData((ItemStack)stack);
        nbt.func_82580_o(NBT_DATA);
        if (nbt.func_82582_d()) {
            stack.func_77982_d(null);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public int getMetadata(ItemStack stack) {
        return ItemGateCopier.getCopiedGateData(stack) != null ? 1 : 0;
    }

    public static NBTTagCompound getCopiedGateData(ItemStack stack) {
        return stack.func_179543_a(NBT_DATA);
    }

    public static void setCopiedGateData(ItemStack stack, NBTTagCompound nbt) {
        NBTUtilBC.getItemData((ItemStack)stack).func_74782_a(NBT_DATA, (NBTBase)nbt);
    }
}

