/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gui;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.BCLibSprites;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.config.GuiConfigManager;
import buildcraft.lib.gui.ledger.Ledger_Neptune;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.silicon.tile.TileAssemblyTable;
import buildcraft.silicon.tile.TileLaserTableBase;
import net.minecraft.util.ResourceLocation;

public class LedgerTablePower
extends Ledger_Neptune {
    private static final int OVERLAY_COLOUR = -2855905;
    private static final int SUB_HEADER_COLOUR = -5591112;
    private static final int TEXT_COLOUR = -16777216;
    public final TileLaserTableBase tile;

    public LedgerTablePower(BuildCraftGui gui, TileAssemblyTable tile, boolean expandPositive) {
        super(gui, -2855905, expandPositive);
        this.tile = tile;
        this.title = "gui.power";
        this.appendText(LocaleUtil.localize((String)"gui.assemblyCurrentRequired") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeMj((long)tile.getTarget()), -16777216);
        this.appendText(LocaleUtil.localize((String)"gui.stored") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeMj((long)tile.power), -16777216);
        this.appendText(LocaleUtil.localize((String)"gui.assemblyRate") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeMjFlow((long)tile.avgPowerClient), -16777216);
        this.calculateMaxSize();
        this.setOpenProperty(GuiConfigManager.getOrAddBoolean((ResourceLocation)new ResourceLocation("buildcraftsilicon:all_tables"), (String)"ledger.power.is_open", (boolean)false));
    }

    protected void drawIcon(double x, double y) {
        ISprite sprite = this.tile.avgPowerClient > 0L ? BCLibSprites.ENGINE_ACTIVE : BCLibSprites.ENGINE_INACTIVE;
        GuiIcon.draw((ISprite)sprite, (double)x, (double)y, (double)(x + 16.0), (double)(y + 16.0));
    }
}

