/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.BCItems;
import buildcraft.api.core.BCLog;
import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.enums.EnumRedstoneChipset;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.recipes.AssemblyRecipeBasic;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.core.BCCoreBlocks;
import buildcraft.core.BCCoreConfig;
import buildcraft.core.BCCoreItems;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import buildcraft.lib.recipe.IngredientNBTBC;
import buildcraft.lib.recipe.RecipeBuilderShaped;
import buildcraft.silicon.BCSiliconItems;
import buildcraft.silicon.gate.EnumGateLogic;
import buildcraft.silicon.gate.EnumGateMaterial;
import buildcraft.silicon.gate.EnumGateModifier;
import buildcraft.silicon.gate.GateVariant;
import buildcraft.silicon.recipe.FacadeAssemblyRecipes;
import buildcraft.silicon.recipe.FacadeSwapRecipe;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="buildcraftsilicon")
public class BCSiliconRecipes {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ImmutableSet input;
        if (BCSiliconItems.plugGate != null) {
            RecipeBuilderShaped builder = new RecipeBuilderShaped();
            builder.add(" m ");
            builder.add("mrm");
            builder.add(" b ");
            builder.map('r', new Object[]{"dustRedstone"});
            builder.map('b', new Object[]{BCItems.Transport.PLUG_BLOCKER, Blocks.field_150347_e});
            builder.map('m', new Object[]{Items.field_151118_aC});
            BCSiliconRecipes.makeGateRecipe(builder, EnumGateMaterial.CLAY_BRICK, EnumGateModifier.NO_MODIFIER);
            builder.map('m', new Object[]{"ingotIron"});
            BCSiliconRecipes.makeGateRecipe(builder, EnumGateMaterial.IRON, EnumGateModifier.NO_MODIFIER);
            builder.map('m', new Object[]{Items.field_151130_bT});
            BCSiliconRecipes.makeGateRecipe(builder, EnumGateMaterial.NETHER_BRICK, EnumGateModifier.NO_MODIFIER);
            GateVariant variant = new GateVariant(EnumGateLogic.AND, EnumGateMaterial.IRON, EnumGateModifier.NO_MODIFIER);
            ItemStack ironGateBase = BCSiliconItems.plugGate.getStack(variant);
            builder = new RecipeBuilderShaped();
            builder.add(" m ");
            builder.add("mgm");
            builder.add(" m ");
            builder.map('g', new Object[]{ironGateBase});
            builder.map('m', new Object[]{new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b())});
            BCSiliconRecipes.makeGateRecipe(builder, EnumGateMaterial.IRON, EnumGateModifier.LAPIS);
            builder.map('m', new Object[]{Items.field_151128_bU});
            BCSiliconRecipes.makeGateRecipe(builder, EnumGateMaterial.IRON, EnumGateModifier.QUARTZ);
            for (EnumGateMaterial material : EnumGateMaterial.VALUES) {
                if (material == EnumGateMaterial.CLAY_BRICK) continue;
                for (EnumGateModifier modifier : EnumGateModifier.VALUES) {
                    GateVariant varAnd = new GateVariant(EnumGateLogic.AND, material, modifier);
                    ItemStack resultAnd = BCSiliconItems.plugGate.getStack(varAnd);
                    GateVariant varOr = new GateVariant(EnumGateLogic.OR, material, modifier);
                    ItemStack resultOr = BCSiliconItems.plugGate.getStack(varOr);
                    String regNamePrefix = resultOr.func_77973_b().getRegistryName() + "_" + (Object)((Object)modifier) + "_" + (Object)((Object)material);
                    ForgeRegistries.RECIPES.register(new ShapedOreRecipe(resultOr.func_77973_b().getRegistryName(), resultAnd, new Object[]{"i", Character.valueOf('i'), new IngredientNBTBC(resultOr)}).setRegistryName(regNamePrefix + "_or"));
                    ForgeRegistries.RECIPES.register(new ShapedOreRecipe(resultAnd.func_77973_b().getRegistryName(), resultOr, new Object[]{"i", Character.valueOf('i'), new IngredientNBTBC(resultAnd)}).setRegistryName(regNamePrefix + "_and"));
                }
            }
        }
        if (BCSiliconItems.plugPulsar != null) {
            ItemStack output = new ItemStack((Item)BCSiliconItems.plugPulsar);
            ItemStack redstoneEngine = BCCoreBlocks.engine != null ? BCCoreBlocks.engine.getStack((Enum)EnumEngineType.WOOD) : new ItemStack(Blocks.field_150451_bX);
            HashSet<IngredientStack> input2 = new HashSet<IngredientStack>();
            input2.add(new IngredientStack(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{redstoneEngine})));
            input2.add(new IngredientStack(CraftingHelper.getIngredient((Object)"ingotIron"), 2));
            AssemblyRecipeBasic recipe = new AssemblyRecipeBasic("plug_pulsar", 1000L * MjAPI.MJ, input2, output);
            AssemblyRecipeRegistry.register((AssemblyRecipe)recipe);
        }
        if (BCSiliconItems.plugGate != null) {
            EnumDyeColor[] lapis = IngredientStack.of((Object)"gemLapis");
            BCSiliconRecipes.makeGateAssembly(20000, EnumGateMaterial.IRON, EnumGateModifier.NO_MODIFIER, EnumRedstoneChipset.IRON, new IngredientStack[0]);
            BCSiliconRecipes.makeGateAssembly(40000, EnumGateMaterial.NETHER_BRICK, EnumGateModifier.NO_MODIFIER, EnumRedstoneChipset.IRON, IngredientStack.of((Object)new ItemStack(Blocks.field_150385_bj)));
            BCSiliconRecipes.makeGateAssembly(80000, EnumGateMaterial.GOLD, EnumGateModifier.NO_MODIFIER, EnumRedstoneChipset.GOLD, new IngredientStack[0]);
            BCSiliconRecipes.makeGateModifierAssembly(40000, EnumGateMaterial.IRON, EnumGateModifier.LAPIS, new IngredientStack[]{lapis});
            BCSiliconRecipes.makeGateModifierAssembly(60000, EnumGateMaterial.IRON, EnumGateModifier.QUARTZ, IngredientStack.of((Object)EnumRedstoneChipset.QUARTZ.getStack()));
            BCSiliconRecipes.makeGateModifierAssembly(80000, EnumGateMaterial.IRON, EnumGateModifier.DIAMOND, IngredientStack.of((Object)EnumRedstoneChipset.DIAMOND.getStack()));
            BCSiliconRecipes.makeGateModifierAssembly(80000, EnumGateMaterial.NETHER_BRICK, EnumGateModifier.LAPIS, new IngredientStack[]{lapis});
            BCSiliconRecipes.makeGateModifierAssembly(100000, EnumGateMaterial.NETHER_BRICK, EnumGateModifier.QUARTZ, IngredientStack.of((Object)EnumRedstoneChipset.QUARTZ.getStack()));
            BCSiliconRecipes.makeGateModifierAssembly(120000, EnumGateMaterial.NETHER_BRICK, EnumGateModifier.DIAMOND, IngredientStack.of((Object)EnumRedstoneChipset.DIAMOND.getStack()));
            BCSiliconRecipes.makeGateModifierAssembly(100000, EnumGateMaterial.GOLD, EnumGateModifier.LAPIS, new IngredientStack[]{lapis});
            BCSiliconRecipes.makeGateModifierAssembly(140000, EnumGateMaterial.GOLD, EnumGateModifier.QUARTZ, IngredientStack.of((Object)EnumRedstoneChipset.QUARTZ.getStack()));
            BCSiliconRecipes.makeGateModifierAssembly(180000, EnumGateMaterial.GOLD, EnumGateModifier.DIAMOND, IngredientStack.of((Object)EnumRedstoneChipset.DIAMOND.getStack()));
        }
        if (BCSiliconItems.plugLightSensor != null) {
            AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic("light-sensor", 500L * MjAPI.MJ, ImmutableSet.of((Object)IngredientStack.of((Object)Blocks.field_150453_bW)), new ItemStack((Item)BCSiliconItems.plugLightSensor)));
        }
        if (BCSiliconItems.plugFacade != null) {
            AssemblyRecipeRegistry.register((AssemblyRecipe)FacadeAssemblyRecipes.INSTANCE);
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)FacadeSwapRecipe.INSTANCE);
        }
        if (BCSiliconItems.plugLens != null) {
            for (EnumDyeColor colour : ColourUtil.COLOURS) {
                String name = String.format("lens-regular-%s", colour.func_176762_d());
                IngredientStack stainedGlass = IngredientStack.of((Object)("blockGlass" + ColourUtil.getName((EnumDyeColor)colour)));
                ImmutableSet input3 = ImmutableSet.of((Object)stainedGlass);
                ItemStack output = BCSiliconItems.plugLens.getStack(colour, false);
                AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic(name, 500L * MjAPI.MJ, input3, output));
                name = String.format("lens-filter-%s", colour.func_176762_d());
                output = BCSiliconItems.plugLens.getStack(colour, true);
                input3 = ImmutableSet.of((Object)stainedGlass, (Object)IngredientStack.of((Object)new ItemStack(Blocks.field_150411_aY)));
                AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic(name, 500L * MjAPI.MJ, input3, output));
            }
            IngredientStack glass = IngredientStack.of((Object)"blockGlass");
            ImmutableSet input4 = ImmutableSet.of((Object)glass);
            ItemStack output = BCSiliconItems.plugLens.getStack(null, false);
            AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic("lens-regular", 500L * MjAPI.MJ, input4, output));
            output = BCSiliconItems.plugLens.getStack(null, true);
            input4 = ImmutableSet.of((Object)glass, (Object)IngredientStack.of((Object)new ItemStack(Blocks.field_150411_aY)));
            AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic("lens-filter", 500L * MjAPI.MJ, input4, output));
        }
        if (BCSiliconItems.redstoneChipset != null) {
            input = ImmutableSet.of((Object)IngredientStack.of((Object)"dustRedstone"));
            ItemStack output = EnumRedstoneChipset.RED.getStack(1);
            AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic("redstone_chipset", 10000L * MjAPI.MJ, input, output));
            input = ImmutableSet.of((Object)IngredientStack.of((Object)"dustRedstone"), (Object)IngredientStack.of((Object)"ingotIron"));
            output = EnumRedstoneChipset.IRON.getStack(1);
            AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic("iron_chipset", 20000L * MjAPI.MJ, input, output));
            input = ImmutableSet.of((Object)IngredientStack.of((Object)"dustRedstone"), (Object)IngredientStack.of((Object)"ingotGold"));
            output = EnumRedstoneChipset.GOLD.getStack(1);
            AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic("gold_chipset", 40000L * MjAPI.MJ, input, output));
            input = ImmutableSet.of((Object)IngredientStack.of((Object)"dustRedstone"), (Object)IngredientStack.of((Object)"gemQuartz"));
            output = EnumRedstoneChipset.QUARTZ.getStack(1);
            AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic("quartz_chipset", 60000L * MjAPI.MJ, input, output));
            input = ImmutableSet.of((Object)IngredientStack.of((Object)"dustRedstone"), (Object)IngredientStack.of((Object)"gemDiamond"));
            output = EnumRedstoneChipset.DIAMOND.getStack(1);
            AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic("diamond_chipset", 80000L * MjAPI.MJ, input, output));
        }
        if (BCSiliconItems.gateCopier != null) {
            input = ImmutableSet.builder();
            if (BCCoreItems.wrench != null) {
                input.add((Object)IngredientStack.of((Object)BCCoreItems.wrench));
            } else {
                input.add((Object)IngredientStack.of((Object)Items.field_151055_y));
                input.add((Object)IngredientStack.of((Object)Items.field_151042_j));
            }
            if (BCSiliconItems.redstoneChipset != null) {
                input.add((Object)IngredientStack.of((Object)EnumRedstoneChipset.IRON.getStack(1)));
            } else {
                input.add((Object)IngredientStack.of((Object)"dustRedstone"));
                input.add((Object)IngredientStack.of((Object)"dustRedstone"));
                input.add((Object)IngredientStack.of((Object)"ingotGold"));
            }
            AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic("gate_copier", 500L * MjAPI.MJ, input.build(), new ItemStack((Item)BCSiliconItems.gateCopier)));
        }
        BCSiliconRecipes.scanForJsonRecipes();
    }

    private static void makeGateModifierAssembly(int multiplier, EnumGateMaterial material, EnumGateModifier modifier, IngredientStack ... mods) {
        for (EnumGateLogic logic : EnumGateLogic.VALUES) {
            String name = String.format("gate-modifier-%s-%s-%s", new Object[]{logic, material, modifier});
            GateVariant variantFrom = new GateVariant(logic, material, EnumGateModifier.NO_MODIFIER);
            ItemStack toUpgrade = BCSiliconItems.plugGate.getStack(variantFrom);
            ItemStack output = BCSiliconItems.plugGate.getStack(new GateVariant(logic, material, modifier));
            ImmutableSet.Builder inputBuilder = new ImmutableSet.Builder();
            inputBuilder.add((Object)new IngredientStack((Ingredient)new IngredientNBTBC(toUpgrade)));
            inputBuilder.add((Object[])mods);
            ImmutableSet input = inputBuilder.build();
            AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic(name, MjAPI.MJ * (long)multiplier, input, output));
        }
    }

    private static void makeGateAssembly(int multiplier, EnumGateMaterial material, EnumGateModifier modifier, EnumRedstoneChipset chipset, IngredientStack ... additional) {
        ImmutableSet.Builder temp = ImmutableSet.builder();
        temp.add((Object)new IngredientStack((Ingredient)new IngredientNBTBC(chipset.getStack())));
        temp.add((Object[])additional);
        ImmutableSet input = temp.build();
        String name = String.format("gate-and-%s-%s", new Object[]{material, modifier});
        ItemStack output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.AND, material, modifier));
        AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic(name, MjAPI.MJ * (long)multiplier, input, output));
        name = String.format("gate-or-%s-%s", new Object[]{material, modifier});
        output = BCSiliconItems.plugGate.getStack(new GateVariant(EnumGateLogic.OR, material, modifier));
        AssemblyRecipeRegistry.register((AssemblyRecipe)new AssemblyRecipeBasic(name, MjAPI.MJ * (long)multiplier, input, output));
    }

    private static void makeGateRecipe(RecipeBuilderShaped builder, EnumGateMaterial material, EnumGateModifier modifier) {
        GateVariant variant = new GateVariant(EnumGateLogic.AND, material, modifier);
        builder.setResult(BCSiliconItems.plugGate.getStack(variant));
        builder.registerNbtAware("buildcraftsilicon:plug_gate_create_" + (Object)((Object)material) + "_" + (Object)((Object)modifier));
    }

    private static void scanForJsonRecipes() {
        final boolean[] failed = new boolean[]{false};
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            JsonContext ctx = new JsonContext(mod.getModId());
            CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/assembly_recipes_pre_mj"), null, (root, file) -> {
                try {
                    BCSiliconRecipes.readAndAddJsonRecipe(ctx, root, file);
                    return true;
                }
                catch (IOException io) {
                    BCLog.logger.error("Couldn't read recipe " + root.relativize((Path)file) + " from " + file, (Throwable)io);
                    failed[0] = true;
                    return true;
                }
            }, (boolean)false, (boolean)false);
        }
        final Path configRoot = BCCoreConfig.configFolder.toPath().resolve("assembly_recipes_pre_mj");
        if (!Files.isDirectory(configRoot, new LinkOption[0])) {
            try {
                Files.createDirectory(configRoot, new FileAttribute[0]);
            }
            catch (IOException e) {
                BCLog.logger.warn("[silicon.assembly] Unable to create the folder " + configRoot);
                failed[0] = true;
                return;
            }
        }
        try {
            final JsonContext ctx = new JsonContext("_config");
            Files.walkFileTree(configRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        BCSiliconRecipes.readAndAddJsonRecipe(ctx, configRoot, file);
                    }
                    catch (JsonParseException e) {
                        e.printStackTrace();
                        failed[0] = true;
                    }
                    catch (IOException io) {
                        io.printStackTrace();
                        failed[0] = true;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            BCLog.logger.warn("[silicon.assembly] Failed to walk the config folder " + configRoot, (Throwable)e);
            failed[0] = false;
        }
        if (failed[0]) {
            throw new IllegalStateException("Failed to read some assembly recipe files! Check the log for details");
        }
    }

    private static void readAndAddJsonRecipe(JsonContext ctx, Path root, Path file) throws JsonParseException, IOException {
        if (!file.toString().endsWith(".json")) {
            return;
        }
        String name = root.relativize(file).toString().replace("\\", "/");
        ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
        try (BufferedReader reader = Files.newBufferedReader(file);){
            JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            if (json == null || json.isJsonNull()) {
                throw new JsonSyntaxException("Json is null (empty file?)");
            }
            ItemStack output = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("result"), (JsonContext)ctx);
            long powercost = json.get("MJ").getAsLong() * MjAPI.MJ;
            ArrayList ingredients = new ArrayList();
            json.getAsJsonArray("components").forEach(element -> {
                JsonObject object = element.getAsJsonObject();
                ingredients.add(new IngredientStack(CraftingHelper.getIngredient((JsonElement)object.get("ingredient"), (JsonContext)ctx), JsonUtils.func_151208_a((JsonObject)object, (String)"amount", (int)1)));
            });
            AssemblyRecipeRegistry.REGISTRY.put(key, new AssemblyRecipeBasic(key, powercost, ImmutableSet.copyOf(ingredients), output));
        }
    }
}

