/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IRefineryRecipeManager;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.block.BlockHeatExchange;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.block.VanillaRotationHandlers;
import buildcraft.lib.cap.CapabilityHelper;
import buildcraft.lib.fluid.FluidSmoother;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.fluid.TankManager;
import buildcraft.lib.misc.BoundingBoxUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.FluidUtilBC;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.SoundUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileHeatExchange
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("HeatExchanger");
    public static final int NET_ID_CHANGE_SECTION = IDS.allocId("CHANGE_SECTION");
    public static final int NET_ID_TANK_IN = IDS.allocId("TANK_IN");
    public static final int NET_ID_TANK_OUT = IDS.allocId("TANK_OUT");
    public static final int NET_ID_STATE = IDS.allocId("STATE");
    private static final int[] FLUID_MULT = new int[]{5, 10, 20};
    protected ExchangeSection section;
    private boolean checkNeighbours;

    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound nbtSection = nbt.func_74775_l("section");
        if (!nbtSection.func_82582_d()) {
            this.section = nbtSection.func_74767_n("start") ? new ExchangeSectionStart(this, nbtSection) : new ExchangeSectionEnd(this, nbtSection);
        }
        this.checkNeighbours = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.section != null) {
            nbt.func_74782_a("section", (NBTBase)this.section.writeToNbt());
        }
        return nbt;
    }

    public void func_73660_a() {
        if (this.checkNeighbours) {
            this.checkNeighbours = false;
            Deque<TileHeatExchange> exchangers = this.findAdjacentExchangers();
            if (this.field_145850_b.field_72995_K) {
                if (exchangers.size() > 2) {
                    TileHeatExchange start = exchangers.getFirst();
                    TileHeatExchange end = exchangers.getLast();
                    if (start.isStart() && end.isEnd()) {
                        ((ExchangeSectionStart)start.section).endSection = (ExchangeSectionEnd)end.section;
                    }
                }
                for (TileHeatExchange tile : exchangers) {
                    tile.redrawBlock();
                }
            } else if (exchangers.isEmpty()) {
                this.checkNeighbours = true;
            } else if (exchangers.size() < 3) {
                for (TileHeatExchange tile : exchangers) {
                    tile.removeSection();
                }
            } else if (exchangers.size() <= 5) {
                ExchangeSectionStart sectionStart = null;
                ExchangeSectionEnd sectionEnd = null;
                for (TileHeatExchange exchange : exchangers) {
                    exchange.checkNeighbours = false;
                    if (exchange.section instanceof ExchangeSectionStart) {
                        if (sectionStart == null) {
                            sectionStart = (ExchangeSectionStart)exchange.section;
                        }
                    } else if (exchange.section instanceof ExchangeSectionEnd && sectionEnd == null) {
                        sectionEnd = (ExchangeSectionEnd)exchange.section;
                    }
                    exchange.section = null;
                }
                if (sectionStart == null) {
                    sectionStart = new ExchangeSectionStart(exchangers.getFirst());
                }
                if (sectionEnd == null) {
                    sectionEnd = new ExchangeSectionEnd(exchangers.getLast());
                }
                sectionStart.endSection = sectionEnd;
                sectionStart.middleCount = exchangers.size() - 2;
                exchangers.getFirst().setSection(sectionStart);
                exchangers.getLast().setSection(sectionEnd);
                for (TileHeatExchange exchange : exchangers) {
                    exchange.sendNetworkUpdate(NET_ID_CHANGE_SECTION);
                }
            }
        }
        if (this.section != null) {
            this.section.tick();
        }
    }

    private void removeSection() {
        if (this.section == null) {
            return;
        }
        BCLog.logger.info("[] removing section...");
        NonNullList list = NonNullList.func_191196_a();
        this.section.tankManager.addDrops(list);
        InventoryUtil.dropAll((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (NonNullList)list);
        this.section = null;
        this.sendNetworkUpdate(NET_ID_CHANGE_SECTION);
    }

    private Deque<TileHeatExchange> findAdjacentExchangers() {
        TileHeatExchange other;
        TileEntity neighbour;
        int i;
        EnumFacing thisFacing = this.getFacing();
        if (thisFacing == null) {
            return new ArrayDeque<TileHeatExchange>();
        }
        EnumFacing dirToStart = thisFacing.func_176746_e();
        EnumFacing dirToEnd = thisFacing.func_176735_f();
        ArrayDeque<TileHeatExchange> exchangers = new ArrayDeque<TileHeatExchange>();
        exchangers.add(this);
        for (i = 1; i < 6 && (neighbour = this.getLocalTile(this.field_174879_c.func_177967_a(dirToStart, i))) instanceof TileHeatExchange && (other = (TileHeatExchange)neighbour).getFacing() == thisFacing; ++i) {
            exchangers.addFirst(other);
        }
        for (i = 1; i < 6 && (neighbour = this.getLocalTile(this.field_174879_c.func_177967_a(dirToEnd, i))) instanceof TileHeatExchange && (other = (TileHeatExchange)neighbour).getFacing() == thisFacing; ++i) {
            exchangers.addLast(other);
        }
        return exchangers;
    }

    private void setSection(ExchangeSection section) {
        if (this.section != section) {
            this.section = section;
            section.setTile(this);
            this.sendNetworkUpdate(NET_ID_CHANGE_SECTION);
        }
    }

    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.readPayload(NET_ID_CHANGE_SECTION, buffer, side, ctx);
            } else if (id == NET_ID_CHANGE_SECTION) {
                if (buffer.readBoolean()) {
                    boolean start = buffer.readBoolean();
                    this.section = start ? (this.section instanceof ExchangeSectionStart ? this.section : new ExchangeSectionStart(this)) : (this.section instanceof ExchangeSectionEnd ? this.section : new ExchangeSectionEnd(this));
                    this.section.readPayload(NET_ID_CHANGE_SECTION, buffer, side, ctx);
                } else {
                    this.section = null;
                }
                this.checkNeighbours = true;
            } else if (this.section != null) {
                this.section.readPayload(id, buffer, side, ctx);
            }
        }
    }

    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.writePayload(NET_ID_CHANGE_SECTION, buffer, side);
            } else if (id == NET_ID_CHANGE_SECTION) {
                if (this.section == null) {
                    buffer.writeBoolean(false);
                } else {
                    buffer.writeBoolean(true);
                    buffer.writeBoolean(this.section instanceof ExchangeSectionStart);
                    this.section.writePayload(id, buffer, side);
                }
            } else if (this.section != null) {
                this.section.writePayload(id, buffer, side);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.section instanceof ExchangeSectionStart) {
            return BoundingBoxUtil.makeAround((Vec3d)VecUtil.convertCenter((Vec3i)this.func_174877_v()), (double)10.0);
        }
        return super.getRenderBoundingBox();
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (this.section != null) {
            return (T)this.section.caps.getCapability(capability, facing);
        }
        return null;
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.section != null) {
            return this.section.tankManager.onActivated(player, this.field_174879_c, hand);
        }
        return false;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.section instanceof ExchangeSectionStart) {
            ((ExchangeSectionStart)this.section).endSection = null;
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.checkNeighbours = true;
    }

    public void onNeighbourBlockChanged(Block block, BlockPos nehighbour) {
        if (nehighbour.func_177956_o() != this.field_174879_c.func_177956_o()) {
            return;
        }
        this.checkNeighbours = true;
    }

    public void addDrops(NonNullList<ItemStack> toDrop, int fortune) {
        super.addDrops(toDrop, fortune);
        if (this.section != null) {
            this.section.tankManager.addDrops(toDrop);
        }
    }

    public boolean rotate() {
        EnumFacing thisFacing = this.getFacing();
        if (thisFacing == null) {
            return false;
        }
        Deque<TileHeatExchange> exchangers = this.findAdjacentExchangers();
        if (exchangers.size() == 1) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), this.getCurrentState().func_177226_a(BlockHeatExchange.PROP_FACING, (Comparable)((Object)VanillaRotationHandlers.ROTATE_HORIZONTAL.next((Enum)thisFacing))));
        } else {
            TileHeatExchange tile;
            ExchangeSectionStart start = null;
            ExchangeSectionEnd end = null;
            for (TileHeatExchange exchange : exchangers) {
                if (exchange.section instanceof ExchangeSectionStart) {
                    start = (ExchangeSectionStart)exchange.section;
                } else if (exchange.section instanceof ExchangeSectionEnd) {
                    end = (ExchangeSectionEnd)exchange.section;
                }
                exchange.section = null;
                this.field_145850_b.func_175656_a(exchange.func_174877_v(), exchange.getCurrentState().func_177226_a(BlockHeatExchange.PROP_FACING, (Comparable)thisFacing.func_176734_d()));
                exchange.checkNeighbours = true;
                exchange.markChunkDirty();
            }
            if (start != null) {
                tile = exchangers.getLast();
                tile.section = start;
                start.setTile(tile);
                tile.markChunkDirty();
                tile.sendNetworkUpdate(NET_ID_CHANGE_SECTION);
            }
            if (end != null) {
                tile = exchangers.getFirst();
                tile.section = end;
                end.setTile(tile);
                tile.markChunkDirty();
                tile.sendNetworkUpdate(NET_ID_CHANGE_SECTION);
            }
        }
        SoundUtil.playSlideSound((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        return true;
    }

    public boolean isStart() {
        return this.section instanceof ExchangeSectionStart;
    }

    public boolean isEnd() {
        return this.section instanceof ExchangeSectionEnd;
    }

    public ExchangeSection getSection() {
        return this.section;
    }

    @Nullable
    EnumFacing getFacing() {
        IBlockState state = this.getCurrentStateForBlock((Block)BCFactoryBlocks.heatExchange);
        if (state == null) {
            return null;
        }
        return (EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING);
    }

    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        if (this.section == null) {
            left.add("section = null");
        } else {
            left.add("section = " + (this.section instanceof ExchangeSectionStart ? "start" : "end"));
            this.section.getDebugInfo(left, right, side);
        }
    }

    public static enum EnumProgressState {
        OFF,
        PREPARING,
        RUNNING,
        STOPPING;

    }

    public static class ExchangeSectionEnd
    extends ExchangeSection {
        ExchangeSectionEnd(TileHeatExchange tile) {
            super(tile);
            this.tankInput.setFilter(this::isCoolant);
            this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, (Object)this.tankOutput, new EnumPipePart[]{EnumPipePart.UP});
            this.caps.addCapability(CapUtil.CAP_FLUIDS, this::getTankForSide, EnumPipePart.HORIZONTALS);
        }

        ExchangeSectionEnd(TileHeatExchange tile, NBTTagCompound nbt) {
            super(tile, nbt);
            this.tankInput.setFilter(this::isCoolant);
            this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, (Object)this.tankOutput, new EnumPipePart[]{EnumPipePart.UP});
            this.caps.addCapability(CapUtil.CAP_FLUIDS, this::getTankForSide, EnumPipePart.HORIZONTALS);
        }

        private boolean isCoolant(FluidStack fluid) {
            return BuildcraftRecipeRegistry.refineryRecipes.getCoolableRegistry().getRecipeForInput(fluid) != null;
        }

        private IFluidHandler getTankForSide(EnumFacing side) {
            EnumFacing thisFacing = this.getTile().getFacing();
            if (thisFacing == null || side != thisFacing.func_176735_f()) {
                return null;
            }
            return this.tankInput;
        }

        @Override
        NBTTagCompound writeToNbt() {
            NBTTagCompound nbt = super.writeToNbt();
            nbt.func_74757_a("start", false);
            return nbt;
        }

        @Nullable
        IFluidHandler getFluidAutoOutputTarget() {
            TileEntity neighbour = this.getTile().getNeighbourTile(EnumFacing.UP);
            if (neighbour == null) {
                return null;
            }
            return (IFluidHandler)neighbour.getCapability(CapUtil.CAP_FLUIDS, EnumFacing.DOWN);
        }
    }

    public static class ExchangeSectionStart
    extends ExchangeSection {
        private ExchangeSectionEnd endSection;
        public int middleCount;
        private int progress = 0;
        private int progressLast = 0;
        private EnumProgressState progressState = EnumProgressState.OFF;
        private EnumProgressState lastSentState = EnumProgressState.OFF;
        private int inputCoolantAmountCharge = 0;
        private int inputHeatantAmountCharge = 0;

        ExchangeSectionStart(TileHeatExchange tile) {
            super(tile);
            this.tankInput.setFilter(this::isHeatant);
            this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, (Object)this.tankInput, new EnumPipePart[]{EnumPipePart.DOWN});
            this.caps.addCapability(CapUtil.CAP_FLUIDS, this::getTankForSide, EnumPipePart.HORIZONTALS);
        }

        ExchangeSectionStart(TileHeatExchange tile, NBTTagCompound nbt) {
            super(tile, nbt);
            this.tankInput.setFilter(this::isHeatant);
            this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, (Object)this.tankInput, new EnumPipePart[]{EnumPipePart.DOWN});
            this.caps.addCapability(CapUtil.CAP_FLUIDS, this::getTankForSide, EnumPipePart.HORIZONTALS);
            this.inputCoolantAmountCharge = nbt.func_74762_e("coolantCharge");
            this.inputHeatantAmountCharge = nbt.func_74762_e("heatantCharge");
        }

        @Override
        NBTTagCompound writeToNbt() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("start", true);
            nbt.func_74768_a("coolantCharge", this.inputCoolantAmountCharge);
            nbt.func_74768_a("heatantCharge", this.inputHeatantAmountCharge);
            return nbt;
        }

        @Override
        void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
            super.readPayload(id, buffer, side, ctx);
            if (side == Side.CLIENT) {
                if (id == NET_ID_CHANGE_SECTION) {
                    this.middleCount = buffer.readUnsignedByte();
                } else if (id == NET_ID_STATE) {
                    this.progressState = (EnumProgressState)buffer.func_179257_a(EnumProgressState.class);
                }
            }
        }

        @Override
        void writePayload(int id, PacketBufferBC buffer, Side side) {
            super.writePayload(id, buffer, side);
            if (side == Side.SERVER) {
                if (id == NET_ID_CHANGE_SECTION) {
                    buffer.writeByte(this.middleCount);
                } else if (id == NET_ID_STATE) {
                    buffer.writeEnumValue((Enum)this.progressState);
                }
            }
        }

        public ExchangeSectionEnd getEndSection() {
            return this.endSection;
        }

        public EnumProgressState getProgressState() {
            return this.progressState;
        }

        public double getProgress(float partialTicks) {
            return MathUtil.interp((double)partialTicks, (double)this.progressLast, (double)this.progress) / 120.0;
        }

        private boolean isHeatant(FluidStack fluid) {
            return BuildcraftRecipeRegistry.refineryRecipes.getHeatableRegistry().getRecipeForInput(fluid) != null;
        }

        private IFluidHandler getTankForSide(EnumFacing side) {
            EnumFacing thisFacing = this.getTile().getFacing();
            if (thisFacing == null || side != thisFacing.func_176746_e()) {
                return null;
            }
            return this.tankOutput;
        }

        @Override
        void tick() {
            super.tick();
            this.updateProgress();
            if (((TileHeatExchange)this.getTile()).field_145850_b.field_72995_K) {
                this.spawnParticles();
                return;
            }
            if (this.endSection != null) {
                this.craft();
            } else if (this.progressState != EnumProgressState.OFF) {
                this.progressState = EnumProgressState.STOPPING;
            }
            this.output();
            if (this.progressState != this.lastSentState) {
                this.lastSentState = this.progressState;
                this.getTile().sendNetworkUpdate(NET_ID_STATE);
            }
        }

        private void updateProgress() {
            this.progressLast = this.progress--;
            switch (this.progressState) {
                case STOPPING: {
                    if (this.progress <= 0) {
                        this.progress = 0;
                        this.progressState = EnumProgressState.OFF;
                    }
                    return;
                }
                case PREPARING: 
                case RUNNING: {
                    int lag = 120;
                    ++this.progress;
                    if (this.progress >= lag) {
                        this.progress = lag;
                        this.progressState = EnumProgressState.RUNNING;
                    }
                    return;
                }
            }
        }

        private void craft() {
            Tank c_in = this.endSection.tankInput;
            Tank c_out = this.tankOutput;
            Tank h_in = this.tankInput;
            Tank h_out = this.endSection.tankOutput;
            IRefineryRecipeManager reg = BuildcraftRecipeRegistry.refineryRecipes;
            IRefineryRecipeManager.ICoolableRecipe c_recipe = (IRefineryRecipeManager.ICoolableRecipe)reg.getCoolableRegistry().getRecipeForInput(c_in.getFluid());
            IRefineryRecipeManager.IHeatableRecipe h_recipe = (IRefineryRecipeManager.IHeatableRecipe)reg.getHeatableRegistry().getRecipeForInput(h_in.getFluid());
            if (h_recipe == null || c_recipe == null) {
                this.progressState = EnumProgressState.STOPPING;
                return;
            }
            if (c_recipe.heatFrom() <= h_recipe.heatFrom()) {
                this.progressState = EnumProgressState.STOPPING;
                return;
            }
            int c_diff = c_recipe.heatFrom() - c_recipe.heatTo();
            int h_diff = h_recipe.heatTo() - h_recipe.heatFrom();
            if (h_diff < 1 || c_diff < 1) {
                throw new IllegalStateException("Invalid recipe " + c_recipe + ", " + h_recipe);
            }
            int max_amount = FLUID_MULT[this.middleCount - 1];
            FluidStack c_in_f = ExchangeSectionStart.setAmount(c_recipe.in(), max_amount);
            FluidStack c_out_f = ExchangeSectionStart.setAmount(c_recipe.out(), max_amount);
            FluidStack h_in_f = ExchangeSectionStart.setAmount(h_recipe.in(), max_amount);
            FluidStack h_out_f = ExchangeSectionStart.setAmount(h_recipe.out(), max_amount);
            int c_out_amount = c_out_f == null ? max_amount : c_out.fillInternal(c_out_f, false);
            int h_out_amount = h_out_f == null ? max_amount : h_out.fillInternal(h_out_f, false);
            int c_in_amount = ExchangeSectionStart.drainableAmount(c_in, c_in_f);
            int h_in_amount = ExchangeSectionStart.drainableAmount(h_in, h_in_f);
            int min_common_multiplier = Math.min(Math.min(Math.min(c_out_amount, h_out_amount), c_in_amount), h_in_amount);
            if (min_common_multiplier > 0) {
                c_in_f = ExchangeSectionStart.setAmount(c_recipe.in(), min_common_multiplier);
                c_out_f = ExchangeSectionStart.setAmount(c_recipe.out(), min_common_multiplier);
                h_in_f = ExchangeSectionStart.setAmount(h_recipe.in(), min_common_multiplier);
                h_out_f = ExchangeSectionStart.setAmount(h_recipe.out(), min_common_multiplier);
                if (this.progressState == EnumProgressState.OFF) {
                    this.progressState = EnumProgressState.PREPARING;
                } else if (this.progressState == EnumProgressState.RUNNING) {
                    ExchangeSectionStart.fill(c_out, c_out_f);
                    ExchangeSectionStart.drain(c_in, c_in_f);
                    ExchangeSectionStart.fill(h_out, h_out_f);
                    ExchangeSectionStart.drain(h_in, h_in_f);
                }
            } else {
                this.progressState = EnumProgressState.STOPPING;
            }
        }

        private void spawnParticles() {
            if (this.progressState == EnumProgressState.RUNNING) {
                EnumFacing facing;
                ExchangeSectionEnd end = this.endSection;
                if (end == null) {
                    return;
                }
                Vec3d from = VecUtil.convertCenter((Vec3i)this.getTile().func_174877_v());
                FluidStack c_in_f = end.smoothedTankInput.getFluidForRender();
                if (c_in_f != null && c_in_f.getFluid() == FluidRegistry.LAVA && (facing = this.getTile().getFacing()) != null) {
                    this.spewForth(from, facing.func_176746_e(), EnumParticleTypes.SMOKE_LARGE);
                }
                FluidStack h_in_f = this.smoothedTankInput.getFluidForRender();
                from = VecUtil.convertCenter((Vec3i)end.getTile().func_174877_v());
                if (h_in_f != null && h_in_f.getFluid() == FluidRegistry.WATER) {
                    EnumFacing dir = EnumFacing.UP;
                    this.spewForth(from, dir, EnumParticleTypes.CLOUD);
                }
            }
        }

        private void spewForth(Vec3d from, EnumFacing dir, EnumParticleTypes particle) {
            Vec3d vecDir = new Vec3d(dir.func_176730_m());
            from = from.func_178787_e(vecDir);
            double x = from.field_72450_a;
            double y = from.field_72448_b;
            double z = from.field_72449_c;
            Vec3d motion = VecUtil.scale((Vec3d)vecDir, (double)0.4);
            int particleCount = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
            World w = this.getTile().func_145831_w();
            if (particleCount == 2 || w == null) {
                return;
            }
            particleCount = particleCount == 0 ? 5 : 2;
            for (int i = 0; i < particleCount; ++i) {
                double dx = motion.field_72450_a + (Math.random() - 0.5) * 0.1;
                double dy = motion.field_72448_b + (Math.random() - 0.5) * 0.1;
                double dz = motion.field_72449_c + (Math.random() - 0.5) * 0.1;
                double interp = (double)i / (double)particleCount;
                w.func_175688_a(particle, x -= dx * interp, y -= dy * interp, z -= dz * interp, dx, dy, dz, new int[0]);
            }
        }

        private void output() {
            IFluidHandler thisOut = this.getFluidAutoOutputTarget();
            FluidUtilBC.move((IFluidHandler)this.tankOutput, (IFluidHandler)thisOut, (int)1000);
            if (this.endSection != null) {
                IFluidHandler endOut = this.endSection.getFluidAutoOutputTarget();
                FluidUtilBC.move((IFluidHandler)this.endSection.tankOutput, (IFluidHandler)endOut, (int)1000);
            }
        }

        private static FluidStack setAmount(FluidStack fluid, int mult) {
            if (fluid == null) {
                return null;
            }
            return new FluidStack(fluid, mult);
        }

        private static int drainableAmount(Tank t, FluidStack fluid) {
            FluidStack f2 = t.drainInternal(fluid, false);
            return f2 == null ? 0 : f2.amount;
        }

        private static void fill(Tank t, FluidStack fluid) {
            if (fluid == null) {
                return;
            }
            int a = t.fillInternal(fluid, true);
            if (a != fluid.amount) {
                String err = "Buggy transition! Failed to fill " + fluid.getFluid();
                throw new IllegalStateException(err + " x " + fluid.amount + " into " + t);
            }
        }

        private static void drain(Tank t, FluidStack fluid) {
            FluidStack f2 = t.drainInternal(fluid, true);
            if (f2 == null || f2.amount != fluid.amount) {
                String err = "Buggy transition! Failed to drain " + fluid.getFluid();
                throw new IllegalStateException(err + " x " + fluid.amount + " from " + t);
            }
        }

        @Nullable
        private IFluidHandler getFluidAutoOutputTarget() {
            EnumFacing facing = this.getTile().getFacing();
            if (facing == null) {
                return null;
            }
            TileEntity neighbour = this.getTile().getNeighbourTile(facing.func_176746_e());
            if (neighbour == null) {
                return null;
            }
            return (IFluidHandler)neighbour.getCapability(CapUtil.CAP_FLUIDS, facing.func_176735_f());
        }

        @Override
        void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
            super.getDebugInfo(left, right, side);
            left.add("progress = " + this.progress);
            left.add("state = " + (Object)((Object)this.progressState));
            left.add("has_end = " + (this.endSection != null));
        }
    }

    static abstract class ExchangeSection {
        final Tank tankInput;
        final Tank tankOutput;
        final TankManager tankManager;
        public final FluidSmoother smoothedTankInput;
        public final FluidSmoother smoothedTankOutput;
        public final CapabilityHelper caps = new CapabilityHelper();
        private TileHeatExchange tile;

        ExchangeSection(TileHeatExchange tile) {
            this.tankInput = new Tank("input", 2000, (TileEntity)tile);
            this.tankOutput = new Tank("output", 2000, (TileEntity)tile);
            this.tankOutput.setCanFill(false);
            this.tankManager = new TankManager(new Tank[]{this.tankOutput, this.tankInput});
            this.smoothedTankInput = this.createFluidSmoother(this.tankInput, NET_ID_TANK_IN);
            this.smoothedTankOutput = this.createFluidSmoother(this.tankOutput, NET_ID_TANK_OUT);
            this.setTile(tile);
        }

        ExchangeSection(TileHeatExchange tile, NBTTagCompound nbt) {
            this(tile);
            this.tankInput.readFromNBT(nbt.func_74775_l("input"));
            this.tankOutput.readFromNBT(nbt.func_74775_l("output"));
        }

        FluidSmoother createFluidSmoother(Tank tank, int netId) {
            return new FluidSmoother(w -> this.getTile().createAndSendMessage(netId, w), tank);
        }

        NBTTagCompound writeToNbt() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("input", (NBTBase)this.tankInput.serializeNBT());
            nbt.func_74782_a("output", (NBTBase)this.tankOutput.serializeNBT());
            return nbt;
        }

        void tick() {
            World world = this.getTile().field_145850_b;
            this.smoothedTankInput.tick(world);
            this.smoothedTankOutput.tick(world);
        }

        void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
            if (side == Side.CLIENT) {
                if (id == NET_ID_CHANGE_SECTION) {
                    this.readPayload(NET_ID_TANK_IN, buffer, side, ctx);
                    this.readPayload(NET_ID_TANK_OUT, buffer, side, ctx);
                    this.smoothedTankInput.resetSmoothing(this.getTile().field_145850_b);
                    this.smoothedTankOutput.resetSmoothing(this.getTile().field_145850_b);
                } else if (id == NET_ID_TANK_IN) {
                    this.smoothedTankInput.handleMessage(this.getTile().field_145850_b, buffer);
                } else if (id == NET_ID_TANK_OUT) {
                    this.smoothedTankOutput.handleMessage(this.getTile().field_145850_b, buffer);
                }
            } else if (side == Side.SERVER) {
                // empty if block
            }
        }

        void writePayload(int id, PacketBufferBC buffer, Side side) {
            if (side == Side.SERVER) {
                if (id == NET_ID_CHANGE_SECTION) {
                    this.writePayload(NET_ID_TANK_IN, buffer, side);
                    this.writePayload(NET_ID_TANK_OUT, buffer, side);
                } else if (id == NET_ID_TANK_IN) {
                    this.smoothedTankInput.writeInit(buffer);
                } else if (id == NET_ID_TANK_OUT) {
                    this.smoothedTankOutput.writeInit(buffer);
                }
            } else if (side == Side.CLIENT) {
                // empty if block
            }
        }

        void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
            left.add("tank_input = " + this.tankInput.getDebugString());
            left.add("tank_output = " + this.tankOutput.getDebugString());
            left.add("smoothed_input: ");
            this.smoothedTankInput.getDebugInfo(left, right, side);
            left.add("smoothed_output: ");
            this.smoothedTankOutput.getDebugInfo(left, right, side);
        }

        public TileHeatExchange getTile() {
            return this.tile;
        }

        public void setTile(TileHeatExchange tile) {
            this.tile = tile;
            this.tankInput.setTileEntity((TileEntity)tile);
            this.tankOutput.setTileEntity((TileEntity)tile);
        }
    }
}

