/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.JsonWriter;
import kotlinx.serialization.json.internal.StringOpsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u000f\u0010\u0014\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b!\u0010\u0018R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lkotlinx/serialization/json/internal/JsonToStringWriter;", "Lkotlinx/serialization/json/internal/JsonWriter;", "<init>", "()V", "", "firstEscapedChar", "currentSize", "", "string", "", "appendStringSlowPath", "(IILjava/lang/String;)V", "expected", "ensureAdditionalCapacity", "(I)V", "oldSize", "additional", "ensureTotalCapacity", "(II)I", "release", "toString", "()Ljava/lang/String;", "text", "write", "(Ljava/lang/String;)V", "", "char", "writeChar", "(C)V", "", "value", "writeLong", "(J)V", "writeQuoted", "", "array", "[C", "size", "I", "kotlinx-serialization-json"})
public final class JsonToStringWriter
implements JsonWriter {
    @NotNull
    private char[] array = CharArrayPool.INSTANCE.take();
    private int size;

    @Override
    public void writeLong(long value) {
        this.write(String.valueOf(value));
    }

    @Override
    public void writeChar(char c) {
        this.ensureAdditionalCapacity(1);
        int n = this.size;
        this.size = n + 1;
        this.array[n] = c;
    }

    @Override
    public void write(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        int length = text.length();
        if (length == 0) {
            return;
        }
        this.ensureAdditionalCapacity(length);
        String string = text;
        char[] cArray = this.array;
        int n = this.size;
        int n2 = 0;
        int n3 = text.length();
        string.getChars(n2, n3, cArray, n);
        this.size += length;
    }

    @Override
    public void writeQuoted(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.ensureAdditionalCapacity(text.length() + 2);
        char[] arr = this.array;
        int sz = this.size;
        arr[sz++] = 34;
        int length = text.length();
        String string = text;
        int n = 0;
        string.getChars(n, length, arr, sz);
        n = sz + length;
        for (int i = sz; i < n; ++i) {
            char ch = arr[i];
            if (ch >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
            this.appendStringSlowPath(i - sz, i, text);
            return;
        }
        sz += length;
        arr[sz++] = 34;
        this.size = sz;
    }

    private final void appendStringSlowPath(int firstEscapedChar, int currentSize, String string) {
        int sz = currentSize;
        int n = string.length();
        for (int i = firstEscapedChar; i < n; ++i) {
            sz = this.ensureTotalCapacity(sz, 2);
            char ch = string.charAt(i);
            if (ch < StringOpsKt.getESCAPE_MARKERS().length) {
                byte marker = StringOpsKt.getESCAPE_MARKERS()[ch];
                if (marker == 0) {
                    this.array[sz++] = ch;
                    continue;
                }
                if (marker == 1) {
                    String escapedString;
                    Intrinsics.checkNotNull(StringOpsKt.getESCAPE_STRINGS()[ch]);
                    sz = this.ensureTotalCapacity(sz, escapedString.length());
                    String string2 = escapedString;
                    char[] cArray = this.array;
                    int n2 = 0;
                    int n3 = escapedString.length();
                    string2.getChars(n2, n3, cArray, sz);
                    this.size = sz += escapedString.length();
                    continue;
                }
                this.array[sz] = 92;
                this.array[sz + 1] = (char)marker;
                this.size = sz += 2;
                continue;
            }
            this.array[sz++] = ch;
        }
        sz = this.ensureTotalCapacity(sz, 1);
        this.array[sz++] = 34;
        this.size = sz;
    }

    @Override
    public void release() {
        CharArrayPool.INSTANCE.release(this.array);
    }

    @NotNull
    public String toString() {
        return new String(this.array, 0, this.size);
    }

    private final void ensureAdditionalCapacity(int expected) {
        this.ensureTotalCapacity(this.size, expected);
    }

    private final int ensureTotalCapacity(int oldSize, int additional) {
        int newSize = oldSize + additional;
        if (this.array.length <= newSize) {
            char[] cArray = Arrays.copyOf(this.array, RangesKt.coerceAtLeast(newSize, oldSize * 2));
            Intrinsics.checkNotNullExpressionValue(cArray, "copyOf(this, newSize)");
            this.array = cArray;
        }
        return oldSize;
    }
}

