/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.internal.ByteArrayPool8k;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J%\u0010\u0012\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lkotlinx/serialization/json/internal/CharsetReader;", "", "Ljava/io/InputStream;", "inputStream", "Ljava/nio/charset/Charset;", "charset", "<init>", "(Ljava/io/InputStream;Ljava/nio/charset/Charset;)V", "", "array", "", "offset", "length", "doRead", "([CII)I", "fillByteBuffer", "()I", "oneShotReadSlowPath", "read", "", "release", "()V", "Ljava/nio/ByteBuffer;", "byteBuffer", "Ljava/nio/ByteBuffer;", "Ljava/nio/charset/Charset;", "Ljava/nio/charset/CharsetDecoder;", "decoder", "Ljava/nio/charset/CharsetDecoder;", "", "hasLeftoverPotentiallySurrogateChar", "Z", "Ljava/io/InputStream;", "", "leftoverChar", "C", "kotlinx-serialization-json"})
public final class CharsetReader {
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final Charset charset;
    @NotNull
    private final CharsetDecoder decoder;
    @NotNull
    private final ByteBuffer byteBuffer;
    private boolean hasLeftoverPotentiallySurrogateChar;
    private char leftoverChar;

    public CharsetReader(@NotNull InputStream inputStream, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(charset, "charset");
        this.inputStream = inputStream;
        this.charset = charset;
        CharsetDecoder charsetDecoder = this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        Intrinsics.checkNotNullExpressionValue(charsetDecoder, "onUnmappableCharacter(...)");
        this.decoder = charsetDecoder;
        ByteBuffer byteBuffer = ByteBuffer.wrap(ByteArrayPool8k.INSTANCE.take());
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "wrap(...)");
        this.byteBuffer = byteBuffer;
        this.byteBuffer.flip();
    }

    public final int read(@NotNull char[] array, int offset, int length) {
        Intrinsics.checkNotNullParameter(array, "array");
        if (length == 0) {
            return 0;
        }
        if (!((0 <= offset ? offset < array.length : false) && length >= 0 && offset + length <= array.length)) {
            boolean $i$a$-require-CharsetReader$read$22 = false;
            String $i$a$-require-CharsetReader$read$22 = "Unexpected arguments: " + offset + ", " + length + ", " + array.length;
            throw new IllegalArgumentException($i$a$-require-CharsetReader$read$22.toString());
        }
        int offset2 = offset;
        int length2 = length;
        int bytesRead = 0;
        if (this.hasLeftoverPotentiallySurrogateChar) {
            array[offset2] = this.leftoverChar;
            ++offset2;
            this.hasLeftoverPotentiallySurrogateChar = false;
            bytesRead = 1;
            if (--length2 == 0) {
                return bytesRead;
            }
        }
        if (length2 == 1) {
            int c = this.oneShotReadSlowPath();
            if (c == -1) {
                return bytesRead == 0 ? -1 : bytesRead;
            }
            array[offset2] = (char)c;
            return bytesRead + 1;
        }
        return this.doRead(array, offset2, length2) + bytesRead;
    }

    private final int doRead(char[] array, int offset, int length) {
        CharBuffer charBuffer = CharBuffer.wrap(array, offset, length);
        if (charBuffer.position() != 0) {
            charBuffer = charBuffer.slice();
        }
        boolean isEof = false;
        while (true) {
            CoderResult cr;
            if ((cr = this.decoder.decode(this.byteBuffer, charBuffer, isEof)).isUnderflow()) {
                if (isEof || !charBuffer.hasRemaining()) break;
                int n = this.fillByteBuffer();
                if (n >= 0) continue;
                isEof = true;
                if (charBuffer.position() == 0 && !this.byteBuffer.hasRemaining()) break;
                this.decoder.reset();
                continue;
            }
            if (cr.isOverflow()) {
                boolean bl;
                boolean bl2 = bl = charBuffer.position() > 0;
                if (!_Assertions.ENABLED || bl) break;
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            cr.throwException();
        }
        if (isEof) {
            this.decoder.reset();
        }
        return charBuffer.position() == 0 ? -1 : charBuffer.position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int fillByteBuffer() {
        this.byteBuffer.compact();
        try {
            int limit = this.byteBuffer.limit();
            int position = this.byteBuffer.position();
            int remaining = position <= limit ? limit - position : 0;
            int bytesRead = this.inputStream.read(this.byteBuffer.array(), this.byteBuffer.arrayOffset() + position, remaining);
            if (bytesRead < 0) {
                int n = bytesRead;
                return n;
            }
            ByteBuffer byteBuffer = this.byteBuffer;
            Intrinsics.checkNotNull(byteBuffer, "null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)byteBuffer).position(position + bytesRead);
        }
        finally {
            this.byteBuffer.flip();
        }
        return this.byteBuffer.remaining();
    }

    private final int oneShotReadSlowPath() {
        int n;
        if (this.hasLeftoverPotentiallySurrogateChar) {
            this.hasLeftoverPotentiallySurrogateChar = false;
            return this.leftoverChar;
        }
        char[] array = new char[2];
        int bytesRead = this.read(array, 0, 2);
        switch (bytesRead) {
            case -1: {
                n = -1;
                break;
            }
            case 1: {
                n = array[0];
                break;
            }
            case 2: {
                this.leftoverChar = array[1];
                this.hasLeftoverPotentiallySurrogateChar = true;
                n = array[0];
                break;
            }
            default: {
                throw new IllegalStateException(("Unreachable state: " + bytesRead).toString());
            }
        }
        return n;
    }

    public final void release() {
        byte[] byArray = this.byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        ByteArrayPool8k.INSTANCE.release(byArray);
    }
}

