/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ULong;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.InlineClassDescriptorKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonDecodingException;
import kotlinx.serialization.json.internal.JsonEncodingException;
import kotlinx.serialization.json.internal.StringJsonLexer;
import kotlinx.serialization.json.internal.StringOpsKt;
import kotlinx.serialization.json.internal.SuppressAnimalSniffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\u001a\u0017\u0010\u0003\u001a\u00020\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0019\u0010\u0003\u001a\u00020\u00062\b\u0010\u0001\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0007\u001a\u0017\u0010\u0003\u001a\u00020\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0003\u0010\t\u001a\u0017\u0010\u0003\u001a\u00020\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0003\u0010\u000b\u001a\u001d\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\fH\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u001d\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u000fH\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u001d\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0012H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u001d\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0015H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0019\u0010\u0018\u001a\u00020\u00022\b\u0010\u0001\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u000b\u001a$\u0010\u001c\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0082\b\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a&\u0010\u001e\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0082\b\u00a2\u0006\u0004\b\u001e\u0010\u001d\u001a\u001f\u0010!\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0001\u00a2\u0006\u0004\b!\u0010\"\u001a\u001b\u0010%\u001a\u00020\u0005*\u00020#2\u0006\u0010$\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b%\u0010&\"\u001a\u0010(\u001a\u00020'8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0015\u0010.\u001a\u00020\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\"\u0017\u00101\u001a\u0004\u0018\u00010\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0017\u00104\u001a\u0004\u0018\u00010\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\"\u0015\u00108\u001a\u000205*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\"\u0017\u0010;\u001a\u0004\u0018\u000105*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\"\u0015\u0010?\u001a\u00020<*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\"\u0017\u0010B\u001a\u0004\u0018\u00010<*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b@\u0010A\"\u0015\u0010F\u001a\u00020C*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\"\u0017\u0010I\u001a\u0004\u0018\u00010C*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\"\u0015\u0010M\u001a\u00020J*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\"\u0015\u0010P\u001a\u00020\u0006*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010O\"\u0015\u0010T\u001a\u00020Q*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010S\"\u0015\u0010W\u001a\u00020\u0002*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bU\u0010V\"\u0015\u0010[\u001a\u00020X*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bY\u0010Z\"\u0017\u0010^\u001a\u0004\u0018\u00010X*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006_"}, d2={"", "value", "Lkotlinx/serialization/json/JsonPrimitive;", "JsonPrimitive", "(Ljava/lang/Boolean;)Lkotlinx/serialization/json/JsonPrimitive;", "", "Lkotlinx/serialization/json/JsonNull;", "(Ljava/lang/Void;)Lkotlinx/serialization/json/JsonNull;", "", "(Ljava/lang/Number;)Lkotlinx/serialization/json/JsonPrimitive;", "", "(Ljava/lang/String;)Lkotlinx/serialization/json/JsonPrimitive;", "Lkotlin/UByte;", "JsonPrimitive-7apg3OU", "(B)Lkotlinx/serialization/json/JsonPrimitive;", "Lkotlin/UInt;", "JsonPrimitive-WZ4Q5Ns", "(I)Lkotlinx/serialization/json/JsonPrimitive;", "Lkotlin/ULong;", "JsonPrimitive-VKZWuLQ", "(J)Lkotlinx/serialization/json/JsonPrimitive;", "Lkotlin/UShort;", "JsonPrimitive-xj2QHRw", "(S)Lkotlinx/serialization/json/JsonPrimitive;", "JsonUnquotedLiteral", "T", "Lkotlin/Function0;", "f", "mapExceptions", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "mapExceptionsToNull", "key", "expected", "unexpectedJson", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Void;", "Lkotlinx/serialization/json/JsonElement;", "element", "error", "(Lkotlinx/serialization/json/JsonElement;Ljava/lang/String;)Ljava/lang/Void;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "jsonUnquotedLiteralDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getJsonUnquotedLiteralDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "getBoolean", "(Lkotlinx/serialization/json/JsonPrimitive;)Z", "boolean", "getBooleanOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Boolean;", "booleanOrNull", "getContentOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/String;", "contentOrNull", "", "getDouble", "(Lkotlinx/serialization/json/JsonPrimitive;)D", "double", "getDoubleOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Double;", "doubleOrNull", "", "getFloat", "(Lkotlinx/serialization/json/JsonPrimitive;)F", "float", "getFloatOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Float;", "floatOrNull", "", "getInt", "(Lkotlinx/serialization/json/JsonPrimitive;)I", "int", "getIntOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Integer;", "intOrNull", "Lkotlinx/serialization/json/JsonArray;", "getJsonArray", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonArray;", "jsonArray", "getJsonNull", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonNull;", "jsonNull", "Lkotlinx/serialization/json/JsonObject;", "getJsonObject", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonObject;", "jsonObject", "getJsonPrimitive", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonPrimitive;", "jsonPrimitive", "", "getLong", "(Lkotlinx/serialization/json/JsonPrimitive;)J", "long", "getLongOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Long;", "longOrNull", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nJsonElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonElement.kt\nkotlinx/serialization/json/JsonElementKt\n*L\n1#1,347:1\n337#1,4:348\n329#1,4:352\n337#1,4:356\n329#1,4:360\n*S KotlinDebug\n*F\n+ 1 JsonElement.kt\nkotlinx/serialization/json/JsonElementKt\n*L\n258#1:348,4\n268#1:352,4\n277#1:356,4\n284#1:360,4\n*E\n"})
public final class JsonElementKt {
    @NotNull
    private static final SerialDescriptor jsonUnquotedLiteralDescriptor = InlineClassDescriptorKt.InlinePrimitiveDescriptor("kotlinx.serialization.json.JsonUnquotedLiteral", BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE));

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable Boolean value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, false, null, 4, null);
    }

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable Number value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, false, null, 4, null);
    }

    @ExperimentalSerializationApi
    @NotNull
    public static final JsonPrimitive JsonPrimitive-7apg3OU(byte value) {
        return JsonElementKt.JsonPrimitive-VKZWuLQ(ULong.constructor-impl((long)value & 0xFFL));
    }

    @ExperimentalSerializationApi
    @NotNull
    public static final JsonPrimitive JsonPrimitive-xj2QHRw(short value) {
        return JsonElementKt.JsonPrimitive-VKZWuLQ(ULong.constructor-impl((long)value & 0xFFFFL));
    }

    @ExperimentalSerializationApi
    @NotNull
    public static final JsonPrimitive JsonPrimitive-WZ4Q5Ns(int value) {
        return JsonElementKt.JsonPrimitive-VKZWuLQ(ULong.constructor-impl((long)value & 0xFFFFFFFFL));
    }

    @ExperimentalSerializationApi
    @SuppressAnimalSniffer
    @NotNull
    public static final JsonPrimitive JsonPrimitive-VKZWuLQ(long value) {
        return JsonElementKt.JsonUnquotedLiteral(Long.toUnsignedString(value));
    }

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable String value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, true, null, 4, null);
    }

    @ExperimentalSerializationApi
    @NotNull
    public static final JsonNull JsonPrimitive(@Nullable Void value) {
        return JsonNull.INSTANCE;
    }

    @ExperimentalSerializationApi
    @NotNull
    public static final JsonPrimitive JsonUnquotedLiteral(@Nullable String value) {
        JsonPrimitive jsonPrimitive;
        String string = value;
        if (string == null) {
            jsonPrimitive = JsonNull.INSTANCE;
        } else {
            if (Intrinsics.areEqual(string, JsonNull.INSTANCE.getContent())) {
                throw new JsonEncodingException("Creating a literal unquoted value of 'null' is forbidden. If you want to create JSON null literal, use JsonNull object, otherwise, use JsonPrimitive");
            }
            jsonPrimitive = new JsonLiteral(value, false, jsonUnquotedLiteralDescriptor);
        }
        return jsonPrimitive;
    }

    @NotNull
    public static final SerialDescriptor getJsonUnquotedLiteralDescriptor() {
        return jsonUnquotedLiteralDescriptor;
    }

    @NotNull
    public static final JsonPrimitive getJsonPrimitive(@NotNull JsonElement $this$jsonPrimitive) {
        Intrinsics.checkNotNullParameter($this$jsonPrimitive, "<this>");
        JsonPrimitive jsonPrimitive = $this$jsonPrimitive instanceof JsonPrimitive ? (JsonPrimitive)$this$jsonPrimitive : null;
        if (jsonPrimitive == null) {
            JsonElementKt.error($this$jsonPrimitive, "JsonPrimitive");
            throw new KotlinNothingValueException();
        }
        return jsonPrimitive;
    }

    @NotNull
    public static final JsonObject getJsonObject(@NotNull JsonElement $this$jsonObject) {
        Intrinsics.checkNotNullParameter($this$jsonObject, "<this>");
        JsonObject jsonObject = $this$jsonObject instanceof JsonObject ? (JsonObject)$this$jsonObject : null;
        if (jsonObject == null) {
            JsonElementKt.error($this$jsonObject, "JsonObject");
            throw new KotlinNothingValueException();
        }
        return jsonObject;
    }

    @NotNull
    public static final JsonArray getJsonArray(@NotNull JsonElement $this$jsonArray) {
        Intrinsics.checkNotNullParameter($this$jsonArray, "<this>");
        JsonArray jsonArray = $this$jsonArray instanceof JsonArray ? (JsonArray)$this$jsonArray : null;
        if (jsonArray == null) {
            JsonElementKt.error($this$jsonArray, "JsonArray");
            throw new KotlinNothingValueException();
        }
        return jsonArray;
    }

    @NotNull
    public static final JsonNull getJsonNull(@NotNull JsonElement $this$jsonNull) {
        Intrinsics.checkNotNullParameter($this$jsonNull, "<this>");
        JsonNull jsonNull = $this$jsonNull instanceof JsonNull ? (JsonNull)$this$jsonNull : null;
        if (jsonNull == null) {
            JsonElementKt.error($this$jsonNull, "JsonNull");
            throw new KotlinNothingValueException();
        }
        return jsonNull;
    }

    public static final int getInt(@NotNull JsonPrimitive $this$int) {
        long l;
        Intrinsics.checkNotNullParameter($this$int, "<this>");
        boolean $i$f$mapExceptions = false;
        try {
            boolean bl = false;
            l = new StringJsonLexer($this$int.getContent()).consumeNumericLiteral();
        }
        catch (JsonDecodingException e$iv) {
            throw new NumberFormatException(e$iv.getMessage());
        }
        long result2 = l;
        if (!(Integer.MIN_VALUE <= result2 ? result2 <= Integer.MAX_VALUE : false)) {
            throw new NumberFormatException($this$int.getContent() + " is not an Int");
        }
        return (int)result2;
    }

    @Nullable
    public static final Integer getIntOrNull(@NotNull JsonPrimitive $this$intOrNull) {
        Long l;
        Intrinsics.checkNotNullParameter($this$intOrNull, "<this>");
        boolean $i$f$mapExceptionsToNull = false;
        try {
            boolean bl = false;
            l = new StringJsonLexer($this$intOrNull.getContent()).consumeNumericLiteral();
        }
        catch (JsonDecodingException e$iv) {
            l = null;
        }
        Long l2 = l;
        if (l2 == null) {
            return null;
        }
        long result2 = l2;
        if (!(Integer.MIN_VALUE <= result2 ? result2 <= Integer.MAX_VALUE : false)) {
            return null;
        }
        return (int)result2;
    }

    public static final long getLong(@NotNull JsonPrimitive $this$long) {
        long l;
        Intrinsics.checkNotNullParameter($this$long, "<this>");
        boolean $i$f$mapExceptions = false;
        try {
            boolean bl = false;
            l = new StringJsonLexer($this$long.getContent()).consumeNumericLiteral();
        }
        catch (JsonDecodingException e$iv) {
            throw new NumberFormatException(e$iv.getMessage());
        }
        return l;
    }

    @Nullable
    public static final Long getLongOrNull(@NotNull JsonPrimitive $this$longOrNull) {
        Long l;
        Intrinsics.checkNotNullParameter($this$longOrNull, "<this>");
        boolean $i$f$mapExceptionsToNull = false;
        try {
            boolean bl = false;
            l = new StringJsonLexer($this$longOrNull.getContent()).consumeNumericLiteral();
        }
        catch (JsonDecodingException e$iv) {
            l = null;
        }
        return l;
    }

    public static final double getDouble(@NotNull JsonPrimitive $this$double) {
        Intrinsics.checkNotNullParameter($this$double, "<this>");
        return Double.parseDouble($this$double.getContent());
    }

    @Nullable
    public static final Double getDoubleOrNull(@NotNull JsonPrimitive $this$doubleOrNull) {
        Intrinsics.checkNotNullParameter($this$doubleOrNull, "<this>");
        return StringsKt.toDoubleOrNull($this$doubleOrNull.getContent());
    }

    public static final float getFloat(@NotNull JsonPrimitive $this$float) {
        Intrinsics.checkNotNullParameter($this$float, "<this>");
        return Float.parseFloat($this$float.getContent());
    }

    @Nullable
    public static final Float getFloatOrNull(@NotNull JsonPrimitive $this$floatOrNull) {
        Intrinsics.checkNotNullParameter($this$floatOrNull, "<this>");
        return StringsKt.toFloatOrNull($this$floatOrNull.getContent());
    }

    public static final boolean getBoolean(@NotNull JsonPrimitive $this$boolean) {
        Intrinsics.checkNotNullParameter($this$boolean, "<this>");
        Boolean bl = StringOpsKt.toBooleanStrictOrNull($this$boolean.getContent());
        if (bl == null) {
            throw new IllegalStateException($this$boolean + " does not represent a Boolean");
        }
        return bl;
    }

    @Nullable
    public static final Boolean getBooleanOrNull(@NotNull JsonPrimitive $this$booleanOrNull) {
        Intrinsics.checkNotNullParameter($this$booleanOrNull, "<this>");
        return StringOpsKt.toBooleanStrictOrNull($this$booleanOrNull.getContent());
    }

    @Nullable
    public static final String getContentOrNull(@NotNull JsonPrimitive $this$contentOrNull) {
        Intrinsics.checkNotNullParameter($this$contentOrNull, "<this>");
        return $this$contentOrNull instanceof JsonNull ? null : $this$contentOrNull.getContent();
    }

    private static final Void error(JsonElement $this$error, String element) {
        throw new IllegalArgumentException("Element " + Reflection.getOrCreateKotlinClass($this$error.getClass()) + " is not a " + element);
    }

    private static final <T> T mapExceptionsToNull(Function0<? extends T> f) {
        T t2;
        boolean $i$f$mapExceptionsToNull = false;
        try {
            t2 = f.invoke();
        }
        catch (JsonDecodingException e) {
            t2 = null;
        }
        return t2;
    }

    private static final <T> T mapExceptions(Function0<? extends T> f) {
        T t2;
        boolean $i$f$mapExceptions = false;
        try {
            t2 = f.invoke();
        }
        catch (JsonDecodingException e) {
            throw new NumberFormatException(e.getMessage());
        }
        return t2;
    }

    @PublishedApi
    @NotNull
    public static final Void unexpectedJson(@NotNull String key, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(expected, "expected");
        throw new IllegalArgumentException("Element " + key + " is not a " + expected);
    }
}

