/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.cbor.internal.CborEncoder;
import kotlinx.serialization.cbor.internal.CborListWriter;
import kotlinx.serialization.cbor.internal.CborMapWriter;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010 \u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020'H\u0016\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b*\u0010+J+\u0010/\u001a\u00020\u000f\"\u0004\b\u0000\u0010,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000-2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b/\u00100J\u0017\u00102\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u000201H\u0016\u00a2\u0006\u0004\b2\u00103J\u0017\u00105\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u000204H\u0016\u00a2\u0006\u0004\b5\u00106J\u0017\u00107\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b7\u00108J\u001f\u00109\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b9\u0010\u001eJ\u000f\u0010:\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b:\u0010+R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010;R\u0016\u0010<\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u001a\u0010\u0005\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010>\u001a\u0004\b?\u0010@R\u0014\u0010D\u001a\u00020A8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006E"}, d2={"Lkotlinx/serialization/cbor/internal/CborWriter;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "Lkotlinx/serialization/cbor/Cbor;", "cbor", "Lkotlinx/serialization/cbor/internal/CborEncoder;", "encoder", "<init>", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/internal/CborEncoder;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/encoding/CompositeEncoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeEncoder;", "", "value", "", "encodeBoolean", "(Z)V", "", "encodeByte", "(B)V", "", "encodeChar", "(C)V", "", "encodeDouble", "(D)V", "", "index", "encodeElement", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Z", "enumDescriptor", "encodeEnum", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)V", "", "encodeFloat", "(F)V", "encodeInt", "(I)V", "", "encodeLong", "(J)V", "encodeNull", "()V", "T", "Lkotlinx/serialization/SerializationStrategy;", "serializer", "encodeSerializableValue", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "", "encodeShort", "(S)V", "", "encodeString", "(Ljava/lang/String;)V", "endStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "shouldEncodeElementDefault", "writeBeginToken", "Lkotlinx/serialization/cbor/Cbor;", "encodeByteArrayAsByteString", "Z", "Lkotlinx/serialization/cbor/internal/CborEncoder;", "getEncoder", "()Lkotlinx/serialization/cbor/internal/CborEncoder;", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "kotlinx-serialization-cbor"})
public class CborWriter
extends AbstractEncoder {
    @NotNull
    private final Cbor cbor;
    @NotNull
    private final CborEncoder encoder;
    private boolean encodeByteArrayAsByteString;

    public CborWriter(@NotNull Cbor cbor, @NotNull CborEncoder encoder2) {
        Intrinsics.checkNotNullParameter(cbor, "cbor");
        Intrinsics.checkNotNullParameter(encoder2, "encoder");
        this.cbor = cbor;
        this.encoder = encoder2;
    }

    @NotNull
    protected final CborEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.cbor.getSerializersModule();
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        if (this.encodeByteArrayAsByteString && Intrinsics.areEqual(serializer2.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.ByteArray");
            this.encoder.encodeByteString((byte[])value);
        } else {
            super.encodeSerializableValue(serializer2, value);
        }
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this.cbor.getEncodeDefaults$kotlinx_serialization_cbor();
    }

    protected void writeBeginToken() {
        this.encoder.startMap();
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        SerialKind serialKind = descriptor2.getKind();
        CborWriter writer = (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE) ? true : serialKind instanceof PolymorphicKind) ? (CborWriter)new CborListWriter(this.cbor, this.encoder) : (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE) ? (CborWriter)new CborMapWriter(this.cbor, this.encoder) : new CborWriter(this.cbor, this.encoder));
        writer.writeBeginToken();
        return writer;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encoder.end();
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor2, int index2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encodeByteArrayAsByteString = EncodingKt.access$isByteString(descriptor2, index2);
        String name = descriptor2.getElementName(index2);
        this.encoder.encodeString(name);
        return true;
    }

    @Override
    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.encoder.encodeString(value);
    }

    @Override
    public void encodeFloat(float value) {
        this.encoder.encodeFloat(value);
    }

    @Override
    public void encodeDouble(double value) {
        this.encoder.encodeDouble(value);
    }

    @Override
    public void encodeChar(char value) {
        this.encoder.encodeNumber(value);
    }

    @Override
    public void encodeByte(byte value) {
        this.encoder.encodeNumber(value);
    }

    @Override
    public void encodeShort(short value) {
        this.encoder.encodeNumber(value);
    }

    @Override
    public void encodeInt(int value) {
        this.encoder.encodeNumber(value);
    }

    @Override
    public void encodeLong(long value) {
        this.encoder.encodeNumber(value);
    }

    @Override
    public void encodeBoolean(boolean value) {
        this.encoder.encodeBoolean(value);
    }

    @Override
    public void encodeNull() {
        this.encoder.encodeNull();
    }

    @Override
    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index2) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        this.encoder.encodeString(enumDescriptor.getElementName(index2));
    }
}

