/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.cbor.internal.CborDecoder;
import kotlinx.serialization.cbor.internal.CborListReader;
import kotlinx.serialization.cbor.internal.CborMapReader;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001bJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b&\u0010\u000fJ\u0011\u0010(\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0004\b(\u0010)J#\u0010-\u001a\u00028\u0000\"\u0004\b\u0000\u0010*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u00100\u001a\u00020/H\u0016\u00a2\u0006\u0004\b0\u00101J\u000f\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b3\u00104J\u0017\u00106\u001a\u0002052\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b6\u00107J\u000f\u00108\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b8\u0010\u000fJ\u0017\u0010:\u001a\u0002052\u0006\u00109\u001a\u00020\u0019H\u0004\u00a2\u0006\u0004\b:\u0010;J\u000f\u0010<\u001a\u000205H\u0014\u00a2\u0006\u0004\b<\u0010=R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010>R\u0016\u0010?\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u001a\u0010\u0005\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010A\u001a\u0004\bB\u0010CR$\u0010E\u001a\u00020\r2\u0006\u0010D\u001a\u00020\r8\u0004@BX\u0084\u000e\u00a2\u0006\f\n\u0004\bE\u0010@\u001a\u0004\bF\u0010\u000fR\u0016\u0010G\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010HR\u0014\u0010L\u001a\u00020I8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR$\u00109\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00198\u0004@BX\u0084\u000e\u00a2\u0006\f\n\u0004\b9\u0010H\u001a\u0004\bM\u0010\"\u00a8\u0006N"}, d2={"Lkotlinx/serialization/cbor/internal/CborReader;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lkotlinx/serialization/cbor/Cbor;", "cbor", "Lkotlinx/serialization/cbor/internal/CborDecoder;", "decoder", "<init>", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/internal/CborDecoder;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "", "decodeBoolean", "()Z", "", "decodeByte", "()B", "", "decodeChar", "()C", "", "decodeDouble", "()D", "", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "enumDescriptor", "decodeEnum", "", "decodeFloat", "()F", "decodeInt", "()I", "", "decodeLong", "()J", "decodeNotNullMark", "", "decodeNull", "()Ljava/lang/Void;", "T", "Lkotlinx/serialization/DeserializationStrategy;", "deserializer", "decodeSerializableValue", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "", "decodeShort", "()S", "", "decodeString", "()Ljava/lang/String;", "", "endStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "isDone", "size", "setSize", "(I)V", "skipBeginToken", "()V", "Lkotlinx/serialization/cbor/Cbor;", "decodeByteArrayAsByteString", "Z", "Lkotlinx/serialization/cbor/internal/CborDecoder;", "getDecoder", "()Lkotlinx/serialization/cbor/internal/CborDecoder;", "<set-?>", "finiteMode", "getFiniteMode", "readProperties", "I", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "getSize", "kotlinx-serialization-cbor"})
public class CborReader
extends AbstractDecoder {
    @NotNull
    private final Cbor cbor;
    @NotNull
    private final CborDecoder decoder;
    private int size;
    private boolean finiteMode;
    private int readProperties;
    private boolean decodeByteArrayAsByteString;

    public CborReader(@NotNull Cbor cbor, @NotNull CborDecoder decoder) {
        Intrinsics.checkNotNullParameter(cbor, "cbor");
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        this.cbor = cbor;
        this.decoder = decoder;
        this.size = -1;
    }

    @NotNull
    protected final CborDecoder getDecoder() {
        return this.decoder;
    }

    protected final int getSize() {
        return this.size;
    }

    protected final boolean getFiniteMode() {
        return this.finiteMode;
    }

    protected final void setSize(int size) {
        if (size >= 0) {
            this.finiteMode = true;
            this.size = size;
        }
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.cbor.getSerializersModule();
    }

    protected void skipBeginToken() {
        this.setSize(this.decoder.startMap());
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        SerialKind serialKind = descriptor2.getKind();
        CborReader re = (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE) ? true : serialKind instanceof PolymorphicKind) ? (CborReader)new CborListReader(this.cbor, this.decoder) : (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE) ? (CborReader)new CborMapReader(this.cbor, this.decoder) : new CborReader(this.cbor, this.decoder));
        re.skipBeginToken();
        return re;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!this.finiteMode) {
            this.decoder.end();
        }
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int n;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.cbor.getIgnoreUnknownKeys$kotlinx_serialization_cbor()) {
            int index2;
            int knownIndex = 0;
            while (true) {
                if (this.isDone()) {
                    return -1;
                }
                String elemName = this.decoder.nextString();
                int n2 = this.readProperties;
                this.readProperties = n2 + 1;
                index2 = descriptor2.getElementIndex(elemName);
                if (index2 != -3) break;
                this.decoder.skipElement();
            }
            n = knownIndex = index2;
        } else {
            if (this.isDone()) {
                return -1;
            }
            String elemName = this.decoder.nextString();
            int n3 = this.readProperties;
            this.readProperties = n3 + 1;
            n = EncodingKt.access$getElementIndexOrThrow(descriptor2, elemName);
        }
        int index3 = n;
        this.decodeByteArrayAsByteString = EncodingKt.access$isByteString(descriptor2, index3);
        return index3;
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return (T)(this.decodeByteArrayAsByteString && Intrinsics.areEqual(deserializer.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor()) ? (Object)this.decoder.nextByteString() : super.decodeSerializableValue(deserializer));
    }

    @Override
    @NotNull
    public String decodeString() {
        return this.decoder.nextString();
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.decoder.isNull();
    }

    @Override
    public double decodeDouble() {
        return this.decoder.nextDouble();
    }

    @Override
    public float decodeFloat() {
        return this.decoder.nextFloat();
    }

    @Override
    public boolean decodeBoolean() {
        return this.decoder.nextBoolean();
    }

    @Override
    public byte decodeByte() {
        return (byte)this.decoder.nextNumber();
    }

    @Override
    public short decodeShort() {
        return (short)this.decoder.nextNumber();
    }

    @Override
    public char decodeChar() {
        return (char)this.decoder.nextNumber();
    }

    @Override
    public int decodeInt() {
        return (int)this.decoder.nextNumber();
    }

    @Override
    public long decodeLong() {
        return this.decoder.nextNumber();
    }

    @Override
    @Nullable
    public Void decodeNull() {
        return this.decoder.nextNull();
    }

    @Override
    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        return EncodingKt.access$getElementIndexOrThrow(enumDescriptor, this.decoder.nextString());
    }

    private final boolean isDone() {
        return !this.finiteMode && this.decoder.isEnd() || this.finiteMode && this.readProperties >= this.size;
    }
}

