/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.cbor.internal.ByteArrayInput;
import kotlinx.serialization.cbor.internal.CborDecodingException;
import kotlinx.serialization.cbor.internal.CborDecodingExceptionKt;
import kotlinx.serialization.cbor.internal.EncodingKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\n\n\u0002\b\u0018\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\r\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\r\u0010\u0012\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b \u0010!J\r\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010'\u001a\u00020\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060%H\u0002\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b)\u0010\bJ\u000f\u0010*\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b*\u0010\u0015J\u000f\u0010+\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b+\u0010\u0015J\u000f\u0010,\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b,\u0010\bJ\u000f\u0010-\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b-\u0010!J\u000f\u0010.\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b.\u0010!J\u000f\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0004\b0\u00101J\u0017\u00103\u001a\u00020\t2\u0006\u00102\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b3\u00104J\r\u00105\u001a\u00020\t\u00a2\u0006\u0004\b5\u0010\u000bJ\u000f\u00106\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b6\u0010\u000bJ\r\u00107\u001a\u00020\u0006\u00a2\u0006\u0004\b7\u0010\bJ\r\u00108\u001a\u00020\u0006\u00a2\u0006\u0004\b8\u0010\bJ'\u0010<\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b<\u0010=J\u001b\u0010?\u001a\u00020\u001f*\u00020\u00022\u0006\u0010>\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b?\u0010@J\u001b\u0010B\u001a\u00020\u0013*\u00020\u00022\u0006\u0010A\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\bB\u0010CR\u0016\u0010D\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010F\u00a8\u0006G"}, d2={"Lkotlinx/serialization/cbor/internal/CborDecoder;", "", "Lkotlinx/serialization/cbor/internal/ByteArrayInput;", "input", "<init>", "(Lkotlinx/serialization/cbor/internal/ByteArrayInput;)V", "", "elementLength", "()I", "", "end", "()V", "", "isEnd", "()Z", "isEof", "isIndefinite", "isNull", "nextBoolean", "", "nextByteString", "()[B", "", "nextDouble", "()D", "", "nextFloat", "()F", "", "nextNull", "()Ljava/lang/Void;", "", "nextNumber", "()J", "", "nextString", "()Ljava/lang/String;", "", "lengthStack", "prune", "(Ljava/util/List;)V", "readByte", "readBytes", "readIndefiniteLengthBytes", "readInt", "readLong", "readNumber", "", "readShort", "()S", "expected", "skipByte", "(I)V", "skipElement", "skipOverTags", "startArray", "startMap", "unboundedHeader", "boundedHeaderMask", "collectionType", "startSized", "(IILjava/lang/String;)I", "bytes", "readExact", "(Lkotlinx/serialization/cbor/internal/ByteArrayInput;I)J", "bytesCount", "readExactNBytes", "(Lkotlinx/serialization/cbor/internal/ByteArrayInput;I)[B", "curByte", "I", "Lkotlinx/serialization/cbor/internal/ByteArrayInput;", "kotlinx-serialization-cbor"})
public final class CborDecoder {
    @NotNull
    private final ByteArrayInput input;
    private int curByte;

    public CborDecoder(@NotNull ByteArrayInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        this.input = input;
        this.curByte = -1;
        this.readByte();
    }

    private final int readByte() {
        this.curByte = this.input.read();
        return this.curByte;
    }

    public final boolean isEof() {
        return this.curByte == -1;
    }

    private final void skipByte(int expected) {
        if (this.curByte != expected) {
            throw CborDecodingExceptionKt.CborDecodingException("byte " + CborDecodingExceptionKt.printByte(expected), this.curByte);
        }
        this.readByte();
    }

    public final boolean isNull() {
        return this.curByte == 246;
    }

    @Nullable
    public final Void nextNull() {
        this.skipOverTags();
        this.skipByte(246);
        return null;
    }

    public final boolean nextBoolean() {
        boolean bl;
        this.skipOverTags();
        switch (this.curByte) {
            case 245: {
                bl = true;
                break;
            }
            case 244: {
                bl = false;
                break;
            }
            default: {
                throw CborDecodingExceptionKt.CborDecodingException("boolean value", this.curByte);
            }
        }
        boolean ans = bl;
        this.readByte();
        return ans;
    }

    public final int startArray() {
        return this.startSized(159, 128, "array");
    }

    public final int startMap() {
        return this.startSized(191, 160, "map");
    }

    private final int startSized(int unboundedHeader, int boundedHeaderMask, String collectionType) {
        this.skipOverTags();
        if (this.curByte == unboundedHeader) {
            this.skipByte(unboundedHeader);
            return -1;
        }
        if ((this.curByte & 0xE0) != boundedHeaderMask) {
            throw CborDecodingExceptionKt.CborDecodingException("start of " + collectionType, this.curByte);
        }
        int size = (int)this.readNumber();
        this.readByte();
        return size;
    }

    public final boolean isEnd() {
        return this.curByte == 255;
    }

    public final void end() {
        this.skipByte(255);
    }

    @NotNull
    public final byte[] nextByteString() {
        this.skipOverTags();
        if ((this.curByte & 0xE0) != 64) {
            throw CborDecodingExceptionKt.CborDecodingException("start of byte string", this.curByte);
        }
        byte[] arr = this.readBytes();
        this.readByte();
        return arr;
    }

    @NotNull
    public final String nextString() {
        this.skipOverTags();
        if ((this.curByte & 0xE0) != 96) {
            throw CborDecodingExceptionKt.CborDecodingException("start of string", this.curByte);
        }
        byte[] arr = this.readBytes();
        String ans = StringsKt.decodeToString(arr);
        this.readByte();
        return ans;
    }

    private final byte[] readBytes() {
        byte[] byArray;
        if ((this.curByte & 0x1F) == 31) {
            this.readByte();
            byArray = this.readIndefiniteLengthBytes();
        } else {
            int strLen = (int)this.readNumber();
            byArray = this.readExactNBytes(this.input, strLen);
        }
        return byArray;
    }

    private final void skipOverTags() {
        while ((this.curByte & 0xE0) == 192) {
            this.readNumber();
            this.readByte();
        }
    }

    public final long nextNumber() {
        this.skipOverTags();
        long res = this.readNumber();
        this.readByte();
        return res;
    }

    private final long readNumber() {
        int bytesToRead;
        int value = this.curByte & 0x1F;
        boolean negative = (this.curByte & 0xE0) == 32;
        switch (value) {
            case 24: {
                int n = 1;
                break;
            }
            case 25: {
                int n = 2;
                break;
            }
            case 26: {
                int n = 4;
                break;
            }
            case 27: {
                int n = 8;
                break;
            }
            default: {
                int n = bytesToRead = 0;
            }
        }
        if (bytesToRead == 0) {
            return negative ? -((long)(value + 1)) : (long)value;
        }
        long res = this.readExact(this.input, bytesToRead);
        return negative ? -(res + 1L) : res;
    }

    private final long readExact(ByteArrayInput $this$readExact, int bytes) {
        byte[] arr = this.readExactNBytes($this$readExact, bytes);
        long result2 = 0L;
        for (int i = 0; i < bytes; ++i) {
            result2 = result2 << 8 | (long)(arr[i] & 0xFF);
        }
        return result2;
    }

    private final byte[] readExactNBytes(ByteArrayInput $this$readExactNBytes, int bytesCount) {
        if (bytesCount > $this$readExactNBytes.getAvailableBytes()) {
            throw new IllegalStateException(("Unexpected EOF, available " + $this$readExactNBytes.getAvailableBytes() + " bytes, requested: " + bytesCount).toString());
        }
        byte[] array = new byte[bytesCount];
        $this$readExactNBytes.read(array, 0, bytesCount);
        return array;
    }

    public final float nextFloat() {
        float f;
        this.skipOverTags();
        switch (this.curByte) {
            case 250: {
                f = Float.intBitsToFloat(this.readInt());
                break;
            }
            case 249: {
                f = EncodingKt.access$floatFromHalfBits(this.readShort());
                break;
            }
            default: {
                throw CborDecodingExceptionKt.CborDecodingException("float header", this.curByte);
            }
        }
        float res = f;
        this.readByte();
        return res;
    }

    public final double nextDouble() {
        double d;
        this.skipOverTags();
        switch (this.curByte) {
            case 251: {
                d = Double.longBitsToDouble(this.readLong());
                break;
            }
            case 250: {
                d = Float.intBitsToFloat(this.readInt());
                break;
            }
            case 249: {
                d = EncodingKt.access$floatFromHalfBits(this.readShort());
                break;
            }
            default: {
                throw CborDecodingExceptionKt.CborDecodingException("double header", this.curByte);
            }
        }
        double res = d;
        this.readByte();
        return res;
    }

    private final long readLong() {
        long result2 = 0L;
        for (int i = 0; i < 8; ++i) {
            int n = this.input.read();
            result2 = result2 << 8 | (long)n;
        }
        return result2;
    }

    private final short readShort() {
        int highByte = this.input.read();
        int lowByte = this.input.read();
        return (short)(highByte << 8 | lowByte);
    }

    private final int readInt() {
        int result2 = 0;
        for (int i = 0; i < 4; ++i) {
            int n = this.input.read();
            result2 = result2 << 8 | n;
        }
        return result2;
    }

    public final void skipElement() {
        List lengthStack = new ArrayList();
        this.skipOverTags();
        do {
            if (this.isEof()) {
                throw new CborDecodingException("Unexpected EOF while skipping element");
            }
            if (this.isIndefinite()) {
                lengthStack.add(-1);
            } else if (this.isEnd()) {
                Integer n = (Integer)CollectionsKt.removeLastOrNull(lengthStack);
                int n2 = -1;
                if (n == null || n != n2) {
                    throw CborDecodingExceptionKt.CborDecodingException("next data item", this.curByte);
                }
                this.prune(lengthStack);
            } else {
                int header = this.curByte & 0xE0;
                int length = this.elementLength();
                switch (header) {
                    case 128: 
                    case 160: {
                        if (length > 0) {
                            lengthStack.add(length);
                        }
                        this.skipOverTags();
                        break;
                    }
                    default: {
                        this.input.skip(length);
                        this.prune(lengthStack);
                    }
                }
            }
            this.readByte();
        } while (!((Collection)lengthStack).isEmpty());
    }

    private final void prune(List<Integer> lengthStack) {
        block4: for (int i = CollectionsKt.getLastIndex(lengthStack); -1 < i; --i) {
            switch (((Number)lengthStack.get(i)).intValue()) {
                case -1: {
                    break block4;
                }
                case 1: {
                    lengthStack.remove(i);
                    continue block4;
                }
                default: {
                    lengthStack.set(i, ((Number)lengthStack.get(i)).intValue() - 1);
                    break block4;
                }
            }
        }
    }

    private final boolean isIndefinite() {
        int majorType = this.curByte & 0xE0;
        int value = this.curByte & 0x1F;
        return value == 31 && (majorType == 128 || majorType == 160 || majorType == 64 || majorType == 96);
    }

    private final int elementLength() {
        int n;
        int majorType = this.curByte & 0xE0;
        int additionalInformation = this.curByte & 0x1F;
        block0 : switch (majorType) {
            case 64: 
            case 96: 
            case 128: {
                n = (int)this.readNumber();
                break;
            }
            case 160: {
                n = (int)this.readNumber() * 2;
                break;
            }
            default: {
                switch (additionalInformation) {
                    case 24: {
                        n = 1;
                        break block0;
                    }
                    case 25: {
                        n = 2;
                        break block0;
                    }
                    case 26: {
                        n = 4;
                        break block0;
                    }
                    case 27: {
                        n = 8;
                        break block0;
                    }
                }
                n = 0;
            }
        }
        return n;
    }

    private final byte[] readIndefiniteLengthBytes() {
        List byteStrings = new ArrayList();
        do {
            byteStrings.add(this.readBytes());
            this.readByte();
        } while (!this.isEnd());
        return EncodingKt.access$flatten(byteStrings);
    }
}

