/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\bR\u0016\u0010\u0012\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "", "<init>", "()V", "", "elementsToAppend", "", "ensureCapacity", "(I)V", "", "toByteArray", "()[B", "buffer", "offset", "count", "write", "([BII)V", "byteValue", "array", "[B", "position", "I", "kotlinx-serialization-cbor"})
public final class ByteArrayOutput {
    @NotNull
    private byte[] array = new byte[32];
    private int position;

    private final void ensureCapacity(int elementsToAppend) {
        if (this.position + elementsToAppend <= this.array.length) {
            return;
        }
        byte[] newArray = new byte[Integer.highestOneBit(this.position + elementsToAppend) << 1];
        ArraysKt.copyInto$default(this.array, newArray, 0, 0, 0, 14, null);
        this.array = newArray;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] newArray = new byte[this.position];
        ArraysKt.copyInto$default(this.array, newArray, 0, 0, this.position, 2, null);
        return newArray;
    }

    public final void write(@NotNull byte[] buffer, int offset, int count2) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        if (offset < 0 || offset > buffer.length || count2 < 0 || count2 > buffer.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (count2 == 0) {
            return;
        }
        this.ensureCapacity(count2);
        ArraysKt.copyInto(buffer, this.array, this.position, offset, offset + count2);
        this.position += count2;
    }

    public static /* synthetic */ void write$default(ByteArrayOutput byteArrayOutput, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        byteArrayOutput.write(byArray, n, n2);
    }

    public final void write(int byteValue) {
        this.ensureCapacity(1);
        int n = this.position;
        this.position = n + 1;
        this.array[n] = (byte)byteValue;
    }
}

