/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils.hypixel;

import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.events.event.ChatReceiveEvent;
import cc.polyfrost.oneconfig.events.event.ChatSendEvent;
import cc.polyfrost.oneconfig.events.event.LocrawEvent;
import cc.polyfrost.oneconfig.events.event.Stage;
import cc.polyfrost.oneconfig.events.event.TickEvent;
import cc.polyfrost.oneconfig.events.event.WorldLoadEvent;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.libs.universal.UChat;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.utils.TickDelay;
import cc.polyfrost.oneconfig.utils.hypixel.HypixelUtils;
import cc.polyfrost.oneconfig.utils.hypixel.LocrawInfo;
import com.google.gson.Gson;
import org.jetbrains.annotations.Nullable;

public class LocrawUtil {
    public static final LocrawUtil INSTANCE = new LocrawUtil();
    private final Gson GSON = new Gson();
    private LocrawInfo locrawInfo;
    private LocrawInfo lastLocrawInfo;
    private boolean listening;
    private int tick;
    private boolean playerSentCommand = false;
    private boolean inGame = false;

    void initialize() {
        EventManager.INSTANCE.register(this);
    }

    private void sendLocraw(boolean delay) {
        new TickDelay(() -> {
            this.listening = true;
            UChat.say("/locraw");
        }, delay ? 20 : 0);
    }

    @Subscribe
    private void onTick(TickEvent event) {
        if (event.stage != Stage.START || !Platform.getServerPlatform().doesPlayerExist() || !HypixelUtils.INSTANCE.isHypixel()) {
            return;
        }
        ++this.tick;
        if (this.tick == 40 || this.tick % 1300 == 0) {
            this.sendLocraw(false);
        }
    }

    @Subscribe
    private void onWorldLoad(WorldLoadEvent event) {
        if (this.locrawInfo != null) {
            this.lastLocrawInfo = this.locrawInfo;
        }
        this.locrawInfo = null;
        this.tick = 0;
    }

    @Subscribe
    private void onMessageSent(ChatSendEvent event) {
        if (event.message.startsWith("/locraw") && !this.listening) {
            this.playerSentCommand = true;
        }
    }

    @Subscribe
    private void onMessageReceived(ChatReceiveEvent event) {
        try {
            String msg = event.getFullyUnformattedMessage();
            if (msg.startsWith("You are sending too many commands! Please try again in a few seconds.")) {
                this.sendLocraw(true);
                return;
            }
            if (msg.startsWith("{")) {
                this.locrawInfo = (LocrawInfo)this.GSON.fromJson(msg, LocrawInfo.class);
                if (this.locrawInfo != null) {
                    this.locrawInfo.setGameType(LocrawInfo.GameType.getFromLocraw(this.locrawInfo.getRawGameType()));
                    boolean bl = this.inGame = !this.locrawInfo.getGameMode().equals("lobby");
                    if (!this.playerSentCommand) {
                        event.isCancelled = true;
                    }
                    EventManager.INSTANCE.post(new LocrawEvent(this.locrawInfo));
                    this.playerSentCommand = false;
                    this.listening = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInGame() {
        return this.inGame;
    }

    @Nullable
    public LocrawInfo getLocrawInfo() {
        return this.locrawInfo;
    }

    @Nullable
    public LocrawInfo getLastLocrawInfo() {
        return this.lastLocrawInfo;
    }
}

