/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils.hypixel;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Objects;

public class LocrawInfo
implements Serializable {
    @SerializedName(value="server")
    private String serverId;
    @SerializedName(value="mode")
    private String gameMode = "lobby";
    @SerializedName(value="map")
    private String mapName;
    @SerializedName(value="gametype")
    private String rawGameType;
    private GameType gameType;

    public String getServerId() {
        return this.serverId;
    }

    public String getRawGameType() {
        if (this.rawGameType == null) {
            this.rawGameType = "UNKNOWN";
        }
        return this.rawGameType;
    }

    public String getGameMode() {
        return this.gameMode;
    }

    public GameType getGameType() {
        return this.gameType;
    }

    public void setGameType(GameType gameType) {
        this.gameType = gameType;
    }

    public String getMapName() {
        return this.mapName;
    }

    public String toString() {
        return "LocrawInfo{serverId='" + this.serverId + '\'' + ", gameMode='" + this.gameMode + '\'' + ", mapName='" + this.mapName + '\'' + ", rawGameType='" + this.rawGameType + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocrawInfo that = (LocrawInfo)o;
        return Objects.equals(this.serverId, that.serverId) && Objects.equals(this.gameMode, that.gameMode) && Objects.equals(this.mapName, that.mapName) && Objects.equals(this.rawGameType, that.rawGameType);
    }

    public int hashCode() {
        return Objects.hash(this.serverId, this.gameMode, this.mapName, this.rawGameType);
    }

    public static enum GameType {
        UNKNOWN(""),
        LIMBO("LIMBO"),
        BEDWARS("BEDWARS"),
        SKYWARS("SKYWARS"),
        PROTOTYPE("PROTOTYPE"),
        SKYBLOCK("SKYBLOCK"),
        MAIN("MAIN"),
        MURDER_MYSTERY("MURDER_MYSTERY"),
        HOUSING("HOUSING"),
        ARCADE_GAMES("ARCADE"),
        BUILD_BATTLE("BUILD_BATTLE"),
        DUELS("DUELS"),
        PIT("PIT"),
        UHC_CHAMPIONS("UHC"),
        SPEED_UHC("SPEED_UHC"),
        TNT_GAMES("TNTGAMES"),
        CLASSIC_GAMES("LEGACY"),
        COPS_AND_CRIMS("MCGO"),
        BLITZ_SG("SURVIVAL_GAMES"),
        MEGA_WALLS("WALLS3"),
        SMASH_HEROES("SUPER_SMASH"),
        WARLORDS("BATTLEGROUND"),
        DROPPER(""),
        WOOL_WARS("WOOL_GAMES"),
        VAMPIREZ("VAMPIREZ"),
        PAINTBALL("PAINTBALL"),
        QUAKE("QUAKECRAFT"),
        WALLS("WALLS"),
        TURBO_KART_RACERS("GINGERBREAD"),
        ARENA("ARENA"),
        REPLAY("REPLAY");

        private final String serverName;

        private GameType(String serverName) {
            this.serverName = serverName;
        }

        public static GameType getFromLocraw(String gameType) {
            if (gameType == null) {
                return UNKNOWN;
            }
            for (GameType value : GameType.values()) {
                if (!value.serverName.equals(gameType)) continue;
                return value;
            }
            return UNKNOWN;
        }

        public String getServerName() {
            return this.serverName;
        }
    }
}

