/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils.gui;

import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.events.event.RenderEvent;
import cc.polyfrost.oneconfig.events.event.Stage;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.libs.universal.UMinecraft;
import cc.polyfrost.oneconfig.libs.universal.UScreen;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.utils.TickDelay;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.client.gui.GuiScreen;

public final class GuiUtils {
    private static long time = -1L;
    private static long deltaTime = 17L;
    private static boolean wasMouseDown = false;
    private static final Deque<Optional<GuiScreen>> screenQueue = new ConcurrentLinkedDeque<Optional<GuiScreen>>();

    @Deprecated
    public static void displayScreen(Object screen) {
        GuiUtils.displayScreen((GuiScreen)screen);
    }

    public static void displayScreen(GuiScreen screen) {
        GuiUtils.displayScreen(screen, screen instanceof OneConfigGui ? 2 : 1);
    }

    public static void displayScreen(GuiScreen screen, int ticks) {
        Optional<Object> optional = screen == null ? Optional.empty() : Optional.of(screen);
        screenQueue.add(optional);
        new TickDelay(() -> {
            UScreen.displayScreen(optional.orElse(null));
            screenQueue.remove(optional);
        }, ticks);
    }

    public static Deque<Optional<GuiScreen>> getScreenQueue() {
        return screenQueue;
    }

    public static void closeScreen() {
        UScreen.displayScreen(null);
    }

    public static float getDeltaTime() {
        return deltaTime;
    }

    public static boolean wasMouseDown() {
        return wasMouseDown;
    }

    @Subscribe
    private void onRenderEvent(RenderEvent event) {
        if (event.stage == Stage.START) {
            if (time == -1L) {
                time = UMinecraft.getTime();
            } else {
                long currentTime = UMinecraft.getTime();
                deltaTime = currentTime - time;
                time = currentTime;
            }
        } else if (event.stage == Stage.END) {
            wasMouseDown = Platform.getMousePlatform().isButtonDown(0);
        }
    }

    static {
        EventManager.INSTANCE.register(new GuiUtils());
    }
}

