/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils.commands.arguments;

import cc.polyfrost.oneconfig.utils.NetworkUtils;
import cc.polyfrost.oneconfig.utils.commands.arguments.ArgumentParser;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerArgumentParser
extends ArgumentParser<GameProfile> {
    private static final HashMap<String, UUID> uuidCache = new HashMap();

    @Override
    @Nullable
    public GameProfile parse(@NotNull String arg) {
        List<GameProfile> matchingPlayers = PlayerArgumentParser.getMatchingPlayers(arg, false);
        Iterator<GameProfile> iterator2 = matchingPlayers.iterator();
        if (iterator2.hasNext()) {
            GameProfile profile = iterator2.next();
            return profile;
        }
        return new GameProfile(PlayerArgumentParser.getUUID(arg), arg);
    }

    private static UUID getUUID(String name) {
        try {
            if (uuidCache.containsKey(name)) {
                return uuidCache.get(name);
            }
            JsonObject json = NetworkUtils.getJsonElement("https://api.mojang.com/users/profiles/minecraft/" + name).getAsJsonObject();
            if (json.has("error")) {
                return null;
            }
            UUID uuid = UUID.fromString(json.get("id").getAsString().replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
            uuidCache.put(name, uuid);
            return uuid;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<GameProfile> getMatchingPlayers(String arg, boolean startWith) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return Lists.newArrayList();
        }
        return Minecraft.func_71410_x().func_147114_u().func_175106_d().stream().map(NetworkPlayerInfo::func_178845_a).filter(gameProfile -> {
            String name = gameProfile.getName().toLowerCase();
            if (name.startsWith("!")) {
                return false;
            }
            return startWith ? name.startsWith(arg.toLowerCase()) : name.equals(arg.toLowerCase());
        }).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<String> complete(String current, Parameter parameter) {
        return PlayerArgumentParser.getMatchingPlayers(current, true).stream().map(GameProfile::getName).collect(Collectors.toList());
    }
}

